<?php
// /admin/api_live_online_count.php
require_once __DIR__ . '/../partials/admin_guard.php'; // garantisce accesso admin e $pdo (PDO)

if (!headers_sent()) header('Content-Type: application/json; charset=UTF-8');

// finestra di "presenza" in secondi (default 70)
$window = (int)($_GET['since'] ?? 70);
if ($window < 30)  $window = 30;
if ($window > 600) $window = 600;

// pulizia vecchie presenze (qualche secondo in più di margine)
$cleanup = $window + 10;
try {
  $pdo->exec("DELETE FROM live_presence WHERE updated_at < (NOW() - INTERVAL {$cleanup} SECOND)");
} catch (Throwable $e) {
  // non bloccare la risposta per un errore di pulizia
}

// conteggio totale e per-live
try {
  $stmt = $pdo->query("SELECT COUNT(*) FROM live_presence WHERE updated_at >= (NOW() - INTERVAL {$window} SECOND)");
  $total = (int)$stmt->fetchColumn();

  $items = [];
  $q = $pdo->query("
      SELECT live_id, COUNT(*) AS c
      FROM live_presence
      WHERE updated_at >= (NOW() - INTERVAL {$window} SECOND)
      GROUP BY live_id
      ORDER BY c DESC
  ");
  while ($row = $q->fetch(PDO::FETCH_ASSOC)) {
    $items[] = ['live_id' => (int)$row['live_id'], 'count' => (int)$row['c']];
  }

  echo json_encode(['ok' => true, 'total' => $total, 'items' => $items, 'window' => $window]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'error' => 'DB error']);
}
