<?php
// /admin/api_payment_create.php
require_once __DIR__.'/../partials/admin_guard.php';
if (!headers_sent()) header('Content-Type: application/json; charset=UTF-8');

function fail($m){ echo json_encode(['ok'=>false,'error'=>$m]); exit; }

try{
  $uid = (int)($_POST['user_id'] ?? 0);
  if($uid<=0) fail('user_id mancante');

  // utente esiste?
  $st=$pdo->prepare("SELECT subscription_until FROM users WHERE id=?");
  $st->execute([$uid]);
  $usr=$st->fetch();
  if(!$usr) fail('Utente inesistente');

  // amount (accetta virgola)
  $amount_raw = trim((string)($_POST['amount'] ?? ''));
  $amount_str = str_replace(',', '.', $amount_raw);
  if($amount_str==='') fail('Importo mancante');
  if(!is_numeric($amount_str)) fail('Importo non valido');
  $amount = round((float)$amount_str, 2);

  $currency = strtoupper(substr(trim((string)($_POST['currency'] ?? 'EUR')),0,8)) ?: 'EUR';
  $method   = substr(trim((string)($_POST['method'] ?? '')),0,50);
  $status   = $_POST['status'] ?? 'paid';
  $allowed  = ['paid','pending','failed','refunded'];
  if(!in_array($status,$allowed,true)) $status='paid';

  // Periodo
  $pf = trim((string)($_POST['period_from'] ?? ''));
  $pt = trim((string)($_POST['period_to'] ?? ''));
  $pfv = $pf!=='' ? DateTime::createFromFormat('Y-m-d',$pf) : false;
  $ptv = $pt!=='' ? DateTime::createFromFormat('Y-m-d',$pt) : false;
  $period_from = $pfv ? $pfv->format('Y-m-d') : null;
  $period_to   = $ptv ? $ptv->format('Y-m-d') : null;

  $note = substr(trim((string)($_POST['note'] ?? '')),0,255);

  // Inserisci pagamento
  $ins = $pdo->prepare("
    INSERT INTO payments (user_id,amount,currency,method,status,period_from,period_to,note)
    VALUES (?,?,?,?,?,?,?,?)
  ");
  $ins->execute([$uid,$amount,$currency,$method,$status,$period_from,$period_to,$note]);
  $pid = (int)$pdo->lastInsertId();

  // Aggiorna scadenza se pagamento eseguito e abbiamo un period_to
  $newSub = $usr['subscription_until']; // valore corrente (stringa o null)

  if ($status === 'paid' && $period_to !== null) {
    // fine giornata del period_to
    $end = $period_to.' 23:59:59';

    // prendi il valore attuale in modo "sicuro" (zero-date -> NULL)
    $cur = $usr['subscription_until'];
    $cur_ts = $cur ? strtotime($cur) : 0;
    if ($cur_ts <= 0 || strtotime($end) > $cur_ts) {
      $pdo->prepare("UPDATE users SET subscription_until=? WHERE id=?")->execute([$end,$uid]);
      $newSub = $end;
    }
  }

  echo json_encode([
    'ok'=>true,
    'id'=>$pid,
    'user_id'=>$uid,
    'new_subscription_until'=>$newSub
  ]);
}catch(Throwable $e){
  echo json_encode(['ok'=>false,'error'=>'Server error']);
}
