<?php
// /admin/api_user_devices.php
require_once __DIR__ . '/../partials/admin_guard.php';
if (!headers_sent()) header('Content-Type: application/json; charset=UTF-8');

$user_id = (int)($_GET['user_id'] ?? 0);
$out = ['items' => []];

function device_label(string $ua): string {
  $u = strtolower($ua);
  if (str_contains($u,'iphone')) return 'iPhone';
  if (str_contains($u,'ipad')) return 'iPad';
  if (str_contains($u,'android')) return 'Android';
  if (str_contains($u,'windows')) return 'Windows';
  if (str_contains($u,'mac os') || str_contains($u,'macintosh')) return 'Mac';
  if (str_contains($u,'linux')) return 'Linux';
  return 'Dispositivo';
}

try {
  if ($user_id > 0) {
    $st = $pdo->prepare("
      SELECT id, user_id, device_key, ip, user_agent, created_at, last_seen
      FROM user_devices
      WHERE user_id = ?
      ORDER BY COALESCE(last_seen, created_at) DESC, id DESC
      LIMIT 200
    ");
    $st->execute([$user_id]);
    foreach ($st->fetchAll() ?: [] as $r) {
      $out['items'][] = [
        'id'         => (int)$r['id'],
        'ip'         => $r['ip'] ?? '',
        'user_agent' => $r['user_agent'] ?? '',
        'device_name'=> device_label($r['user_agent'] ?? ''), // etichetta “amichevole”
        'created_at' => $r['created_at'] ?? '',
        'last_seen'  => $r['last_seen'] ?? '',
        'device_key' => $r['device_key'] ?? '',
      ];
    }
  }
} catch (Throwable $e) {
  // non rompiamo la UI: ritorniamo lista vuota
  http_response_code(200);
  echo json_encode(['items'=>[]]);
  exit;
}

echo json_encode($out);
