<?php
require_once __DIR__.'/../partials/admin_guard.php';
if (!headers_sent()) header('Content-Type: application/json; charset=UTF-8');

try{
  if($_SERVER['REQUEST_METHOD']==='GET'){
    $uid = (int)($_GET['user_id'] ?? 0);
    if($uid<=0){ echo json_encode(['items'=>[]]); exit; }

    $st = $pdo->prepare("
      SELECT id,created_at,amount,currency,method,status,period_from,period_to,note
      FROM payments WHERE user_id=? ORDER BY created_at DESC, id DESC
    ");
    $st->execute([$uid]);
    $rows = $st->fetchAll() ?: [];

    $items = array_map(function($r){
      return [
        'id'         => (int)$r['id'],
        'created_at' => $r['created_at'],
        'amount'     => (float)$r['amount'],
        'currency'   => $r['currency'],
        'method'     => $r['method'],
        'status'     => $r['status'],
        'period_from'=> $r['period_from'],
        'period_to'  => $r['period_to'],
        'note'       => $r['note'],
      ];
    }, $rows);

    echo json_encode(['items'=>$items], JSON_UNESCAPED_UNICODE);
    exit;
  }

  if($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action'] ?? '')==='delete'){
    $id  = (int)($_POST['id'] ?? 0);
    $uid = (int)($_POST['user_id'] ?? 0);
    if($id>0 && $uid>0){
      $st = $pdo->prepare("DELETE FROM payments WHERE id=? AND user_id=?");
      $st->execute([$id,$uid]);
      echo json_encode(['ok'=>true]); exit;
    }
    echo json_encode(['ok'=>false,'error'=>'Parametri non validi']); exit;
  }

  echo json_encode(['ok'=>false,'error'=>'Metodo non valido']); exit;
}catch(Throwable $e){
  echo json_encode(['ok'=>false,'error'=>'Server error']);
}
