<?php
$page_title='Categorie';
require_once __DIR__.'/../partials/admin_guard.php';
require_once __DIR__.'/../partials/header.php';

function slugify($s){ $s = strtolower(preg_replace('/[^a-z0-9]+/i','-',$s)); return trim($s,'-'); }
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function markQ($s,$q){ if($q==='') return h($s); $safe=h($s); $sq=h($q); return str_ireplace($sq, '<mark>'.$sq.'</mark>', $safe); }

/* ======================
   CREATE / UPDATE / DELETE / SET ORDER / TOGGLE HIDDEN
   ====================== */
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create'])){
    $name = trim($_POST['name']);
    $slug = slugify($name);
    $ord  = (int)($_POST['sort_order'] ?? 0);
    $is_hidden = !empty($_POST['is_hidden']) ? 1 : 0;

    $imgPath = null;
    if(!empty($_FILES['image']['name']) && is_uploaded_file($_FILES['image']['tmp_name'])){
      @mkdir($_SERVER['DOCUMENT_ROOT'].'/uploads', 0775, true);
      $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION) ?: 'jpg';
      $ext = preg_replace('/[^a-z0-9]/i','',$ext) ?: 'jpg';
      $fname = '/uploads/cat_'.time().'_'.bin2hex(random_bytes(2)).'.'.$ext;
      if(move_uploaded_file($_FILES['image']['tmp_name'], $_SERVER['DOCUMENT_ROOT'].$fname)){ $imgPath = $fname; }
    }

    $stmt=$pdo->prepare("INSERT INTO categories(name,slug,image_path,sort_order,is_hidden) VALUES (?,?,?,?,?)");
    $stmt->execute([$name,$slug,$imgPath,$ord,$is_hidden]);

  } elseif(isset($_POST['update'])){
    $id   = (int)$_POST['id'];
    $name = trim($_POST['name']);
    $slug = slugify($name);
    $ord  = (int)($_POST['sort_order'] ?? 0);
    $is_hidden = !empty($_POST['is_hidden']) ? 1 : 0;

    $imgPath = $_POST['current_image'] ?? null;
    if(!empty($_FILES['image']['name']) && is_uploaded_file($_FILES['image']['tmp_name'])){
      @mkdir($_SERVER['DOCUMENT_ROOT'].'/uploads', 0775, true);
      $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION) ?: 'jpg';
      $ext = preg_replace('/[^a-z0-9]/i','',$ext) ?: 'jpg';
      $fname = '/uploads/cat_'.time().'_'.bin2hex(random_bytes(2)).'.'.$ext;
      if(move_uploaded_file($_FILES['image']['tmp_name'], $_SERVER['DOCUMENT_ROOT'].$fname)){ $imgPath = $fname; }
    }

    $stmt=$pdo->prepare("UPDATE categories SET name=?, slug=?, image_path=?, sort_order=?, is_hidden=? WHERE id=?");
    $stmt->execute([$name,$slug,$imgPath,$ord,$is_hidden,$id]);

  } elseif(isset($_POST['set_order'])){
    $id  = (int)$_POST['id'];
    $ord = (int)$_POST['sort_order'];
    $pdo->prepare("UPDATE categories SET sort_order=? WHERE id=?")->execute([$ord,$id]);

  } elseif(isset($_POST['toggle_hidden'])){
    $id  = (int)$_POST['id'];
    $pdo->prepare("UPDATE categories SET is_hidden = 1 - is_hidden WHERE id=?")->execute([$id]);

  } elseif(isset($_POST['delete'])){
    $pdo->prepare("DELETE FROM categories WHERE id=?")->execute([(int)$_POST['id']]);
  }
}

/* ======================
   EDIT (prefill form)
   ====================== */
$edit = null;
if(isset($_GET['edit'])){
  $st = $pdo->prepare("SELECT * FROM categories WHERE id=?");
  $st->execute([(int)$_GET['edit']]);
  $edit = $st->fetch();
}

/* ======================
   FILTRI & RICERCA
   q: testo (nome/slug/ID)
   img: 1 (solo con immagine)
   hidden: '', '0' (visibili), '1' (nascoste)
   ====================== */
$q         = trim($_GET['q'] ?? '');
$withImage = isset($_GET['img']) ? 1 : 0;
$hiddenFilter = $_GET['hidden'] ?? ''; // '', '0', '1'

$where  = [];
$params = [];

if ($q !== '') {
  $where[] = "(name LIKE ? OR slug LIKE ? OR id = ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
  $params[] = ctype_digit($q) ? (int)$q : -1;
}
if ($withImage) {
  $where[] = "(image_path IS NOT NULL AND image_path <> '')";
}
if ($hiddenFilter === '0' || $hiddenFilter === '1') {
  $where[] = "is_hidden = ?";
  $params[] = (int)$hiddenFilter;
}

$sql = "SELECT * FROM categories";
if ($where) $sql .= " WHERE ".implode(' AND ',$where);
$sql .= " ORDER BY sort_order ASC, name ASC";

$st = $pdo->prepare($sql);
$st->execute($params);
$cats = $st->fetchAll();
?>

<style>
  mark{ background: #ffea7a; padding:0 .15em; border-radius:.2rem; }
  .filters-card{
    background:#f8f9fb; border:1px solid #e6e9ef; border-radius:.5rem; padding:.75rem .75rem .35rem;
  }
  @media (prefers-color-scheme: dark){
    .filters-card{ background:#171a1f; border-color:#2a2f38; }
    mark{ background:#8a6d0a; color:#fff; }
  }
</style>

<h4 class="mb-3">Categorie</h4>

<!-- =========== FILTRI =========== -->
<div class="filters-card mb-3">
  <form id="filters" method="get" class="row g-2 align-items-end">
    <div class="col-12 col-md-5">
      <label class="form-label">Cerca</label>
      <input type="search" class="form-control" name="q" value="<?=h($q)?>" placeholder="Nome, slug o ID">
    </div>
    <div class="col-6 col-md-2">
      <div class="form-check mt-4">
        <input class="form-check-input" type="checkbox" id="img" name="img" value="1" <?= $withImage?'checked':''; ?>>
        <label class="form-check-label" for="img">Solo con immagine</label>
      </div>
    </div>
    <div class="col-6 col-md-2">
      <label class="form-label">Visibilità</label>
      <select name="hidden" class="form-select">
        <option value=""  <?= $hiddenFilter==='' ? 'selected':''; ?>>Tutte</option>
        <option value="0" <?= $hiddenFilter==='0' ? 'selected':''; ?>>Visibili</option>
        <option value="1" <?= $hiddenFilter==='1' ? 'selected':''; ?>>Nascoste</option>
      </select>
    </div>
    <div class="col-12 col-md-3 d-flex gap-2">
      <button class="btn btn-primary w-100" type="submit">Filtra</button>
      <a class="btn btn-outline-secondary w-100" href="/admin/categories.php">Reset</a>
    </div>
  </form>
</div>

<p class="text-muted small mb-2"><?= count($cats) ?> risultato<?= count($cats)==1?'':'i' ?>.</p>

<script>
  // Auto-submit quando cambi i filtri checkbox/select
  document.getElementById('filters').addEventListener('change', function(e){
    if (e.target.matches('input[type="checkbox"], select')) this.submit();
  });
</script>

<?php if($edit): ?>
<form method="post" enctype="multipart/form-data" class="row g-2 mb-3 border rounded p-3 bg-light">
  <input type="hidden" name="id" value="<?=$edit['id']?>">
  <input type="hidden" name="current_image" value="<?=$edit['image_path']?>">

  <div class="col-3">
    <label class="form-label">Nome</label>
    <input name="name" class="form-control" value="<?=h($edit['name'])?>" required>
  </div>

  <div class="col-3">
    <label class="form-label">Immagine</label>
    <input type="file" name="image" class="form-control" accept="image/*">
  </div>

  <div class="col-2">
    <label class="form-label">Ordine</label>
    <input name="sort_order" type="number" class="form-control" value="<?= (int)($edit['sort_order'] ?? 0) ?>">
  </div>

  <div class="col-2">
    <label class="form-label">Nascondi ai clienti</label>
    <div class="form-check form-switch mt-1">
      <input class="form-check-input" type="checkbox" id="is_hidden" name="is_hidden" value="1" <?= !empty($edit['is_hidden'])?'checked':''; ?>>
      <label class="form-check-label" for="is_hidden">Categoria nascosta</label>
    </div>
  </div>

  <div class="col-2 d-flex align-items-end">
    <button name="update" class="btn btn-primary w-100">Salva</button>
  </div>

  <div class="col-12">
    <?php if($edit['image_path']): ?><img src="<?=$edit['image_path']?>" style="height:40px"><?php endif; ?>
  </div>
</form>
<?php else: ?>
<form method="post" enctype="multipart/form-data" class="row g-2 mb-3">
  <div class="col-4">
    <label class="form-label">Nome categoria</label>
    <input name="name" class="form-control" placeholder="Es. Sport" required>
  </div>

  <div class="col-3">
    <label class="form-label">Immagine</label>
    <input type="file" name="image" class="form-control" accept="image/*">
  </div>

  <div class="col-2">
    <label class="form-label">Ordine</label>
    <input name="sort_order" type="number" class="form-control" value="0">
  </div>

  <div class="col-2">
    <label class="form-label">Nascondi ai clienti</label>
    <div class="form-check form-switch mt-1">
      <input class="form-check-input" type="checkbox" id="is_hidden_new" name="is_hidden" value="1">
      <label class="form-check-label" for="is_hidden_new">Categoria nascosta</label>
    </div>
  </div>

  <div class="col-1 d-flex align-items-end">
    <button name="create" class="btn btn-primary w-100">Crea</button>
  </div>
</form>
<?php endif; ?>

<table class="table table-sm align-middle">
  <thead>
    <tr>
      <th style="width:60px">ID</th>
      <th>Nome</th>
      <th>Slug</th>
      <th style="width:100px">Visibilità</th>
      <th style="width:120px">Preview</th>
      <th style="width:160px">Ordine</th>
      <th style="width:280px">Azioni</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($cats as $c): ?>
    <tr>
      <td><?=$c['id']?></td>
      <td><?= markQ($c['name'], $q) ?></td>
      <td><?= markQ($c['slug'], $q) ?></td>
      <td>
        <?php if(!empty($c['is_hidden'])): ?>
          <span class="badge bg-secondary">Nascosta</span>
        <?php else: ?>
          <span class="badge bg-success">Visibile</span>
        <?php endif; ?>
      </td>
      <td><?php if($c['image_path']): ?><img src="<?=$c['image_path']?>" style="height:40px"><?php endif; ?></td>
      <td>
        <form method="post" class="d-flex gap-1">
          <input type="hidden" name="id" value="<?=$c['id']?>">
          <input type="number" name="sort_order" class="form-control form-control-sm" value="<?= (int)($c['sort_order'] ?? 0) ?>">
          <button name="set_order" class="btn btn-outline-secondary btn-sm">OK</button>
        </form>
      </td>
      <td class="d-flex flex-wrap gap-1">
        <a class="btn btn-outline-secondary btn-sm" href="/admin/categories.php?edit=<?=$c['id']?>">Modifica</a>

        <form method="post" class="m-0">
          <input type="hidden" name="id" value="<?=$c['id']?>">
          <button name="toggle_hidden" class="btn btn-outline-warning btn-sm">
            <?= !empty($c['is_hidden']) ? 'Mostra' : 'Nascondi' ?>
          </button>
        </form>

        <form method="post" class="m-0" onsubmit="return confirm('Eliminare questa categoria?');">
          <input type="hidden" name="id" value="<?=$c['id']?>">
          <button name="delete" class="btn btn-outline-danger btn-sm">Elimina</button>
        </form>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
