<?php
$page_title='Live Chat';
require_once __DIR__.'/../partials/admin_guard.php';
require_once __DIR__.'/../lib/livechat.php';
if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');

function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); }

$rows = $pdo->query("
  SELECT c.id, c.user_id, u.email, c.status, c.opened_at, c.last_msg_at
  FROM live_chats c JOIN users u ON u.id=c.user_id
  WHERE c.status='open'
  ORDER BY c.last_msg_at DESC
")->fetchAll();

require_once __DIR__.'/../partials/header.php';
?>
<style>
  .lc-admin{ max-width:1100px; margin:18px auto; }
  .card-lite{ border:1px solid rgba(0,0,0,.08); border-radius:14px; padding:14px; background:var(--body-bg,#fff);}
  html[data-theme="dark"] .card-lite{ background:#121416; border-color:rgba(255,255,255,.12)}
</style>
<div class="lc-admin container">
  <h4 class="mb-2">Live Chat</h4>
  <div class="card-lite">
    <table class="table table-sm align-middle mb-0">
      <thead><tr><th>ID</th><th>Utente</th><th>Stato</th><th>Aperta</th><th>Ultimo messaggio</th><th></th></tr></thead>
      <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?= (int)$r['id'] ?></td>
          <td><?= h($r['email']) ?> (#<?= (int)$r['user_id'] ?>)</td>
          <td><span class="badge text-bg-success"><?= h($r['status']) ?></span></td>
          <td><?= h($r['opened_at']) ?></td>
          <td><?= h($r['last_msg_at']) ?></td>
          <td><a class="btn btn-outline-primary btn-sm" href="/admin/chat_view.php?id=<?= (int)$r['id'] ?>">Apri</a></td>
        </tr>
      <?php endforeach; if(!$rows): ?>
        <tr><td colspan="6" class="text-center text-muted">Nessuna chat aperta</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__.'/../partials/footer.php'; ?>
