<?php
// /admin/index.php
$page_title = 'Admin';
require_once __DIR__.'/../partials/admin_guard.php'; // $pdo, session, ecc.

/* ====== Helper ====== */
function q1($pdo,$sql,$params=[]){
  $st=$pdo->prepare($sql); $st->execute($params); return (int)($st->fetchColumn() ?? 0);
}
function q1safe($pdo,$sql,$params=[]){
  try{ $st=$pdo->prepare($sql); $st->execute($params); return (int)($st->fetchColumn() ?? 0); }
  catch(Throwable $e){ return 0; }
}
function get_setting($pdo,$k,$def=null){
  try{ $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?"); $st->execute([$k]); $r=$st->fetch();
       return $r ? $r['value'] : $def; }catch(Throwable $e){ return $def; }
}
function set_setting($pdo,$k,$v){
  $st=$pdo->prepare("INSERT INTO settings(`key`,`value`) VALUES(?,?)
                     ON DUPLICATE KEY UPDATE value=VALUES(value)");
  $st->execute([$k,$v]);
}

/* ====== POST: toggle LiveChat (se usi un pulsante dedicato) ====== */
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['toggle_livechat'])){
  $cur = get_setting($pdo,'livechat_open','0'); // '1'|'0'
  $new = ($cur==='1') ? '0' : '1';
  set_setting($pdo,'livechat_open',$new);

  if (!headers_sent()) header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(['open'=>$new==='1']);
  exit;
}

/* ====== Contatori ====== */
// Ticket
$unanswered     = q1($pdo,"
  SELECT COUNT(*)
  FROM tickets
  WHERE status IN ('open','pending')
    AND (last_admin_reply_at IS NULL OR last_user_reply_at IS NULL OR last_user_reply_at > last_admin_reply_at)
");
$ticket_open    = q1($pdo,"SELECT COUNT(*) FROM tickets WHERE status='open'");
$ticket_pending = q1($pdo,"SELECT COUNT(*) FROM tickets WHERE status='pending'");
$ticket_closed  = q1($pdo,"SELECT COUNT(*) FROM tickets WHERE status='closed'");

// Utenti / Contenuti
$total_users  = q1($pdo,"SELECT COUNT(*) FROM users");
$total_cats   = q1($pdo,"SELECT COUNT(*) FROM categories");
$lives_total  = q1($pdo,"SELECT COUNT(*) FROM lives");
$lives_active = q1($pdo,"SELECT COUNT(*) FROM lives WHERE is_active=1");

/* >>> AGGIUNTA: totale link m3u8 valorizzati */
$m3u8_total   = q1safe($pdo,"SELECT COUNT(*) FROM lives WHERE m3u8_url IS NOT NULL AND m3u8_url<>''");

// LiveChat
$chat_open = q1safe($pdo,"SELECT COUNT(*) FROM live_chats WHERE status='open'");
$chat_with_unread = q1safe($pdo, "
  SELECT COUNT(DISTINCT c.id)
  FROM live_chats c
  JOIN live_chat_messages m ON m.chat_id=c.id
  WHERE c.status='open' AND m.sender='user'
    AND (m.read_admin=0 OR m.read_admin IS NULL)
");
$live_open = get_setting($pdo,'livechat_open','0')==='1';

// Piani & Prezzi
$plans_active = q1safe($pdo,"SELECT COUNT(*) FROM plans WHERE is_active=1");
$plans_total  = q1safe($pdo,"SELECT COUNT(*) FROM plans");

// Spettatori live (valore iniziale)
$live_online = q1safe($pdo,"SELECT COUNT(*) FROM live_presence WHERE updated_at >= (NOW() - INTERVAL 70 SECOND)");
if ($live_online === 0) {
  $live_online = q1safe($pdo,"SELECT COUNT(*) FROM live_presence WHERE last_seen >= (NOW() - INTERVAL 70 SECOND)");
}

/* ====== Monitor link (stessa logica di link_monitor.php) ====== */
try{
  $cc = $pdo->query("SELECT LOWER(status) AS s, COUNT(*) AS n
                     FROM live_link_status
                     GROUP BY s")->fetchAll(PDO::FETCH_KEY_PAIR);
}catch(Throwable $e){ $cc = []; }
$lm_ok   = (int)($cc['ok']   ?? 0);
$lm_warn = (int)($cc['warn'] ?? 0);
$lm_down = (int)($cc['down'] ?? 0);

require_once __DIR__.'/../partials/header.php';
?>
<style>
  .admin-wrap{ max-width: 1200px; margin: 18px auto; }
  .section-title{ font-weight:800; letter-spacing:.2px; margin-bottom:.5rem; }
  .muted{ color:var(--topbar-link-muted,#6c757d); }

  /* Stat cards */
  .stat-grid{ display:grid; grid-template-columns: repeat(5, minmax(0,1fr)); gap:14px; margin-bottom:18px; }
  @media (max-width: 1200px){ .stat-grid{ grid-template-columns: repeat(3, 1fr); } }
  @media (max-width: 768px){  .stat-grid{ grid-template-columns: repeat(2, 1fr); } }
  @media (max-width: 480px){  .stat-grid{ grid-template-columns: 1fr; } }

  .stat-card{
    position:relative; overflow:hidden; border-radius:16px; padding:16px;
    background: linear-gradient(135deg, rgba(13,110,253,.10), rgba(13,110,253,.02));
    border:1px solid rgba(13,110,253,.25);
  }
  .stat-card .label{ font-weight:700; }
  .stat-card .value{ font-size:1.8rem; font-weight:800; line-height:1; }
  .stat-card .bi{ position:absolute; right:12px; bottom:10px; font-size:2.2rem; opacity:.25; }
  .stat-green{ background: linear-gradient(135deg, rgba(25,135,84,.12), rgba(25,135,84,.03)); border-color: rgba(25,135,84,.28); }
  .stat-amber{ background: linear-gradient(135deg, rgba(255,193,7,.16), rgba(255,193,7,.04)); border-color: rgba(255,193,7,.35); }
  .stat-gray { background: linear-gradient(135deg, rgba(108,117,125,.16), rgba(108,117,125,.04)); border-color: rgba(108,117,125,.35); }
  html[data-theme="dark"] .stat-card{ border-color: rgba(255,255,255,.14); }
  .stat-violet{
    background: linear-gradient(135deg, rgba(111,66,193,.16), rgba(111,66,193,.05));
    border-color: rgba(111,66,193,.35);
  }

  /* Sezioni */
  .admin-section{ margin-top:22px; }
  .admin-section .sec-head{ display:flex; align-items:baseline; gap:10px; margin-bottom:10px; }
  .admin-section .sec-head h5{ margin:0; font-weight:800; }
  .admin-section .sec-head .hint{ font-size:.95rem; color:var(--topbar-link-muted,#6c757d); }

  /* Tiles */
  .tile-grid{ display:grid; grid-template-columns: repeat(3, minmax(0,1fr)); gap:14px; }
  @media (max-width: 992px){ .tile-grid{ grid-template-columns: repeat(2, 1fr); } }
  @media (max-width: 576px){ .tile-grid{ grid-template-columns: 1fr; } }
  .tile{
    position:relative; display:flex; align-items:center; gap:14px;
    padding:16px; border-radius:16px; text-decoration:none;
    background: var(--body-bg,#fff); color: var(--body-text,#222);
    border: 1px solid rgba(0,0,0,.08);
    transition: transform .15s ease, box-shadow .15s ease, border-color .15s ease;
  }
  html[data-theme="dark"] .tile{ background:#121416; border-color: rgba(255,255,255,.12); }
  .tile:hover{ transform: translateY(-2px); box-shadow: 0 10px 28px rgba(0,0,0,.18); border-color: rgba(13,110,253,.35); }
  .tile .icon{
    width:48px; height:48px; border-radius:12px; display:flex; align-items:center; justify-content:center;
    background: rgba(13,110,253,.12); border:1px solid rgba(13,110,253,.25);
  }
  .tile .icon .bi{ font-size:1.4rem; }
  .tile .txt .t1{ font-weight:800; }
  .tile .txt .t2{ font-size:.95rem; color:var(--topbar-link-muted,#6c757d); }
  .tile .badge{ position:absolute; right:12px; top:12px; }

  /* Pills per monitor */
  .pill-row{ display:flex; gap:10px; margin-top:6px; }
  .pill{
    min-width:36px; height:36px; border-radius:999px;
    display:flex; align-items:center; justify-content:center;
    font-weight:800; border:1px solid transparent;
  }
  .pill.ok   { background:#e7f6ef; color:#136f3a; border-color:#cfe9db; }
  .pill.warn { background:#fff5db; color:#8a6a00; border-color:#f3e2b3; }
  .pill.down { background:#fde8ea; color:#8a1f2b; border-color:#f5c2c7; }
</style>

<div class="admin-wrap container">
  <h4 class="mb-1 section-title">Pannello Admin</h4>
  <div class="muted mb-3">Panoramica e collegamenti rapidi alle aree principali.</div>

  <!-- Statistiche -->
  <div class="stat-grid">
    <div class="stat-card">
      <div class="label">Ticket aperti</div>
      <div class="value"><?= $ticket_open ?></div>
      <i class="bi bi-inbox-fill"></i>
    </div>
    <div class="stat-card stat-amber">
      <div class="label">In attesa</div>
      <div class="value"><?= $ticket_pending ?></div>
      <i class="bi bi-hourglass-split"></i>
    </div>
    <div class="stat-card stat-green">
      <div class="label">Chiusi</div>
      <div class="value"><?= $ticket_closed ?></div>
      <i class="bi bi-check2-circle"></i>
    </div>
    <div class="stat-card stat-gray">
      <div class="label">Ticket da evadere</div>
      <div class="value"><?= $unanswered ?></div>
      <i class="bi bi-bell-fill"></i>
    </div>
    <div class="stat-card stat-violet" title="Spettatori collegati alle live (ultimi 70s)">
      <div class="label">Spettatori live</div>
      <div class="value"><span id="liveNow"><?= (int)$live_online ?></span></div>
      <i class="bi bi-broadcast-pin"></i>
    </div>
  </div>

  <!-- ===== SUPPORTO ===== -->
  <section class="admin-section">
    <div class="sec-head">
      <h5>Supporto</h5>
      <span class="hint">Ticket, LiveChat e richieste dei clienti</span>
    </div>
    <div class="tile-grid">
      <a class="tile" href="/admin/tickets.php">
        <?php if ($unanswered>0): ?><span class="badge rounded-pill text-bg-danger"><?= $unanswered ?></span><?php endif; ?>
        <div class="icon"><i class="bi bi-life-preserver"></i></div>
        <div class="txt">
          <div class="t1">Ticket</div>
          <div class="t2">Gestisci richieste di supporto</div>
        </div>
      </a>
    </div>
  </section>

  <!-- ===== UTENTI ===== -->
  <section class="admin-section">
    <div class="sec-head">
      <h5>Utenti</h5>
      <span class="hint">Gestione account, abbonamenti e pagamenti</span>
    </div>
    <div class="tile-grid">
      <a class="tile tile-green" href="/admin/users.php">
        <div class="icon"><i class="bi bi-people-fill"></i></div>
        <div class="txt">
          <div class="t1">Utenti</div>
          <div class="t2"><?= $total_users ?> registrati</div>
        </div>
      </a>
    </div>
  </section>

  <!-- ===== CONTENUTI ===== -->
  <section class="admin-section">
    <div class="sec-head">
      <h5>Contenuti</h5>
      <span class="hint">Gestione palinsesto, dirette e categorie</span>
    </div>
    <div class="tile-grid">
      <!-- Categorie PRIMA di Live -->
      <a class="tile" href="/admin/categories.php">
        <div class="icon"><i class="bi bi-grid-3x3-gap-fill"></i></div>
        <div class="txt">
          <div class="t1">Categorie</div>
          <div class="t2"><?= $total_cats ?> totali</div>
        </div>
      </a>

      <a class="tile tile-amber" href="/admin/lives.php">
        <div class="icon"><i class="bi bi-broadcast-pin"></i></div>
        <div class="txt">
          <div class="t1">Live</div>
          <div class="t2"><?= $lives_active ?> attive su <?= $lives_total ?></div>
        </div>
      </a>

      <!-- Monitor link (conteggi server-side, niente pulsante) -->
      <a class="tile" href="/admin/link_monitor.php" title="Apri monitor link m3u8">
        <div class="icon"><i class="bi bi-activity"></i></div>
        <div class="txt">
          <div class="t1">Monitor link</div>
          <div class="t2">Controllo stato m3u8</div>
          <div class="pill-row">
            <div class="pill ok"><?= $lm_ok ?></div>
            <div class="pill warn"><?= $lm_warn ?></div>
            <div class="pill down"><?= $lm_down ?></div>
          </div>
        </div>
      </a>

      <!-- >>> AGGIUNTA: tile Editor massivo M3U8 -->
      <a class="tile" href="/admin/tools/m3u8_bulk_editor.php" title="Apri editor massivo dei link M3U8">
        <div class="icon"><i class="bi bi-link-45deg"></i></div>
        <div class="txt">
          <div class="t1">Editor massivo M3U8</div>
          <div class="t2"><?= $m3u8_total ?> link modificabili</div>
        </div>
      </a>
      <!-- <<< FINE AGGIUNTA -->

    </div>
  </section>

  <!-- ===== VENDITE ===== -->
  <section class="admin-section">
    <div class="sec-head">
      <h5>Vendite</h5>
      <span class="hint">Piani/Prezzi mostrati in <code></code></span>
    </div>
    <div class="tile-grid">
      <a class="tile tile-purple" href="/admin/plans.php">
        <div class="icon"><i class="bi bi-tags-fill"></i></div>
        <div class="txt">
          <div class="t1">Piani & Prezzi</div>
          <div class="t2"><?= $plans_active ?> attivi<?= $plans_total>0?' su '.$plans_total:'' ?></div>
        </div>
      </a>
    </div>
  </section>

  <!-- ===== COMUNICAZIONE ===== -->
  <section class="admin-section">
    <div class="sec-head">
      <h5>Comunicazione</h5>
      <span class="hint">Avvisi in dashboard ed email SMTP</span>
    </div>
    <div class="tile-grid">
      <a class="tile" href="/admin/notice.php">
        <div class="icon"><i class="bi bi-megaphone-fill"></i></div>
        <div class="txt">
          <div class="t1">Badge Dashboard</div>
          <div class="t2">Messaggi per i clienti</div>
        </div>
      </a>

      <a class="tile tile-purple" href="/admin/mail.php">
        <div class="icon"><i class="bi bi-envelope-paper-fill"></i></div>
        <div class="txt">
          <div class="t1">Email (SMTP)</div>
          <div class="t2">Configura server e invia test</div>
        </div>
      </a>
    </div>
  </section>

  <!-- ===== LEGALE ===== -->
  <section class="admin-section">
    <div class="sec-head">
      <h5>Legale</h5>
      <span class="hint">Documenti pubblici del sito</span>
    </div>
    <div class="tile-grid">
      <a class="tile tile-gray" href="/admin/regolamento.php">
        <div class="icon"><i class="bi bi-file-text-fill"></i></div>
        <div class="txt">
          <div class="t1">Regolamento</div>
          <div class="t2">Testo pubblico modificabile</div>
        </div>
      </a>

      <a class="tile tile-gray" href="/admin/privacy.php">
        <div class="icon"><i class="bi bi-shield-lock-fill"></i></div>
        <div class="txt">
          <div class="t1">Privacy</div>
          <div class="t2">Informativa GDPR</div>
        </div>
      </a>
    </div>
  </section>
</div>

<?php require_once __DIR__.'/../partials/footer.php'; ?>

<script>
// Toggle LiveChat (se presente un bottone con id="toggleLCBtn")
document.getElementById('toggleLCBtn')?.addEventListener('click', async function(){
  const btn=this; btn.disabled=true;
  try{
    const r = await fetch(location.pathname+location.search, {
      method:'POST',
      headers:{'X-Requested-With':'XMLHttpRequest','Content-Type':'application/x-www-form-urlencoded'},
      body: new URLSearchParams({toggle_livechat:'1'})
    });
    const j = await r.json();
    const card = btn.closest('.card-lite');
    const stateEl = card?.querySelector('.text-success, .text-secondary');
    if(j && typeof j.open==='boolean' && stateEl){
      if(j.open){
        stateEl.className='text-success';
        stateEl.textContent='Aperta (i clienti possono chattare in tempo reale)';
        btn.className='btn btn-outline-danger';
        btn.textContent='Chiudi LiveChat';
      }else{
        stateEl.className='text-secondary';
        stateEl.textContent='Chiusa (solo messaggi offline)';
        btn.className='btn btn-outline-success';
        btn.textContent='Apri LiveChat';
      }
    }
  }catch(e){ alert('Errore durante il cambio stato LiveChat.'); }
  finally{ btn.disabled=false; }
});

// ====== Contatore "Spettatori live" in tempo reale ======
const liveNowEl = document.getElementById('liveNow');
async function refreshLiveNow(){
  try{
    const r = await fetch('/admin/api_live_online_count.php', { cache:'no-store' });
    if(!r.ok) throw new Error('HTTP '+r.status);
    const j = await r.json();
    if (typeof j.count === 'number') {
      liveNowEl.textContent = j.count;
      const tip = (j.by_live && j.by_live.length)
        ? j.by_live.map(it => `${it.title || ('Live #'+it.live_id)}: ${it.count}`).join(' • ')
        : 'Nessuno spettatore negli ultimi ' + (j.ttl||70) + 's';
      liveNowEl.closest('.stat-card')?.setAttribute('title', tip);
    }
  }catch(e){ /* silenzioso */ }
}
refreshLiveNow();
setInterval(refreshLiveNow, 15000);
</script>
