<?php
// /admin/link_monitor.php
$page_title='Monitor Link';
require_once __DIR__.'/../partials/admin_guard.php';
require_once __DIR__.'/../config.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset','UTF-8'); mb_internal_encoding('UTF-8');

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

/* safety: tabella stato */
$pdo->exec("CREATE TABLE IF NOT EXISTS live_link_status (
  live_id INT PRIMARY KEY,
  url TEXT NOT NULL,
  status ENUM('ok','warn','down') NOT NULL DEFAULT 'warn',
  http_code INT NULL,
  content_type VARCHAR(191) NULL,
  latency_ms INT NULL,
  last_ok DATETIME NULL,
  last_fail DATETIME NULL,
  last_checked DATETIME NOT NULL,
  fail_count INT NOT NULL DEFAULT 0,
  ok_count INT NOT NULL DEFAULT 0,
  last_alert_at DATETIME NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

/* badge counts */
$cc = $pdo->query("SELECT status, COUNT(*) n FROM live_link_status GROUP BY status")->fetchAll(PDO::FETCH_KEY_PAIR);
$cnt_ok   = (int)($cc['ok']   ?? 0);
$cnt_warn = (int)($cc['warn'] ?? 0);
$cnt_down = (int)($cc['down'] ?? 0);

/* rows */
$st = $pdo->query("SELECT l.id,l.title,l.slug,c.name AS cat,l.m3u8_url,
                          s.status,s.http_code,s.content_type,s.latency_ms,
                          s.last_ok,s.last_fail,s.last_checked
                   FROM lives l
                   LEFT JOIN live_link_status s ON s.live_id=l.id
                   LEFT JOIN categories c ON c.id=l.category_id
                   WHERE l.m3u8_url IS NOT NULL AND l.m3u8_url <> ''
                   ORDER BY c.name, l.sort_order, l.id DESC");
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

require_once __DIR__.'/../partials/header.php';
?>
<style>
.badge-pill{display:inline-block;padding:.25rem .6rem;border-radius:999px;font-weight:700;color:#fff}
.b-ok{background:#16a34a}.b-warn{background:#f59e0b}.b-down{background:#dc2626}
.table td,.table th{vertical-align:middle}
.sticky-top-info{position:sticky;top:0;z-index:50;padding:.5rem .75rem;background:#0f172a;color:#fff;border-radius:.5rem;margin-bottom:.75rem}
@media (prefers-color-scheme: light){ .sticky-top-info{background:#e9ecef;color:#111} }
.smallmuted{color:#6b7280}
</style>

<div class="sticky-top-info d-flex align-items-center justify-content-between gap-2">
  <div class="d-flex align-items-center gap-2">
    <span class="badge-pill b-ok">OK <?= $cnt_ok ?></span>
    <span class="badge-pill b-warn">WARN <?= $cnt_warn ?></span>
    <span class="badge-pill b-down">DOWN <?= $cnt_down ?></span>
    <?php if($cnt_down>0): ?>
      <span class="ms-2">⚠️ Alcuni link risultano <strong>DOWN</strong>.</span>
    <?php endif; ?>
  </div>
  <div class="d-flex align-items-center gap-2">
    <button id="btnRun" class="btn btn-sm btn-primary">Controlla adesso</button>
    <label class="ms-2 small">
      <input type="checkbox" id="autoChk"> Auto-check ogni 60s
    </label>
  </div>
</div>

<!-- Progress area -->
<div id="scanBox" class="mb-3" style="display:none">
  <div class="progress" style="height:14px;">
    <div id="scanProg" class="progress-bar" role="progressbar" style="width:0%">0%</div>
  </div>
  <div id="scanText" class="small smallmuted mt-1">—</div>
</div>

<div class="table-responsive">
<table class="table table-sm">
  <thead>
    <tr>
      <th>ID</th>
      <th>Titolo</th>
      <th>Categoria</th>
      <th>Stato</th>
      <th>HTTP</th>
      <th>CT</th>
      <th>Latency</th>
      <th>Ult. OK</th>
      <th>Ult. FAIL</th>
      <th>Checked</th>
      <th>URL</th>
    </tr>
  </thead>
  <tbody>
  <?php foreach($rows as $r):
      $st = $r['status'] ?: 'warn';
      $cls = $st==='ok' ? 'b-ok' : ($st==='down' ? 'b-down' : 'b-warn');
  ?>
    <tr>
      <td><?= (int)$r['id'] ?></td>
      <td><a href="/client/live.php?slug=<?= urlencode($r['slug']) ?>" target="_blank"><?= h($r['title']) ?></a></td>
      <td><?= h($r['cat'] ?: '-') ?></td>
      <td><span class="badge-pill <?= $cls ?>"><?= strtoupper($st) ?></span></td>
      <td><?= $r['http_code'] ? (int)$r['http_code'] : '—' ?></td>
      <td><?= h($r['content_type'] ?: '—') ?></td>
      <td><?= $r['latency_ms'] ? (int)$r['latency_ms'].' ms' : '—' ?></td>
      <td><?= $r['last_ok']   ? date('d/m/Y H:i', strtotime($r['last_ok']))   : '—' ?></td>
      <td><?= $r['last_fail'] ? date('d/m/Y H:i', strtotime($r['last_fail'])) : '—' ?></td>
      <td><?= $r['last_checked'] ? date('d/m/Y H:i', strtotime($r['last_checked'])) : '—' ?></td>
      <td style="max-width:420px;overflow:hidden;text-overflow:ellipsis;">
        <a href="<?= h($r['m3u8_url']) ?>" target="_blank" rel="noopener"><?= h($r['m3u8_url']) ?></a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>

<script>
const scanBox  = document.getElementById('scanBox');
const scanProg = document.getElementById('scanProg');
const scanText = document.getElementById('scanText');

function setProgress(done, total, lastLine){
  const pct = total ? Math.round(done*100/total) : 0;
  scanProg.style.width = pct+'%';
  scanProg.textContent = pct+'%';
  scanText.textContent = `${done}/${total}` + (lastLine ? ` — ${lastLine}` : '');
}

async function runScan(){
  scanBox.style.display='block';
  setProgress(0, 0, 'Preparazione…');

  // 1) lista
  const res = await fetch('/admin/cron/check_links.php?list=1', {cache:'no-store'});
  const j   = await res.json();
  const items = (j && j.items) ? j.items : [];
  const total = items.length;
  if (!total){ setProgress(0,0,'Nessun link da controllare.'); return; }

  // Pool di concorrenza
  const POOL = 8; // <— puoi aumentare/ridurre (8 è un buon compromesso)
  let idx   = 0;
  let done  = 0;

  async function worker(){
    while (true){
      const i = idx++;
      if (i >= total) break;
      const it = items[i];
      try{
        const r = await fetch('/admin/cron/check_links.php?id='+encodeURIComponent(it.id)+'&fast=1', {cache:'no-store'});
        const x = await r.json();
        done++;
        const line = `#${x.id} ${x.title} — ${String(x.status||'').toUpperCase()} (${x.http_code||'-'}) ${x.latency_ms||0}ms`;
        setProgress(done, total, line);
      }catch(e){
        done++;
        setProgress(done, total, `#${it.id} errore`);
      }
    }
  }

  const workers = Array.from({length: Math.min(POOL, total)}, ()=>worker());
  await Promise.all(workers);

  // refresh degli indicatori
  setTimeout(()=>location.reload(), 400);
}

document.getElementById('btnRun')?.addEventListener('click', runScan);

// Auto-check ogni 60s (silenzioso, senza barra)
let timer=null;
document.getElementById('autoChk')?.addEventListener('change', (e)=>{
  if(e.target.checked){
    timer = setInterval(async ()=>{
      try{ await fetch('/admin/cron/check_links.php', {cache:'no-store'}); }catch(e){}
      location.reload();
    }, 60000);
  }else{
    clearInterval(timer); timer=null;
  }
});
</script>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
