<?php
// /admin/email.php
$page_title = 'Impostazioni Email';
require_once __DIR__.'/../partials/admin_guard.php';
require_once __DIR__.'/../lib/mailer.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function get_setting($pdo,$k){ $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?"); $st->execute([$k]); $r=$st->fetch(); return $r ? $r['value'] : null; }
function set_setting($pdo,$k,$v){ $st=$pdo->prepare("INSERT INTO settings(`key`,`value`) VALUES(?,?) ON DUPLICATE KEY UPDATE value=VALUES(value)"); $st->execute([$k,$v]); }

$flash = null;

/* Salva impostazioni */
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['save'])){
  $enabled = !empty($_POST['smtp_enabled']) ? '1' : '0';
  set_setting($pdo,'smtp_enabled', $enabled);
  set_setting($pdo,'smtp_host',    trim($_POST['smtp_host'] ?? ''));
  set_setting($pdo,'smtp_port',    (string)max(1,(int)($_POST['smtp_port'] ?? 587)));
  set_setting($pdo,'smtp_user',    trim($_POST['smtp_user'] ?? ''));
  // password: aggiorna solo se valorizzata
  $curPass = (string)(get_setting($pdo,'smtp_pass') ?? '');
  $newPass = (string)($_POST['smtp_pass'] ?? '');
  set_setting($pdo,'smtp_pass',    $newPass !== '' ? $newPass : $curPass);
  $secure  = in_array(($_POST['smtp_secure'] ?? 'tls'), ['none','ssl','tls'], true) ? $_POST['smtp_secure'] : 'tls';
  set_setting($pdo,'smtp_secure',  $secure);
  set_setting($pdo,'smtp_from_email', trim($_POST['smtp_from_email'] ?? ''));
  set_setting($pdo,'smtp_from_name',  trim($_POST['smtp_from_name']  ?? ''));

  $flash = ['type'=>'success','msg'=>'Impostazioni salvate.'];
}

/* Test invio */
$test_result = null;
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['test_send'])){
  $to = trim($_POST['test_to'] ?? '');
  if (!filter_var($to, FILTER_VALIDATE_EMAIL)) {
    $test_result = ['ok'=>false,'msg'=>'Email di destinazione non valida.'];
  } else {
    $ok = send_app_mail($to, 'Test SMTP — Super Sport',
      '<p>Questa è una <strong>email di test</strong> inviata dal pannello admin.</p><p>Se la vedi, la configurazione SMTP funziona 🎉</p>',
      "Questa è una email di test inviata dal pannello admin.\nSe la vedi, la configurazione SMTP funziona."
    );
    $test_result = $ok ? ['ok'=>true,'msg'=>'Email di test inviata.'] : ['ok'=>false,'msg'=>'Invio fallito (vedi log del server).'];
  }
}

/* Carica valori correnti */
$cfg = mail_get_settings($pdo);

/* UI */
require_once __DIR__.'/../partials/header.php';
?>
<style>
  .card-lite{background:var(--body-bg,#fff);border:1px solid rgba(0,0,0,.08);border-radius:14px;padding:14px;}
  html[data-theme="dark"] .card-lite{background:#121416;border-color:rgba(255,255,255,.12);}
  .section-title{font-weight:800;letter-spacing:.2px;margin-bottom:.5rem;}
  .muted{color:var(--topbar-link-muted,#6c757d);}
</style>

<div class="container" style="max-width:900px">
  <h4 class="section-title mb-1">Impostazioni Email (SMTP)</h4>
  <div class="muted mb-3">Configura il server SMTP per gli invii del sito (ticket, notifiche, ecc.).</div>

  <?php if($flash): ?>
    <div class="alert alert-<?= $flash['type']==='success'?'success':'danger' ?>"><?= h($flash['msg']) ?></div>
  <?php endif; ?>
  <?php if($test_result): ?>
    <div class="alert alert-<?= $test_result['ok']?'success':'danger' ?>"><?= h($test_result['msg']) ?></div>
  <?php endif; ?>

  <form method="post" class="card-lite row g-3">
    <div class="col-12">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="smtp_enabled" id="smtp_enabled" value="1" <?= $cfg['smtp_enabled']==='1'?'checked':'' ?>>
        <label class="form-check-label" for="smtp_enabled">Usa server SMTP (se disattivato, usa mail() del server)</label>
      </div>
    </div>

    <div class="col-12 col-md-6">
      <label class="form-label">Host</label>
      <input name="smtp_host" class="form-control" value="<?= h($cfg['smtp_host']) ?>" placeholder="es. smtp.gmail.com">
    </div>
    <div class="col-6 col-md-2">
      <label class="form-label">Porta</label>
      <input name="smtp_port" type="number" min="1" class="form-control" value="<?= h($cfg['smtp_port']) ?>">
    </div>
    <div class="col-6 col-md-4">
      <label class="form-label">Sicurezza</label>
      <select name="smtp_secure" class="form-select">
        <option value="none" <?= $cfg['smtp_secure']==='none'?'selected':''; ?>>Nessuna</option>
        <option value="ssl"  <?= $cfg['smtp_secure']==='ssl'?'selected':'';  ?>>SSL/SMTPS</option>
        <option value="tls"  <?= $cfg['smtp_secure']==='tls'?'selected':'';  ?>>STARTTLS</option>
      </select>
    </div>

    <div class="col-12 col-md-6">
      <label class="form-label">Username</label>
      <input name="smtp_user" class="form-control" value="<?= h($cfg['smtp_user']) ?>">
    </div>
    <div class="col-12 col-md-6">
      <label class="form-label">Password</label>
      <input name="smtp_pass" type="password" class="form-control" placeholder="(lascia vuoto per non cambiare)">
    </div>

    <div class="col-12 col-md-6">
      <label class="form-label">Mittente email</label>
      <input name="smtp_from_email" type="email" class="form-control" value="<?= h($cfg['smtp_from_email']) ?>">
    </div>
    <div class="col-12 col-md-6">
      <label class="form-label">Mittente nome</label>
      <input name="smtp_from_name" class="form-control" value="<?= h($cfg['smtp_from_name']) ?>">
    </div>

    <div class="col-12 d-flex gap-2">
      <button class="btn btn-primary" name="save" value="1">Salva impostazioni</button>
      <div class="ms-auto d-flex gap-2">
        <input type="email" class="form-control" name="test_to" placeholder="Email per test" style="max-width:280px">
        <button class="btn btn-outline-secondary" name="test_send" value="1">Invia email di test</button>
      </div>
    </div>
  </form>
</div>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
