<?php
$page_title='Badge Dashboard';
require_once __DIR__.'/../partials/admin_guard.php';
require_once __DIR__.'/../partials/header.php';

// helpers settings
function get_setting($pdo,$k){
  $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?");
  $st->execute([$k]); $row=$st->fetch();
  return $row ? $row['value'] : null;
}
function set_setting($pdo,$k,$v){
  $st=$pdo->prepare("INSERT INTO settings(`key`,`value`) VALUES(?,?)
                     ON DUPLICATE KEY UPDATE value=VALUES(value)");
  $st->execute([$k,$v]);
}

$saved = false;
if($_SERVER['REQUEST_METHOD']==='POST'){
  set_setting($pdo,'client_badge_enabled', isset($_POST['enabled']) ? '1':'0');
  set_setting($pdo,'client_badge_html', trim($_POST['html'] ?? ''));
  $saved = true;
}
$enabled = get_setting($pdo,'client_badge_enabled') === '1';
$html    = get_setting($pdo,'client_badge_html');
?>
<h4 class="mb-3">Badge in Dashboard Cliente</h4>
<?php if($saved): ?><div class="alert alert-success">Salvato!</div><?php endif; ?>

<form method="post" class="row g-3">
  <div class="col-12 form-check">
    <input class="form-check-input" type="checkbox" id="enabled" name="enabled" <?= $enabled?'checked':'';?>>
    <label class="form-check-label" for="enabled">Mostra badge nella dashboard</label>
  </div>
  <div class="col-12">
    <label class="form-label">Contenuto (HTML consentito)</label>
    <textarea name="html" class="form-control" rows="4" placeholder="Testo del badge (puoi usare grassetto, link, ecc.)"><?= htmlspecialchars($html ?? '') ?></textarea>
    <div class="form-text">Puoi usare HTML semplice: &lt;strong&gt;, &lt;em&gt;, &lt;a&gt;, &lt;u&gt;, ecc.</div>
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Salva</button>
  </div>
</form>

<hr class="my-4">

<h6>Anteprima</h6>
<div class="se-badge my-2">
  <div class="se-badge-inner">
    <span class="me-2">🔔</span>
    <span><?= $html ?></span>
  </div>
</div>

<style>
.se-badge .se-badge-inner{
  background:#555; color:#fff; border-radius:10px;
  padding:16px 18px; box-shadow:6px 0 0 #111 inset, -6px 0 0 #111 inset, 0 6px 12px rgba(0,0,0,.2);
}
</style>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
