<?php
// /admin/plans.php
$page_title = 'Piani & Prezzi';
require_once __DIR__ . '/../partials/admin_guard.php';

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function set_flash($t,$m){ $_SESSION['flash']=['type'=>$t,'msg'=>$m]; }
function pop_flash(){ $f=$_SESSION['flash']??null; unset($_SESSION['flash']); return $f; }

/* ====== POST ====== */
if($_SERVER['REQUEST_METHOD']==='POST'){
  // CREA
  if(isset($_POST['create'])){
    $name=trim($_POST['name']??''); $slug=trim($_POST['slug']??'');
    $months=max(1,(int)($_POST['months']??1));
    $price=(float)($_POST['price']??0);
    $list = ($_POST['list_price']!=='') ? (float)$_POST['list_price'] : null;
    $cur  = strtoupper(trim($_POST['currency']??'EUR')) ?: 'EUR';
    $feat = trim($_POST['features']??'');
    $sort = (int)($_POST['sort_order']??0);

    if($name===''||$slug===''||$price<=0){ set_flash('danger','Compila nome, slug univoco e prezzo > 0'); }
    else{
      $st=$pdo->prepare("INSERT INTO plans(name,slug,months,price,currency,list_price,features,sort_order,is_active) VALUES (?,?,?,?,?,?,?,?,1)");
      try{ $st->execute([$name,$slug,$months,$price,$cur,$list,$feat,$sort]); set_flash('success','Piano creato.'); }
      catch(Throwable $e){ set_flash('danger','Errore: slug già esistente?'); }
    }
    header('Location:/admin/plans.php'); exit;
  }

  // UPDATE
  if(isset($_POST['update'])){
    $id=(int)($_POST['id']??0);
    $name=trim($_POST['name']??''); $slug=trim($_POST['slug']??'');
    $months=max(1,(int)($_POST['months']??1));
    $price=(float)($_POST['price']??0);
    $list = ($_POST['list_price']!=='') ? (float)$_POST['list_price'] : null;
    $cur  = strtoupper(trim($_POST['currency']??'EUR')) ?: 'EUR';
    $feat = trim($_POST['features']??'');
    $sort = (int)($_POST['sort_order']??0);
    $active = !empty($_POST['is_active'])?1:0;

    if($id>0){
      $st=$pdo->prepare("UPDATE plans SET name=?,slug=?,months=?,price=?,currency=?,list_price=?,features=?,is_active=?,sort_order=? WHERE id=?");
      try{ $st->execute([$name,$slug,$months,$price,$cur,$list,$feat,$active,$sort,$id]); set_flash('success','Piano aggiornato.'); }
      catch(Throwable $e){ set_flash('danger','Errore di aggiornamento (slug univoco?)'); }
    }
    header('Location:/admin/plans.php'); exit;
  }

  // DELETE
  if(isset($_POST['delete'])){
    $id=(int)($_POST['id']??0);
    $pdo->prepare("DELETE FROM plans WHERE id=?")->execute([$id]);
    set_flash('success','Piano eliminato.');
    header('Location:/admin/plans.php'); exit;
  }
}

$plans = $pdo->query("SELECT * FROM plans ORDER BY sort_order ASC, months ASC, id ASC")->fetchAll();
$flash = pop_flash();

require_once __DIR__ . '/../partials/header.php';
?>
<style>
  .wrap{ max-width: 1400px; margin: 18px auto; }
  .card-lite{
    background: var(--body-bg,#fff);
    border:1px solid rgba(0,0,0,.08);
    border-radius:16px; padding:16px;
  }
  html[data-theme="dark"] .card-lite{ background:#121416; border-color: rgba(255,255,255,.12); }
  .plan-grid{
    display:grid; gap:12px;
    grid-template-columns: repeat(12, minmax(0,1fr));
  }
  /* Nuovo piano - griglia comoda */
  .g12{ grid-column: span 12 / span 12; }
  .g6 { grid-column: span 6 / span 6; }
  .g4 { grid-column: span 4 / span 4; }
  .g3 { grid-column: span 3 / span 3; }
  .g2 { grid-column: span 2 / span 2; }
  .g1 { grid-column: span 1 / span 1; }
  @media (max-width: 992px){
    .g6,.g4,.g3,.g2,.g1{ grid-column: span 12 / span 12; }
  }

  .plan-card{ margin-bottom:14px; }
  .plan-head{
    display:flex; align-items:center; justify-content:space-between; gap:10px; margin-bottom:10px;
  }
  .badge-id{ font-weight:800; background:#0d6efd; color:#fff; border-radius:10px; padding:.2rem .5rem; }
  .form-textarea{
    font-family: ui-monospace, SFMono-Regular, Menlo, Consolas, "Liberation Mono", monospace;
    resize: vertical; min-height: 120px;
  }
  .muted{ color:var(--topbar-link-muted,#6c757d); }
</style>

<div class="wrap container">
  <h4 class="mb-2">Piani & Prezzi</h4>
  <div class="text-muted mb-3">Gestisci i pacchetti mostrati in <code>/client/pricing.php</code>.</div>

  <?php if($flash): ?>
    <div class="alert alert-<?= $flash['type']==='success'?'success':'danger' ?>"><?= h($flash['msg']) ?></div>
  <?php endif; ?>

  <!-- ===== Nuovo piano ===== -->
  <form method="post" class="card-lite mb-3">
    <h6 class="mb-2">Nuovo piano</h6>
    <div class="plan-grid">
      <div class="g6"><input name="name" class="form-control" placeholder="Nome (es. Mensile)" required></div>
      <div class="g6"><input name="slug" class="form-control" placeholder="Slug univoco (es. monthly)" required></div>

      <div class="g2"><input name="months" type="number" min="1" class="form-control" value="1" placeholder="Mesi" required></div>
      <div class="g3"><input name="price" type="number" step="0.01" min="0" class="form-control" placeholder="Prezzo" required></div>
      <div class="g3"><input name="list_price" type="number" step="0.01" class="form-control" placeholder="List price (opz)"></div>
      <div class="g2"><input name="currency" class="form-control" value="EUR" maxlength="8" placeholder="Valuta"></div>
      <div class="g2"><input name="sort_order" type="number" class="form-control" value="0" placeholder="Ordine"></div>

      <div class="g12">
        <textarea name="features" rows="5" class="form-control form-textarea" placeholder="Una caratteristica per riga"></textarea>
      </div>

      <div class="g12 d-flex gap-2 justify-content-end">
        <button class="btn btn-primary" name="create">Crea piano</button>
      </div>
    </div>
  </form>

  <!-- ===== Lista piani (card comode) ===== -->
  <div class="card-lite">
    <h6 class="mb-2">Piani esistenti</h6>

    <?php foreach($plans as $p): ?>
      <form method="post" class="card-lite plan-card">
        <div class="plan-head">
          <div class="d-flex align-items-center gap-2">
            <span class="badge-id">#<?= (int)$p['id'] ?></span>
            <div class="muted">Modifica piano</div>
          </div>
          <div class="d-flex gap-2">
            <button class="btn btn-outline-primary btn-sm" name="update">Salva</button>
            <button class="btn btn-outline-danger btn-sm" name="delete" onclick="return confirm('Eliminare questo piano?')">Elimina</button>
          </div>
        </div>

        <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">

        <div class="plan-grid">
          <div class="g6">
            <label class="form-label">Nome</label>
            <input name="name" class="form-control" value="<?= h($p['name']) ?>">
          </div>
          <div class="g6">
            <label class="form-label">Slug univoco</label>
            <input name="slug" class="form-control" value="<?= h($p['slug']) ?>">
          </div>

          <div class="g2">
            <label class="form-label">Mesi</label>
            <input name="months" type="number" min="1" class="form-control" value="<?= (int)$p['months'] ?>">
          </div>
          <div class="g3">
            <label class="form-label">Prezzo</label>
            <input name="price" type="number" step="0.01" class="form-control" value="<?= h($p['price']) ?>">
          </div>
          <div class="g3">
            <label class="form-label">List price (opz)</label>
            <input name="list_price" type="number" step="0.01" class="form-control" value="<?= h($p['list_price']) ?>">
          </div>
          <div class="g2">
            <label class="form-label">Valuta</label>
            <input name="currency" class="form-control" value="<?= h($p['currency']) ?>">
          </div>
          <div class="g2">
            <label class="form-label">Ordine</label>
            <input name="sort_order" type="number" class="form-control" value="<?= (int)$p['sort_order'] ?>">
          </div>
          <div class="g2 d-flex align-items-end">
            <div class="form-check">
              <input type="checkbox" class="form-check-input" id="act<?= (int)$p['id'] ?>" name="is_active" <?= $p['is_active']?'checked':'' ?>>
              <label for="act<?= (int)$p['id'] ?>" class="form-check-label">Attivo</label>
            </div>
          </div>

          <div class="g12">
            <label class="form-label">Features (una per riga)</label>
            <textarea name="features" rows="6" class="form-control form-textarea"><?= h($p['features']) ?></textarea>
          </div>

          <div class="g12 d-flex gap-2 justify-content-end">
            <button class="btn btn-outline-primary" name="update">Salva</button>
            <button class="btn btn-outline-danger" name="delete" onclick="return confirm('Eliminare questo piano?')">Elimina</button>
          </div>
        </div>
      </form>
    <?php endforeach; ?>

    <?php if(!$plans): ?>
      <div class="alert alert-info m-0">Nessun piano presente. Crea il primo con il form in alto.</div>
    <?php endif; ?>
  </div>
</div>

<?php require_once __DIR__ . '/../partials/footer.php'; ?>

<script>
// auto-resize semplice per le textarea di features
document.querySelectorAll('.form-textarea').forEach(t=>{
  const resize = ()=>{ t.style.height='auto'; t.style.height=(t.scrollHeight+2)+'px'; };
  t.addEventListener('input', resize);
  resize();
});
</script>
