<?php
// /admin/privacy.php
$page_title = 'Privacy Policy — Editor';
require_once __DIR__ . '/../partials/admin_guard.php';
require_once __DIR__ . '/../partials/header.php';

function get_setting($pdo,$k){
  $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?");
  $st->execute([$k]); $r=$st->fetch();
  return $r ? $r['value'] : null;
}
function set_setting($pdo,$k,$v){
  $st=$pdo->prepare("INSERT INTO settings(`key`,`value`) VALUES(?,?)
                     ON DUPLICATE KEY UPDATE value=VALUES(value)");
  $st->execute([$k,$v]);
}

$saved = false;
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['html'])){
  set_setting($pdo,'privacy_html', $_POST['html']);
  $saved = true;
}
$current = get_setting($pdo,'privacy_html') ?? '';
?>
<style>
  .editor-wrap{ max-width: 1100px; margin: 18px auto; }
  .split{ display:grid; grid-template-columns: 1fr 1fr; gap:16px; }
  @media (max-width: 991px){ .split{ grid-template-columns: 1fr; } }
  .card-like{
    background: var(--body-bg,#fff);
    border:1px solid rgba(0,0,0,.08);
    border-radius:12px;
    padding:14px;
  }
  html[data-theme="dark"] .card-like{ border-color: rgba(255,255,255,.12); background:#121416; }
  .preview{ max-height: 70vh; overflow:auto; }
  .preview .policy-card{ border:0; box-shadow:none; padding:0; }
  textarea.form-control{ font-family: ui-monospace, SFMono-Regular, Menlo, Consolas, monospace; }
</style>

<div class="editor-wrap container">
  <h4 class="mb-3">Privacy Policy — Editor</h4>

  <?php if($saved): ?>
    <div class="alert alert-success">Salvato!</div>
  <?php endif; ?>

  <div class="split">
    <form method="post" class="card-like">
      <label class="form-label fw-bold">Contenuto HTML (fidato)</label>
      <textarea class="form-control" name="html" rows="22" oninput="updatePreview()"><?= htmlspecialchars($current, ENT_NOQUOTES, 'UTF-8') ?></textarea>
      <div class="d-flex justify-content-between mt-3">
        <a class="btn btn-outline-secondary" href="/privacy.php" target="_blank">Apri pagina</a>
        <button class="btn btn-primary">Salva</button>
      </div>
      <div class="form-text mt-2">
        Suggerimento: usa &lt;h3&gt;, &lt;p&gt;, &lt;ul&gt;&lt;li&gt; e &lt;hr&gt; per strutturare il testo.
      </div>
    </form>

    <div class="card-like">
      <div class="d-flex align-items-center justify-content-between">
        <strong>Anteprima</strong>
        <span class="text-muted small">si aggiorna mentre scrivi</span>
      </div>
      <hr>
      <div id="prev" class="preview">
        <div class="policy-card">
          <h2 class="policy-title">Privacy Policy</h2>
          <div class="policy-content" id="prevContent"><?= $current ?></div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
function updatePreview(){
  const src = document.querySelector('textarea[name="html"]').value;
  document.getElementById('prevContent').innerHTML = src;
}
</script>

<?php require_once __DIR__ . '/../partials/footer.php'; ?>
