<?php
// /admin/ticket_form.php
$page_title='Ticket — Modello form';
require_once __DIR__.'/../partials/admin_guard.php';
require_once __DIR__.'/../partials/header.php';

function get_setting($pdo,$k){
  $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?");
  $st->execute([$k]); $r=$st->fetch();
  return $r ? $r['value'] : null;
}
function set_setting($pdo,$k,$v){
  $st=$pdo->prepare("INSERT INTO settings(`key`,`value`) VALUES(?,?)
                     ON DUPLICATE KEY UPDATE value=VALUES(value)");
  $st->execute([$k,$v]);
}
function default_schema_json(): string {
  return json_encode([
    ['name'=>'category','label'=>'Categoria','type'=>'select','required'=>true,'options'=>['Supporto tecnico','Pagamenti','Richiesta canali','Altro']],
    ['name'=>'priority','label'=>'Priorità','type'=>'select','required'=>true,'options'=>['Bassa','Media','Alta']],
    ['name'=>'subject','label'=>'Oggetto','type'=>'text','required'=>true],
    ['name'=>'message','label'=>'Messaggio','type'=>'textarea','required'=>true,'rows'=>6],
  ], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
}

$saved=false; $err='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $raw = (string)($_POST['schema'] ?? '');
  $test = json_decode($raw,true);
  if(!is_array($test)){ $err='JSON non valido.'; }
  else { set_setting($pdo,'ticket_form_schema',$raw); $saved=true; }
}
$current = get_setting($pdo,'ticket_form_schema') ?: default_schema_json();
?>
<style>
  .wrap{ max-width:1100px; margin:18px auto; }
  .split{ display:grid; grid-template-columns: 1fr 1fr; gap:16px; }
  @media (max-width: 991px){ .split{ grid-template-columns: 1fr; } }
  .card-like{ background:var(--body-bg,#fff); border:1px solid rgba(0,0,0,.08); border-radius:12px; padding:14px; }
  html[data-theme="dark"] .card-like{ background:#121416; border-color: rgba(255,255,255,.12); }
  textarea{ font-family: ui-monospace,SFMono-Regular,Menlo,Consolas,monospace; min-height: 520px; }
</style>

<div class="container wrap">
  <h4 class="mb-3">Modello modulo Ticket</h4>
  <?php if($saved): ?><div class="alert alert-success">Salvato.</div><?php endif; ?>
  <?php if($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

  <div class="split">
    <form method="post" class="card-like">
      <label class="form-label fw-bold">Schema (JSON)</label>
      <textarea class="form-control" name="schema" oninput="updatePreview()"><?= htmlspecialchars($current, ENT_NOQUOTES, 'UTF-8') ?></textarea>
      <div class="d-flex justify-content-between mt-3">
        <button class="btn btn-outline-secondary" type="button" onclick="resetDefault()">Ripristina default</button>
        <button class="btn btn-primary">Salva</button>
      </div>
      <div class="form-text mt-2">
        Ogni campo: <code>{ name, label, type: "text|textarea|select", required: true|false, options?: [] , rows?: 6 }</code>
      </div>
    </form>

    <div class="card-like">
      <strong>Anteprima modulo</strong><hr>
      <div id="preview"></div>
    </div>
  </div>
</div>

<script>
function renderPreview(schema){
  const wrap=document.getElementById('preview');
  wrap.innerHTML='';
  if(!Array.isArray(schema)){ wrap.textContent='Schema non valido.'; return; }
  schema.forEach(f=>{
    const div=document.createElement('div'); div.className='mb-3';
    const lab=document.createElement('label'); lab.className='form-label'; lab.textContent=f.label||f.name;
    div.appendChild(lab);
    if(f.type==='textarea'){
      const t=document.createElement('textarea'); t.className='form-control'; t.rows=f.rows||5; div.appendChild(t);
    }else if(f.type==='select'){
      const s=document.createElement('select'); s.className='form-select';
      const op=document.createElement('option'); op.textContent='Seleziona…'; s.appendChild(op);
      (f.options||[]).forEach(o=>{ const x=document.createElement('option'); x.textContent=o; s.appendChild(x); });
      div.appendChild(s);
    }else{
      const i=document.createElement('input'); i.className='form-control'; i.type='text'; div.appendChild(i);
    }
    wrap.appendChild(div);
  });
}
function updatePreview(){
  try{
    const obj=JSON.parse(document.querySelector('textarea[name="schema"]').value);
    renderPreview(obj);
  }catch(e){
    document.getElementById('preview').textContent='JSON non valido.';
  }
}
function resetDefault(){
  const def = <?= json_encode(default_schema_json()) ?>;
  document.querySelector('textarea[name="schema"]').value = def;
  updatePreview();
}
updatePreview();
</script>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
