<?php
// /admin/ticket_view.php
$page_title = 'Ticket';
require_once __DIR__.'/../partials/admin_guard.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
/* flash */
function set_flash(string $type, string $msg): void { $_SESSION['flash']=['type'=>$type,'msg'=>$msg]; }
function pop_flash(): ?array { $f=$_SESSION['flash']??null; unset($_SESSION['flash']); return $f; }

$id = (int)($_GET['id'] ?? 0);

/* ------- POST prima di stampare HTML ------- */
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['reply'])){
    $msg = trim((string)($_POST['message'] ?? ''));
    $status = $_POST['set_status'] ?? 'pending';
    if($msg!==''){
      // Salva risposta admin
      $pdo->beginTransaction();
      $pdo->prepare("INSERT INTO ticket_messages (ticket_id,sender,message,created_at) VALUES (?,?,?,NOW())")->execute([$id,'admin',$msg]);
      $pdo->prepare("UPDATE tickets SET status=?, updated_at=NOW(), last_admin_reply_at=NOW() WHERE id=?")->execute([$status,$id]);
      $pdo->commit();

      /* ===== INVIO EMAIL AL CLIENTE ===== */
      try{
        // Recupero email del cliente titolare del ticket
        $stU = $pdo->prepare("SELECT u.email 
                              FROM tickets t 
                              JOIN users u ON u.id=t.user_id 
                              WHERE t.id=?");
        $stU->execute([$id]);
        $destEmail = $stU->fetchColumn();

        if($destEmail){
          require_once __DIR__.'/../lib/mailer.php';
          $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https' : 'http';
          $host   = $_SERVER['HTTP_HOST'] ?? 'localhost';
          $link   = $scheme.'://'.$host.'/client/ticket.php?view='.$id;

          $subject = "Hai ricevuto una risposta al ticket #{$id}";
          $html    = '<p>Ciao! C’è una nuova risposta al tuo ticket.</p>'
                    .'<p><a href="'.htmlspecialchars($link, ENT_QUOTES, 'UTF-8').'">Apri il ticket</a></p>';

          // Non interrompere il flusso se l'invio fallisce
          @send_app_mail($destEmail, $subject, $html);
        }
      }catch(Throwable $e){
        // opzionale: logga $e->getMessage()
      }

      set_flash('success','Risposta inviata e notifica email al cliente inviata (se configurata).');
      header('Location: /admin/ticket_view.php?id='.$id.'#fine'); exit;
    } else {
      set_flash('danger','Messaggio vuoto.');
      header('Location: /admin/ticket_view.php?id='.$id); exit;
    }
  } elseif(isset($_POST['update'])){
    $stat = $_POST['status'] ?? 'open';
    $prio = $_POST['priority'] ?? 'Media';
    $pdo->prepare("UPDATE tickets SET status=?, priority=?, updated_at=NOW() WHERE id=?")->execute([$stat,$prio,$id]);
    set_flash('success','Ticket aggiornato.');
    header('Location: /admin/ticket_view.php?id='.$id); exit;
  } elseif(isset($_POST['delete'])){
    // Elimina ticket (messaggi rimossi via FK ON DELETE CASCADE)
    $pdo->prepare("DELETE FROM tickets WHERE id=?")->execute([$id]);
    set_flash('success','Ticket eliminato.');
    header('Location: /admin/tickets.php'); exit;
  }
}

/* ------- Ora posso renderizzare ------- */
require_once __DIR__.'/../partials/header.php';

$st=$pdo->prepare("SELECT t.*, u.email FROM tickets t JOIN users u ON u.id=t.user_id WHERE t.id=?");
$st->execute([$id]); $tk=$st->fetch();
if(!$tk){ echo '<div class="container my-4"><div class="alert alert-danger">Ticket non trovato.</div></div>'; require_once __DIR__.'/../partials/footer.php'; exit; }

$ms=$pdo->prepare("SELECT * FROM ticket_messages WHERE ticket_id=? ORDER BY id ASC");
$ms->execute([$id]); $msgs=$ms->fetchAll();
$flash = pop_flash();
?>
<style>
  .twrap{ max-width:1000px; margin: 18px auto; }
  .tcard{ background:var(--body-bg,#fff); border:1px solid rgba(0,0,0,.08); border-radius:12px; padding:14px; }
  html[data-theme="dark"] .tcard{ background:#121416; border-color: rgba(255,255,255,.12); }
  .msg{ border-radius:12px; padding:10px 12px; margin-bottom:10px; border:1px solid rgba(0,0,0,.06);}
  .msg.user{ background: rgba(13,110,253,.07); }
  .msg.admin{ background: rgba(25,135,84,.09); }
  .muted{ color:#6c757d; }
  /* flash */
  .flash-center{ position:fixed; inset:0; display:flex; align-items:center; justify-content:center; background:rgba(0,0,0,.35); z-index:2000; }
  .flash-card{ background:var(--modal-bg,#fff); color:var(--modal-text,#222); border-radius:18px; padding:18px 22px; text-align:center; min-width:260px; box-shadow:0 20px 60px rgba(0,0,0,.35); }
  .flash-card .bi{ font-size:2rem; display:block; margin-bottom:.25rem; }
</style>

<?php if($flash): ?>
  <div class="flash-center" id="flashCenter">
    <div class="flash-card">
      <?php if($flash['type']==='success'): ?><i class="bi bi-check-circle-fill"></i>
      <?php else: ?><i class="bi bi-exclamation-triangle-fill"></i><?php endif; ?>
      <div class="fw-bold"><?= h($flash['msg']) ?></div>
    </div>
  </div>
  <script> setTimeout(()=>document.getElementById('flashCenter')?.remove(), 1400); </script>
<?php endif; ?>

<div class="container twrap">
  <h4 class="mb-3">Ticket #<?= (int)$tk['id'] ?> — <?= h($tk['subject']) ?></h4>

  <div class="tcard mb-3">
    <div class="d-flex flex-wrap gap-2 justify-content-between align-items-center">
      <div><strong>Utente:</strong> <?= h($tk['email']) ?></div>

      <div class="d-flex gap-2">
        <form method="post" class="d-flex gap-2">
          <select name="status" class="form-select form-select-sm" style="width:auto">
            <?php foreach(['open','pending','closed'] as $s): ?>
              <option <?= $tk['status']===$s?'selected':''; ?> value="<?=h($s)?>"><?=h($s)?></option>
            <?php endforeach; ?>
          </select>
          <select name="priority" class="form-select form-select-sm" style="width:auto">
            <?php foreach(['Bassa','Media','Alta'] as $p): ?>
              <option <?= $tk['priority']===$p?'selected':''; ?> value="<?=h($p)?>"><?=h($p)?></option>
            <?php endforeach; ?>
          </select>
          <button class="btn btn-outline-primary btn-sm" name="update">Aggiorna</button>
        </form>

        <form method="post" onsubmit="return confirm('Eliminare definitivamente questo ticket?');">
          <button class="btn btn-outline-danger btn-sm" name="delete">Elimina</button>
        </form>
      </div>
    </div>

    <?php if(!empty($tk['form_json'])): ?>
      <hr>
      <div class="kv">
        <?php $data=json_decode($tk['form_json'],true) ?: []; foreach($data as $k=>$v): ?>
          <div><strong><?= h($k) ?>:</strong> <?= h($v) ?></div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>

  <div class="tcard mb-3">
    <?php foreach($msgs as $m): ?>
      <div class="msg <?= $m['sender']==='admin'?'admin':'user' ?>">
        <div class="small muted mb-1"><?= h($m['sender']==='admin'?'Staff':'Utente') ?> — <?= h($m['created_at']) ?></div>
        <div style="white-space:pre-wrap"><?= h($m['message']) ?></div>
      </div>
    <?php endforeach; ?>

    <form method="post" class="mt-3">
      <label class="form-label">Risposta</label>
      <textarea class="form-control mb-2" name="message" rows="4" required></textarea>
      <div class="d-flex gap-2 align-items-center">
        <label class="form-label m-0 me-2">Imposta stato:</label>
        <select name="set_status" class="form-select" style="max-width:180px">
          <?php foreach(['open','pending','closed'] as $s): ?>
            <option value="<?=h($s)?>" <?= $s==='pending'?'selected':''; ?>><?=h($s)?></option>
          <?php endforeach; ?>
        </select>
        <button class="btn btn-primary" name="reply">Invia risposta</button>
      </div>
      <div id="fine"></div>
    </form>
  </div>

  <a class="btn btn-outline-secondary" href="/admin/tickets.php">Torna alla lista</a>
</div>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
