<?php
// /admin/tickets.php
$page_title = 'Ticket';
require_once __DIR__.'/../partials/admin_guard.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
/* flash */
function set_flash(string $type, string $msg): void { $_SESSION['flash']=['type'=>$type,'msg'=>$msg]; }
function pop_flash(): ?array { $f=$_SESSION['flash']??null; unset($_SESSION['flash']); return $f; }

/* --- POST: elimina dalla lista --- */
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['delete_id'])){
  $id = (int)$_POST['delete_id'];
  $pdo->prepare("DELETE FROM tickets WHERE id=?")->execute([$id]);
  set_flash('success','Ticket eliminato.');
  header('Location: /admin/tickets.php'); exit;
}

/* --- poi header UI --- */
require_once __DIR__.'/../partials/header.php';

$status = $_GET['status'] ?? '';
$q      = trim($_GET['q'] ?? '');

$where=[]; $par=[];
if($status!==''){ $where[]='t.status=?'; $par[]=$status; }
if($q!==''){ $where[]='(t.subject LIKE ? OR u.email LIKE ?)'; $par[]="%$q%"; $par[]="%$q%"; }

$sql="SELECT t.*, u.email FROM tickets t JOIN users u ON u.id=t.user_id";
if($where) $sql.=' WHERE '.implode(' AND ',$where);
$sql.=" ORDER BY t.updated_at DESC";
$st=$pdo->prepare($sql); $st->execute($par); $rows=$st->fetchAll();

$flash = pop_flash();
?>
<style>
  .flash-center{ position:fixed; inset:0; display:flex; align-items:center; justify-content:center; background:rgba(0,0,0,.35); z-index:2000; }
  .flash-card{ background:var(--modal-bg,#fff); color:var(--modal-text,#222); border-radius:18px; padding:18px 22px; text-align:center; min-width:260px; box-shadow:0 20px 60px rgba(0,0,0,.35); }
  .flash-card .bi{ font-size:2rem; display:block; margin-bottom:.25rem; }

  /* Switch + badge stato */
  .auto-refresh-label{ font-weight:700; letter-spacing:.2px; margin-left:.35rem; }
  .auto-dot{
    display:inline-block; width:8px; height:8px; border-radius:999px; margin-left:.4rem;
    background: #6c757d; vertical-align:middle;
  }
  .auto-on .auto-dot{ background:#dc3545; box-shadow: 0 0 0 4px rgba(220,53,69,.15); }
  #lastUpdated{ color:var(--topbar-link-muted,#6c757d); font-size:.9rem; }
</style>

<?php if($flash): ?>
  <div class="flash-center" id="flashCenter">
    <div class="flash-card">
      <?php if($flash['type']==='success'): ?><i class="bi bi-check-circle-fill"></i>
      <?php else: ?><i class="bi bi-exclamation-triangle-fill"></i><?php endif; ?>
      <div class="fw-bold"><?= h($flash['msg']) ?></div>
    </div>
  </div>
  <script> setTimeout(()=>document.getElementById('flashCenter')?.remove(), 1400); </script>
<?php endif; ?>

<div class="container">
  <h4 class="mb-3 d-flex align-items-center justify-content-between">
    <span>Ticket</span>
    <div class="d-flex align-items-center gap-3">
      <div class="d-flex align-items-center">
        <div class="form-check form-switch m-0">
          <input class="form-check-input" type="checkbox" id="autoRefreshSwitch">
          <label class="form-check-label auto-refresh-label" for="autoRefreshSwitch">
            Auto refresh <span class="auto-dot" title="Stato auto refresh"></span>
          </label>
        </div>
      </div>
      <small id="lastUpdated"></small>
      <a class="btn btn-outline-secondary btn-sm" href="/admin/ticket_form.php">Modello form ticket</a>
    </div>
  </h4>

  <form method="get" class="row g-2 align-items-end mb-3">
    <div class="col-12 col-md-5">
      <label class="form-label">Cerca</label>
      <input class="form-control" type="search" name="q" value="<?= h($q) ?>" placeholder="Oggetto o email">
    </div>
    <div class="col-6 col-md-3">
      <label class="form-label">Stato</label>
      <select name="status" class="form-select">
        <option value="">Tutti</option>
        <?php foreach(['open','pending','closed'] as $s): ?>
          <option value="<?=h($s)?>" <?= $status===$s?'selected':''; ?>><?=h($s)?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-6 col-md-2"><button class="btn btn-primary w-100">Filtra</button></div>
    <div class="col-12 col-md-2"><a class="btn btn-outline-secondary w-100" href="/admin/tickets.php">Reset</a></div>
  </form>

  <table class="table table-sm align-middle">
    <thead>
      <tr>
        <th style="width:70px">ID</th>
        <th>Oggetto</th>
        <th style="width:200px">Utente</th>
        <th style="width:110px">Stato</th>
        <th style="width:110px">Priorità</th>
        <th style="width:170px">Aggiornato</th>
        <th style="width:160px">Azioni</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($rows as $r): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= h($r['subject']) ?></td>
        <td><?= h($r['email']) ?></td>
        <td><?= h($r['status']) ?></td>
        <td><?= h($r['priority']) ?></td>
        <td><?= h($r['updated_at']) ?></td>
        <td class="d-flex gap-2">
          <a class="btn btn-outline-primary btn-sm" href="/admin/ticket_view.php?id=<?= (int)$r['id'] ?>">Apri</a>
          <form method="post" onsubmit="return confirm('Eliminare definitivamente il ticket #<?= (int)$r['id'] ?>?');">
            <input type="hidden" name="delete_id" value="<?= (int)$r['id'] ?>">
            <button class="btn btn-outline-danger btn-sm">Elimina</button>
          </form>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php require_once __DIR__.'/../partials/footer.php'; ?>

<script>
(function(){
  const KEY = 'adm_tickets_autorefresh';
  const REFRESH_MS = 30000;
  const sw = document.getElementById('autoRefreshSwitch');
  const last = document.getElementById('lastUpdated');

  function readPref(){
    try { return localStorage.getItem(KEY) === '1'; } catch(e){ return false; }
  }
  function savePref(on){
    try { localStorage.setItem(KEY, on ? '1' : '0'); } catch(e){}
  }
  function setTS(){
    if(!last) return;
    const d = new Date();
    last.textContent = 'Agg. ' + d.toLocaleTimeString();
  }

  let timer = null;
  function start(){
    if(timer) clearInterval(timer);
    timer = setInterval(()=>{ location.reload(); }, REFRESH_MS);
    document.body.classList.add('auto-on');
  }
  function stop(){
    if(timer){ clearInterval(timer); timer = null; }
    document.body.classList.remove('auto-on');
  }

  // init
  const on = readPref();
  if(sw) sw.checked = on;
  setTS();
  if(on) start();

  sw?.addEventListener('change', function(){
    if(this.checked){ savePref(true); start(); }
    else { savePref(false); stop(); }
  });

  // opzionale: aggiorna timestamp ogni 15s per far vedere che la pagina è viva
  setInterval(setTS, 15000);
})();
</script>
