<?php
// /admin/users.php
$page_title = 'Utenti';
require_once __DIR__ . '/../partials/admin_guard.php';

/* ---------- Helpers ---------- */
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function is_zero_dt(?string $s): bool { return !$s || $s==='0000-00-00 00:00:00' || $s==='0000-00-00'; }
function dt_local_value(?string $mysqlDt): string { if (is_zero_dt($mysqlDt)) return ''; try { $dt=new DateTime($mysqlDt); return $dt->format('Y-m-d\TH:i'); } catch(Throwable $e){ return ''; } }
function fmt_it(?string $mysqlDt): string { if (is_zero_dt($mysqlDt)) return '—'; try { $dt=new DateTime($mysqlDt); return $dt->format('d/m/Y H:i'); } catch(Throwable $e){ return '—'; } }
function parse_dt_local(?string $v): ?string { $v=trim((string)$v); if($v==='') return null; $dt=DateTime::createFromFormat('Y-m-d\TH:i',$v); return $dt? $dt->format('Y-m-d H:i:s'):null; }
function get_setting($pdo,$k){ $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?"); $st->execute([$k]); $r=$st->fetch(); return $r['value']??null; }
function set_setting($pdo,$k,$v){ $st=$pdo->prepare("INSERT INTO settings(`key`,`value`) VALUES(?,?) ON DUPLICATE KEY UPDATE value=VALUES(value)"); $st->execute([$k,$v]); }
function set_flash(string $type,string $msg): void { $_SESSION['flash']=['type'=>$type,'msg'=>$msg]; }
function pop_flash(): ?array { $f=$_SESSION['flash']??null; unset($_SESSION['flash']); return $f; }

/* ---------- ensure colonne playlist (token + enabled) ---------- */
function ensure_user_playlist_columns(PDO $pdo): void {
  static $done=false; if($done) return; $done=true;
  try{
    $db = $pdo->query("SELECT DATABASE()")->fetchColumn();

    // playlist_token
    $q = $pdo->prepare("SELECT COUNT(*) FROM information_schema.COLUMNS
                        WHERE TABLE_SCHEMA=? AND TABLE_NAME='users' AND COLUMN_NAME='playlist_token'");
    $q->execute([$db]);
    if(!$q->fetchColumn()){
      $pdo->exec("ALTER TABLE users ADD COLUMN playlist_token VARCHAR(128) NULL DEFAULT NULL");
      try{ $pdo->exec("CREATE INDEX idx_users_playlist_token ON users(playlist_token)"); }catch(Throwable $e){}
    }

    // playlist_enabled
    $q = $pdo->prepare("SELECT COUNT(*) FROM information_schema.COLUMNS
                        WHERE TABLE_SCHEMA=? AND TABLE_NAME='users' AND COLUMN_NAME='playlist_enabled'");
    $q->execute([$db]);
    if(!$q->fetchColumn()){
      $pdo->exec("ALTER TABLE users ADD COLUMN playlist_enabled TINYINT(1) NOT NULL DEFAULT 0");
    }
  }catch(Throwable $e){ /* non bloccare l'admin */ }
}
ensure_user_playlist_columns($pdo);

/* ---------- Ruoli ---------- */
$ROLES=['client'=>'client','admin'=>'admin'];

/* ---------- PRG self ---------- */
$qs=$_SERVER['QUERY_STRING']??''; $self='/admin/users.php'.($qs?('?'.$qs):'');

/* ---------- POST ---------- */
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['toggle_reg'])){
    $cur=get_setting($pdo,'registration_enabled'); $new=($cur==='1'||$cur===null)?'0':'1'; set_setting($pdo,'registration_enabled',$new);
    if (!headers_sent()) header('Content-Type: application/json; charset=UTF-8');
    echo json_encode(['enabled'=>$new==='1']); exit;
  }
  if(isset($_POST['create'])){
    $email=trim($_POST['email']??''); $pass=(string)($_POST['password']??''); $role=(($_POST['role']??'client')==='admin')?'admin':'client';
    $sub=parse_dt_local($_POST['subscription_until']??'');
    if($email!=='' && $pass!==''){
      $pdo->prepare("INSERT INTO users(email,password_hash,role,subscription_until) VALUES (?,?,?,?)")
          ->execute([$email,password_hash($pass,PASSWORD_BCRYPT),$role,$sub]);
      set_flash('success','Utente creato.');
    }else set_flash('danger','Email e password sono obbligatorie.');
    header('Location: '.$self); exit;
  }
  if(isset($_POST['set_role'])){
    $id=(int)($_POST['id']??0); $role=$_POST['role']??'client';
    if(!isset($ROLES[$role])){ set_flash('danger','Ruolo non valido.'); header('Location: '.$self); exit; }
    if($id === (int)($_SESSION['user']['id']??0) && $role!=='admin'){ set_flash('danger','Non puoi toglierti i permessi admin.'); header('Location: '.$self); exit; }
    $pdo->prepare("UPDATE users SET role=? WHERE id=?")->execute([$role,$id]); set_flash('success','Ruolo aggiornato.');
    header('Location: '.$self); exit;
  }
  if(isset($_POST['delete'])){
    $id=(int)($_POST['id']??0); $who=$pdo->prepare("SELECT role FROM users WHERE id=?"); $who->execute([$id]); $r=$who->fetch();
    if(($r['role']??'')!=='admin' && $id!==(int)($_SESSION['user']['id']??0)){
      $pdo->prepare("DELETE FROM users WHERE id=?")->execute([$id]); set_flash('success','Utente eliminato.');
    } else set_flash('danger','Operazione non consentita.');
    header('Location: '.$self); exit;
  }
  if(isset($_POST['reset'])){
    $id=(int)($_POST['id']??0); $new=trim($_POST['new_password']??'');
    if($new!==''){ $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([password_hash($new,PASSWORD_BCRYPT),$id]); set_flash('success','Password reimpostata.'); }
    else set_flash('danger','Inserisci la nuova password.');
    header('Location: '.$self); exit;
  }
  if(isset($_POST['set_sub'])){
    $id=(int)($_POST['id']??0); $sub=parse_dt_local($_POST['subscription_until']??'');
    $pdo->prepare("UPDATE users SET subscription_until=? WHERE id=?")->execute([$sub,$id]);
    set_flash('success','Scadenza aggiornata.'); header('Location: '.$self); exit;
  }
  if(isset($_POST['clear_sub'])){
    $id=(int)($_POST['id']??0); $pdo->prepare("UPDATE users SET subscription_until=NULL WHERE id=?")->execute([$id]);
    set_flash('success','Scadenza rimossa.'); header('Location: '.$self); exit;
  }
  if(isset($_POST['toggle_playlist'])){
    $id  = (int)($_POST['id']??0);
    $val = (int)($_POST['value']??0) ? 1 : 0;
    $pdo->prepare("UPDATE users SET playlist_enabled=? WHERE id=?")->execute([$val,$id]);
    set_flash('success', 'Playlist personale '.($val?'abilitata':'disabilitata').' per l’utente #'.$id.'.');
    header('Location: '.$self); exit;
  }
}

/* ---------- Stato registrazione ---------- */
$reg_enabled=get_setting($pdo,'registration_enabled'); $reg_enabled=($reg_enabled===null || $reg_enabled==='1');

/* ---------- Filtri ---------- */
$q=trim($_GET['q']??''); $roleF=$_GET['role']??''; $subF=$_GET['sub']??'';
$where=[]; $par=[];

if($q!==''){
  $where[]="(u.email LIKE ? OR u.id=? OR u.role LIKE ?)";
  $par[]="%$q%";
  $par[]=ctype_digit($q)?(int)$q:-1;
  $par[]="%$q%";
}
if($roleF==='admin'||$roleF==='client'){ $where[]="u.role=?"; $par[]=$roleF; }
if($subF==='active'){ $where[]="u.subscription_until IS NOT NULL AND UNIX_TIMESTAMP(u.subscription_until)>0 AND u.subscription_until>NOW()"; }
elseif($subF==='expired'){ $where[]="u.subscription_until IS NOT NULL AND UNIX_TIMESTAMP(u.subscription_until)>0 AND u.subscription_until<=NOW()"; }
elseif($subF==='none'){ $where[]="(u.subscription_until IS NULL OR UNIX_TIMESTAMP(u.subscription_until) IS NULL OR UNIX_TIMESTAMP(u.subscription_until)=0)"; }

/* ---------- Paginazione ---------- */
$perPage = 10;
$page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($page - 1) * $perPage;

$cntSql = "SELECT COUNT(*) FROM users u".($where ? " WHERE ".implode(' AND ',$where) : "");
$stCnt = $pdo->prepare($cntSql); $stCnt->execute($par); $total_rows = (int)($stCnt->fetchColumn() ?? 0);
$total_pages = max(1, (int)ceil($total_rows / $perPage));
if ($page > $total_pages) { $page = $total_pages; $offset = ($page-1)*$perPage; }

/* ---------- Query lista utenti (con playlist_enabled) ---------- */
$sql="SELECT u.id,u.email,u.role,u.created_at,u.subscription_until,u.playlist_enabled FROM users u";
if($where) $sql.=" WHERE ".implode(' AND ',$where);
$sql.=" ORDER BY u.id DESC LIMIT ".$perPage." OFFSET ".$offset;
$st=$pdo->prepare($sql); $st->execute($par); $users=$st->fetchAll();

/* ---------- Stat ---------- */
function q1($pdo,$sql){ try{ $st=$pdo->query($sql); return (int)($st->fetchColumn()??0); }catch(Throwable $e){ return 0; } }
function qf($pdo,$sql){ try{ $st=$pdo->query($sql); return (float)($st->fetchColumn()??0.0); }catch(Throwable $e){ return 0.0; } }
$total_users=q1($pdo,"SELECT COUNT(*) FROM users");
$total_admins=q1($pdo,"SELECT COUNT(*) FROM users WHERE role='admin'");
$total_clients=q1($pdo,"SELECT COUNT(*) FROM users WHERE role='client'");
$subs_active=q1($pdo,"SELECT COUNT(*) FROM users WHERE subscription_until IS NOT NULL AND UNIX_TIMESTAMP(subscription_until)>0 AND subscription_until>NOW()");
$subs_expired=q1($pdo,"SELECT COUNT(*) FROM users WHERE subscription_until IS NOT NULL AND UNIX_TIMESTAMP(subscription_until)>0 AND subscription_until<=NOW()");
$total_revenue=qf($pdo,"SELECT COALESCE(SUM(amount),0) FROM payments WHERE status='paid'");

/* ---------- util per link pagina ---------- */
function build_page_url(int $page): string {
  $params = $_GET;
  $params['page'] = $page;
  $qs = http_build_query($params);
  return '/admin/users.php'.($qs ? '?'.$qs : '');
}

$flash=pop_flash();
require_once __DIR__.'/../partials/header.php';
?>
<style>
  .admin-wrap{ max-width:1300px; margin:18px auto; }
  .section-title{ font-weight:800; letter-spacing:.2px; margin-bottom:.5rem; }
  .muted{ color:var(--topbar-link-muted,#6c757d); }

  .stat-grid{ display:grid; grid-template-columns:repeat(6,minmax(0,1fr)); gap:14px; margin-bottom:18px; }
  @media (max-width:1200px){ .stat-grid{ grid-template-columns:repeat(3,1fr);} }
  @media (max-width:768px){ .stat-grid{ grid-template-columns:repeat(2,1fr);} }
  @media (max-width:480px){ .stat-grid{ grid-template-columns:1fr;} }

  .stat-card{ position:relative; overflow:hidden; border-radius:16px; padding:16px;
    background:linear-gradient(135deg,rgba(13,110,253,.10),rgba(13,110,253,.02)); border:1px solid rgba(13,110,253,.25);}
  .stat-card .label{ font-weight:700; } .stat-card .value{ font-size:1.7rem; font-weight:800; line-height:1; }
  .stat-card .bi{ position:absolute; right:12px; bottom:10px; font-size:2.2rem; opacity:.25; }
  .stat-green{ background:linear-gradient(135deg,rgba(25,135,84,.12),rgba(25,135,84,.03)); border-color:rgba(25,135,84,.28);}
  .stat-amber{ background:linear-gradient(135deg,rgba(255,193,7,.16),rgba(255,193,7,.04)); border-color:rgba(255,193,7,.35);}
  .stat-gray{ background:linear-gradient(135deg,rgba(108,117,125,.16),rgba(108,117,125,.04)); border-color:rgba(108,117,125,.35);}
  html[data-theme="dark"] .stat-card{ border-color:rgba(255,255,255,.14);}
  .stat-gold{ background:linear-gradient(135deg,rgba(255,215,0,.22),rgba(255,215,0,.06)); border-color:rgba(255,215,0,.45);}
  html[data-theme="dark"] .stat-gold{ background:linear-gradient(135deg,rgba(212,175,55,.28),rgba(212,175,55,.10)); border-color:rgba(212,175,55,.55);}

  .card-lite{ background:var(--body-bg,#fff); border:1px solid rgba(0,0,0,.08); border-radius:14px; padding:14px; }
  html[data-theme="dark"] .card-lite{ background:#121416; border-color:rgba(255,255,255,.12); }
  table thead th{ white-space:nowrap; }

  /* Pagination */
  .pager{ display:flex; justify-content:space-between; align-items:center; padding:10px 0; }
  .pagination-sm .page-link{ padding:.25rem .5rem; }
</style>

<div class="admin-wrap container">
  <h4 class="mb-1 section-title">Gestione Utenti</h4>
  <div class="muted mb-3">Crea, filtra e modifica gli account. Gestisci ruoli, abbonamenti, pagamenti, dispositivi e playlist personale.</div>

  <?php if($flash): ?>
    <div class="alert alert-<?= $flash['type']==='success'?'success':'danger' ?>"><?= h($flash['msg']) ?></div>
  <?php endif; ?>

  <!-- Statistiche -->
  <div class="stat-grid">
    <div class="stat-card stat-gold"><div class="label">Guadagni</div><div class="value"><span id="revTotal"><?= number_format($total_revenue,2,',','.') ?></span> <small class="fw-bold">EUR</small></div><i class="bi bi-coin"></i></div>
    <div class="stat-card"><div class="label">Totali</div><div class="value"><?= $total_users ?></div><i class="bi bi-people-fill"></i></div>
    <div class="stat-card stat-green"><div class="label">Admin</div><div class="value"><?= $total_admins ?></div><i class="bi bi-shield-lock-fill"></i></div>
    <div class="stat-card stat-amber"><div class="label">Client</div><div class="value"><?= $total_clients ?></div><i class="bi bi-person-badge-fill"></i></div>
    <div class="stat-card stat-green"><div class="label">Abbonati attivi</div><div class="value"><?= $subs_active ?></div><i class="bi bi-badge-ad"></i></div>
    <div class="stat-card stat-gray"><div class="label">Abbonamenti scaduti</div><div class="value"><?= $subs_expired ?></div><i class="bi bi-hourglass-split"></i></div>
  </div>

  <!-- Registrazione + Crea utente -->
  <div class="row g-3 mb-3">
    <div class="col-12 col-lg-5">
      <div class="card-lite d-flex justify-content-between align-items-center">
        <div>
          <div class="fw-bold mb-1">Registrazione</div>
          <div class="<?= $reg_enabled ? 'text-success' : 'text-secondary' ?>"><?= $reg_enabled ? 'Abilitata' : 'Disabilitata' ?></div>
        </div>
        <button id="toggleRegBtn" class="btn <?= $reg_enabled ? 'btn-outline-danger' : 'btn-outline-success' ?>"><?= $reg_enabled ? 'Disattiva' : 'Attiva' ?></button>
      </div>
    </div>

    <div class="col-12 col-lg-7">
      <form method="post" class="card-lite row g-2 align-items-end">
        <div class="col-12 col-md-4">
          <label class="form-label">Email</label>
          <input name="email" type="email" class="form-control" placeholder="email" required>
        </div>
        <div class="col-6 col-md-3">
          <label class="form-label">Password</label>
          <input name="password" type="text" class="form-control" placeholder="password" required>
        </div>
        <div class="col-6 col-md-3">
          <label class="form-label">Ruolo</label>
          <select name="role" class="form-select">
            <option value="client">client</option>
            <option value="admin">admin</option>
          </select>
        </div>
        <div class="col-12">
          <label class="form-label">Scadenza abbonamento (opz.)</label>
          <input name="subscription_until" type="datetime-local" class="form-control">
        </div>
        <div class="col-12 d-grid d-md-flex gap-2"><button name="create" class="btn btn-primary">Crea</button></div>
      </form>
    </div>
  </div>

  <!-- Filtri -->
  <form method="get" class="card-lite row g-2 align-items-end mb-3">
    <div class="col-12 col-md-6"><label class="form-label">Cerca</label><input name="q" type="search" class="form-control" value="<?= h($q) ?>" placeholder="Email, ID o ruolo"></div>
    <div class="col-6 col-md-3"><label class="form-label">Ruolo</label>
      <select name="role" class="form-select">
        <option value="">Tutti</option>
        <option value="client" <?= $roleF==='client'?'selected':''; ?>>client</option>
        <option value="admin" <?= $roleF==='admin'?'selected':''; ?>>admin</option>
      </select>
    </div>
    <div class="col-6 col-md-2"><label class="form-label">Abbonamento</label>
      <select name="sub" class="form-select">
        <option value="">Tutti</option>
        <option value="active" <?= $subF==='active'?'selected':''; ?>>Attivo</option>
        <option value="expired" <?= $subF==='expired'?'selected':''; ?>>Scaduto</option>
        <option value="none" <?= $subF==='none'?'selected':''; ?>>Nessuno</option>
      </select>
    </div>
    <div class="col-6 col-md-1 d-grid"><button class="btn btn-primary">Filtra</button></div>
    <div class="col-6 col-md-1 d-grid"><a class="btn btn-outline-secondary" href="/admin/users.php">Reset</a></div>
  </form>

  <!-- Tabella -->
  <div class="table-responsive card-lite">
    <table class="table table-sm align-middle mb-0">
      <thead>
        <tr>
          <th style="width:70px">ID</th>
          <th>Email</th>
          <th style="width:170px">Ruolo</th>
          <th style="width:180px">Scadenza</th>
          <th style="width:110px">Stato</th>
          <th style="width:140px">Playlist</th>
          <th style="width:160px">Creato</th>
          <th style="width:640px">Azioni</th>
        </tr>
      </thead>
      <tbody>
      <?php $now=new DateTime(); foreach($users as $u):
        $sub=$u['subscription_until']; $active=false; if(!is_zero_dt($sub)){ try{ $active=(new DateTime($sub))>$now; }catch(Throwable $e){} }
        $isSelf=((int)$u['id']===(int)($_SESSION['user']['id']??0));
      ?>
        <tr data-user-id="<?= (int)$u['id'] ?>">
          <td><?= (int)$u['id'] ?></td>
          <td><?= h($u['email']) ?></td>
          <td>
            <form method="post" class="d-flex gap-1 align-items-center m-0">
              <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
              <select name="role" class="form-select form-select-sm">
                <option value="client" <?= $u['role']==='client'?'selected':''; ?>>client</option>
                <option value="admin"  <?= $u['role']==='admin'?'selected':''; ?>>admin</option>
              </select>
              <button name="set_role" class="btn btn-outline-primary btn-sm">Aggiorna</button>
            </form>
          </td>
          <td><?= h(fmt_it($sub)) ?></td>
          <td>
            <?php if($sub && $active): ?><span class="badge bg-success">Attivo</span>
            <?php elseif($sub && !$active): ?><span class="badge bg-danger">Scaduto</span>
            <?php else: ?><span class="badge bg-secondary">N/D</span><?php endif; ?>
          </td>
          <td>
            <span class="badge <?= !empty($u['playlist_enabled'])?'bg-success':'bg-secondary' ?>">
              <?= !empty($u['playlist_enabled']) ? 'Abilitata' : 'Disabilitata' ?>
            </span>
            <form method="post" class="d-inline m-0 ms-1">
              <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
              <input type="hidden" name="value" value="<?= !empty($u['playlist_enabled'])?0:1 ?>">
              <button name="toggle_playlist" class="btn btn-sm <?= !empty($u['playlist_enabled'])?'btn-outline-danger':'btn-outline-success' ?>">
                <?= !empty($u['playlist_enabled']) ? 'Disabilita' : 'Abilita' ?>
              </button>
            </form>
          </td>
          <td><?= h($u['created_at']) ?></td>
          <td class="d-flex flex-wrap gap-2">
            <!-- Scadenza -->
            <form method="post" class="d-flex align-items-center gap-1">
              <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
              <input type="datetime-local" name="subscription_until" class="form-control form-control-sm" value="<?= h(dt_local_value($sub)) ?>">
              <button name="set_sub" class="btn btn-outline-primary btn-sm">Salva</button>
            </form>
            <form method="post" class="m-0"><input type="hidden" name="id" value="<?= (int)$u['id'] ?>"><button name="clear_sub" class="btn btn-outline-secondary btn-sm">Nessuna</button></form>

            <!-- Reset password -->
            <form method="post" class="d-inline-flex align-items-center ms-2 gap-1">
              <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
              <input type="password" name="new_password" class="form-control form-control-sm" placeholder="nuova password" required>
              <button name="reset" class="btn btn-outline-primary btn-sm">Reset</button>
            </form>

            <!-- Pagamenti -->
            <button class="btn btn-outline-success btn-sm ms-2"
                    data-bs-toggle="modal" data-bs-target="#paymentsModal"
                    data-user-id="<?= (int)$u['id'] ?>" data-user-email="<?= h($u['email']) ?>">
              Pagamenti
            </button>

            <!-- Dispositivi -->
            <button class="btn btn-outline-secondary btn-sm"
                    data-bs-toggle="modal" data-bs-target="#admDevicesModal"
                    data-user-id="<?= (int)$u['id'] ?>" data-user-email="<?= h($u['email']) ?>">
              Dispositivi
            </button>

            <!-- Elimina -->
            <?php if($u['role']!=='admin' && !$isSelf): ?>
              <form method="post" class="m-0 ms-2" onsubmit="return confirm('Eliminare questo utente?');">
                <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                <button name="delete" class="btn btn-outline-danger btn-sm">Elimina</button>
              </form>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <!-- Paginazione -->
  <div class="card-lite pager">
    <?php
      $from = $total_rows ? ($offset + 1) : 0;
      $to   = min($offset + $perPage, $total_rows);
    ?>
    <div>Mostrati <?= $from ?>–<?= $to ?> di <?= $total_rows ?></div>
    <nav>
      <ul class="pagination pagination-sm mb-0">
        <li class="page-item <?= $page<=1?'disabled':'' ?>">
          <a class="page-link" href="<?= $page<=1 ? '#' : h(build_page_url($page-1)) ?>">« Precedente</a>
        </li>
        <li class="page-item disabled"><span class="page-link">Pagina <?= $page ?> / <?= $total_pages ?></span></li>
        <li class="page-item <?= $page>=$total_pages?'disabled':'' ?>">
          <a class="page-link" href="<?= $page>=$total_pages ? '#' : h(build_page_url($page+1)) ?>">Successiva »</a>
        </li>
      </ul>
    </nav>
  </div>
</div>

<?php require_once __DIR__.'/../partials/footer.php'; ?>

<!-- ===== MODAL Pagamenti ===== -->
<div class="modal fade" id="paymentsModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Pagamenti — <span id="pmUserEmail"></span> (#<span id="pmUserId"></span>)</h5>
        <button class="btn-close" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <div class="modal-body">
        <div id="pmLoading" class="text-center py-3"><div class="spinner-border" role="status"></div><div class="small text-muted mt-2">Caricamento…</div></div>
        <div id="pmEmpty" class="alert alert-info d-none">Nessun pagamento registrato.</div>
        <div class="table-responsive d-none" id="pmTableWrap">
          <table class="table table-sm align-middle"><thead><tr>
            <th>Data</th><th>Importo</th><th>Metodo</th><th>Stato</th><th>Periodo</th><th>Note</th><th style="width:90px"></th>
          </tr></thead><tbody id="pmBody"></tbody></table>
        </div>
        <hr class="my-3">
        <form id="pmForm" class="row g-2">
          <input type="hidden" name="user_id" id="pmUserIdInput">
          <div class="col-6 col-md-3"><label class="form-label">Importo</label><input type="number" step="0.01" min="0" name="amount" class="form-control" required></div>
          <div class="col-6 col-md-2"><label class="form-label">Valuta</label><input type="text" name="currency" value="EUR" class="form-control" maxlength="8" required></div>
          <div class="col-6 col-md-3"><label class="form-label">Metodo</label><input type="text" name="method" class="form-control" placeholder="es. PayPal"></div>
          <div class="col-6 col-md-2"><label class="form-label">Stato</label><select name="status" class="form-select"><option value="paid">paid</option><option value="pending">pending</option><option value="failed">failed</option><option value="refunded">refunded</option></select></div>
          <div class="col-6 col-md-2"><label class="form-label">Dal</label><input type="date" name="period_from" class="form-control"></div>
          <div class="col-6 col-md-2"><label class="form-label">Al</label><input type="date" name="period_to" class="form-control"></div>
          <div class="col-12"><label class="form-label">Note</label><input type="text" name="note" class="form-control" maxlength="255"></div>
          <div class="col-12 d-grid d-md-flex gap-2"><button class="btn btn-success">Aggiungi pagamento</button><button type="button" class="btn btn-outline-secondary" id="pmReloadBtn">Ricarica</button></div>
        </form>
      </div>
      <div class="modal-footer"><button class="btn btn-outline-secondary" data-bs-dismiss="modal">Chiudi</button></div>
    </div>
  </div>
</div>

<!-- ===== MODAL Dispositivi ===== -->
<div class="modal fade" id="admDevicesModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Dispositivi — <span id="dvUserEmail"></span> (#<span id="dvUserId"></span>)</h5>
        <button class="btn-close" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <div class="modal-body">
        <div id="dvLoading" class="text-center py-3"><div class="spinner-border" role="status"></div><div class="small text-muted mt-2">Caricamento…</div></div>
        <div id="dvEmpty" class="alert alert-info d-none">Nessun dispositivo registrato.</div>
        <div class="table-responsive d-none" id="dvTableWrap">
          <table class="table table-sm align-middle">
            <thead><tr><th style="width:120px">IP</th><th>Dispositivo</th><th>UA</th><th style="width:160px">Creato</th><th style="width:160px">Ultimo accesso</th></tr></thead>
            <tbody id="dvBody"></tbody>
          </table>
        </div>
      </div>
      <div class="modal-footer"><button class="btn btn-outline-secondary" data-bs-dismiss="modal">Chiudi</button></div>
    </div>
  </div>
</div>

<script>
// Toggle registrazione
document.getElementById('toggleRegBtn')?.addEventListener('click', async function(){
  const btn=this; btn.disabled=true;
  try{
    const r=await fetch(location.pathname+location.search,{method:'POST',headers:{'X-Requested-With':'XMLHttpRequest'},body:new URLSearchParams({toggle_reg:'1'})});
    if(!r.ok) throw new Error('http '+r.status); const j=await r.json();
    const card=btn.closest('.card-lite'); const state=card.querySelector('.text-success, .text-secondary');
    if(j.enabled){ state.className='text-success'; state.textContent='Abilitata'; btn.className='btn btn-outline-danger'; btn.textContent='Disattiva'; }
    else { state.className='text-secondary'; state.textContent='Disabilitata'; btn.className='btn btn-outline-success'; btn.textContent='Attiva'; }
  }catch(e){ alert('Errore durante il salvataggio.'); } finally{ btn.disabled=false; }
});

// Badge guadagni live
async function refreshRevenue(){
  try{ const r=await fetch('/admin/api_revenue_sum.php',{cache:'no-store'}); if(!r.ok) return; const j=await r.json();
    if(j && typeof j.sum!=='undefined'){ document.getElementById('revTotal').textContent=Number(j.sum).toFixed(2).replace('.',','); }
  }catch(e){}
}

/* ===== Pagamenti ===== */
const pmModal=document.getElementById('paymentsModal'), pmUserIdEl=document.getElementById('pmUserId'),
      pmUserEmailEl=document.getElementById('pmUserEmail'), pmUserIdInput=document.getElementById('pmUserIdInput'),
      pmBody=document.getElementById('pmBody'), pmLoading=document.getElementById('pmLoading'),
      pmEmpty=document.getElementById('pmEmpty'), pmTableWrap=document.getElementById('pmTableWrap'),
      pmForm=document.getElementById('pmForm'), pmReloadBtn=document.getElementById('pmReloadBtn');

function esc(s){return (s??'').replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));}

async function loadPayments(uid){
  pmLoading.classList.remove('d-none'); pmEmpty.classList.add('d-none'); pmTableWrap.classList.add('d-none'); pmBody.innerHTML='';
  try{
    const r=await fetch('/admin/api_user_payments.php?user_id='+encodeURIComponent(uid),{cache:'no-store'}); const j=await r.json();
    const items=(j&&j.items)?j.items:[];
    if(items.length===0){ pmEmpty.classList.remove('d-none'); }
    else{ pmTableWrap.classList.remove('d-none'); for(const it of items){
      const tr=document.createElement('tr'); const period=(it.period_from||it.period_to)?`${it.period_from||''} → ${it.period_to||''}`:'';
      tr.innerHTML=`<td>${esc(it.created_at||'')}</td><td>${esc((it.amount!=null?Number(it.amount).toFixed(2):'-')+' '+(it.currency||''))}</td><td>${esc(it.method||'')}</td><td>${esc(it.status||'')}</td><td>${esc(period)}</td><td>${esc(it.note||'')}</td><td><button class="btn btn-outline-danger btn-sm" data-del-id="${it.id}">Del</button></td>`;
      pmBody.appendChild(tr);
    } }
  }catch(e){ pmEmpty.classList.remove('d-none'); } finally{ pmLoading.classList.add('d-none'); }
}
pmModal?.addEventListener('show.bs.modal', ev=>{
  const b=ev.relatedTarget, uid=b?.getAttribute('data-user-id'), email=b?.getAttribute('data-user-email')||'';
  pmUserIdEl.textContent=uid||''; pmUserEmailEl.textContent=email; pmUserIdInput.value=uid||''; loadPayments(uid);
});
pmReloadBtn?.addEventListener('click',()=>loadPayments(pmUserIdInput.value));
pmForm?.addEventListener('submit', async e=>{
  e.preventDefault(); const fd=new FormData(pmForm);
  try{ const r=await fetch('/admin/api_payment_create.php',{method:'POST',body:fd}); const j=await r.json();
    if(j && j.ok){ pmForm.reset(); pmUserIdInput.value=j.user_id; await loadPayments(j.user_id); refreshRevenue(); }
    else alert('Errore nel salvataggio.');
  }catch(e){ alert('Errore di rete.'); }
});
pmBody?.addEventListener('click', async e=>{
  const b=e.target.closest('button[data-del-id]'); if(!b) return; if(!confirm('Eliminare questo pagamento?')) return;
  const id=b.getAttribute('data-del-id'), uid=pmUserIdInput.value;
  try{ const r=await fetch('/admin/api_user_payments.php',{method:'POST',headers:{'Content-Type':'application/x-www-form-urlencoded'},body:new URLSearchParams({action:'delete',id,user_id:uid})});
    const j=await r.json(); if(j && j.ok){ await loadPayments(uid); refreshRevenue(); } else alert('Impossibile eliminare.');
  }catch(e){ alert('Errore di rete.'); }
});

/* ===== Dispositivi ===== */
const dvModal=document.getElementById('admDevicesModal'),
      dvUserIdEl=document.getElementById('dvUserId'), dvUserEmailEl=document.getElementById('dvUserEmail'),
      dvBody=document.getElementById('dvBody'), dvLoading=document.getElementById('dvLoading'),
      dvEmpty=document.getElementById('dvEmpty'), dvWrap=document.getElementById('dvTableWrap');

async function loadDevices(uid){
  dvLoading.classList.remove('d-none'); dvEmpty.classList.add('d-none'); dvWrap.classList.add('d-none'); dvBody.innerHTML='';
  try{
    const r=await fetch('/admin/api_user_devices.php?user_id='+encodeURIComponent(uid),{cache:'no-store'});
    const j=await r.json(); const items=(j&&j.items)?j.items:[];
    if(items.length===0){ dvEmpty.classList.remove('d-none'); }
    else{
      dvWrap.classList.remove('d-none');
      for(const it of items){
        const tr=document.createElement('tr');
        tr.innerHTML=`<td>${esc(it.ip||'')}</td><td>${esc(it.device_name||'')}</td><td class="small">${esc(it.user_agent||'')}</td><td>${esc(it.created_at||'')}</td><td>${esc(it.last_seen||'')}</td>`;
        dvBody.appendChild(tr);
      }
    }
  }catch(e){ dvEmpty.classList.remove('d-none'); }
  finally{ dvLoading.classList.add('d-none'); }
}
dvModal?.addEventListener('show.bs.modal', ev=>{
  const b=ev.relatedTarget, uid=b?.getAttribute('data-user-id'), email=b?.getAttribute('data-user-email')||'';
  dvUserIdEl.textContent=uid||''; dvUserEmailEl.textContent=email; loadDevices(uid);
});
</script>
