/* ============ AURA EFFECTS ============ */
/* Tutto opt-in via [data-effects="on"] sul <body>. Non tocca la logica PHP. */

(function(){
  const root = document.documentElement;
  const body = document.body;
  const effectsOn = body && body.getAttribute('data-effects') === 'on';

  // Page fade-in
  body.classList.add('page-fade-in');

  if(!effectsOn) return;

  /* -------- IntersectionObserver per reveal -------- */
  const io = new IntersectionObserver((entries)=>{
    entries.forEach(e=>{
      if(e.isIntersecting){
        e.target.classList.add('in-view');
        // Se vuoi “solo una volta”:
        io.unobserve(e.target);
      }
    });
  },{threshold: .12});

  document.querySelectorAll('.reveal-up, .reveal-left, .reveal-right').forEach(el=>io.observe(el));

  /* -------- Magnetic Buttons (opt-in con .magnet) -------- */
  const magnets = Array.from(document.querySelectorAll('.magnet'));
  magnets.forEach(btn=>{
    const strength = parseFloat(btn.dataset.magnet) || 12; // px
    let rect=null;
    function onMove(ev){
      if(!rect) rect = btn.getBoundingClientRect();
      const x = ev.clientX - (rect.left + rect.width/2);
      const y = ev.clientY - (rect.top + rect.height/2);
      btn.style.transform = `translate(${x/strength}px, ${y/strength}px)`;
    }
    function onLeave(){
      btn.style.transform = 'translate(0,0)';
      rect=null;
    }
    btn.addEventListener('mousemove', onMove);
    btn.addEventListener('mouseleave', onLeave);
  });

  /* -------- Parallax su elementi con [data-parallax] --------
     Esempio: <div data-parallax="8"> ... </div> (numero = intensità) */
  const prxEls = Array.from(document.querySelectorAll('[data-parallax]'));
  if(prxEls.length){
    window.addEventListener('mousemove', (e)=>{
      const cx = window.innerWidth/2, cy = window.innerHeight/2;
      const dx = (e.clientX - cx) / cx; // -1..1
      const dy = (e.clientY - cy) / cy;
      prxEls.forEach(el=>{
        const amt = parseFloat(el.getAttribute('data-parallax')) || 8;
        el.style.transform = `translate3d(${(-dx*amt).toFixed(1)}px, ${(-dy*amt).toFixed(1)}px, 0)`;
      });
    }, {passive:true});
  }

  /* -------- Page fade-out sui link interni -------- */
  document.addEventListener('click', (e)=>{
    const a = e.target.closest('a');
    if(!a) return;
    if(a.target === '_blank') return;
    if(a.hasAttribute('download')) return;
    const href = a.getAttribute('href') || '';
    if(/^#/.test(href)) return;
    if(/^https?:\/\//i.test(href) && !href.includes(location.host)) return;

    // tasti modificatori: non bloccare
    if(e.metaKey || e.ctrlKey || e.shiftKey || e.altKey) return;

    // submit normali o SPA: lascia stare
    if(a.getAttribute('role') === 'button') return;

    e.preventDefault();
    body.classList.add('page-fade-out');
    setTimeout(()=>{ window.location.href = href; }, 160);
  });
})();
