<?php
require_once __DIR__.'/../config.php';
// rimosso: require_once __DIR__.'/../lib/ip_session_guard.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset','UTF-8');
mb_internal_encoding('UTF-8');

function u(string $s): string { return html_entity_decode($s, ENT_QUOTES | ENT_HTML5, 'UTF-8'); }

/* Registrazione abilitata (default ON) */
$st = $pdo->prepare("SELECT value FROM settings WHERE `key`='registration_enabled'");
$st->execute();
$row = $st->fetch();
$registration_enabled = !$row || $row['value'] === '1';

/* Se già loggato -> dashboard */
if (!empty($_SESSION['user'])) { header('Location: /client/dashboard.php'); exit; }

/* Messaggi */
$error  = '';
$notice = '';

/* Login da cookie remember (senza limite IP) */
if (empty($_SESSION['user']) && !empty($_COOKIE['rememberme'])) {
  [$uid, $token] = explode(':', $_COOKIE['rememberme'], 2);
  $stmt = $pdo->prepare("SELECT id,email,role,remember_token FROM users WHERE id=?");
  $stmt->execute([(int)$uid]);
  if ($row = $stmt->fetch()) {
    if (hash_equals($row['remember_token'] ?? '', $token)) {
      $role = in_array($row['role'], ['admin','client'], true) ? $row['role'] : 'client';

      if (session_status() !== PHP_SESSION_ACTIVE) session_start();
      session_regenerate_id(true);

      $_SESSION['user'] = ['id'=>$row['id'],'email'=>$row['email'],'role'=>$role];
      header('Location: '.($role==='admin' ? '/admin/index.php' : '/client/dashboard.php'));
      exit;
    } else {
      // token non valido -> pulisci cookie
      setcookie('rememberme', '', time()-3600, '/', '', !empty($_SERVER['HTTPS']), true);
    }
  } else {
    // utente non trovato -> pulisci cookie
    setcookie('rememberme', '', time()-3600, '/', '', !empty($_SERVER['HTTPS']), true);
  }
}

/* ====== MODALITÀ: login | register | reset (solo POST dal modal) ====== */
$mode   = $_POST['mode'] ?? ($_GET['mode'] ?? 'login');
if (!$registration_enabled && $mode === 'register') $mode = 'login';

$prefill_email    = $_SERVER['REQUEST_METHOD'] === 'POST' ? trim($_POST['email'] ?? '') : '';
$prefill_remember = $_SERVER['REQUEST_METHOD'] === 'POST' ? !empty($_POST['remember']) : false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $mode = $_POST['mode'] ?? 'login';

  if ($mode === 'login') {
    $email = trim($_POST['email'] ?? '');
    $pass  = $_POST['password'] ?? '';
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $u = $stmt->fetch();

    if ($u && password_verify($pass, $u['password_hash'])) {
      $role = in_array($u['role'], ['admin','client'], true) ? $u['role'] : 'client';

      if (session_status() !== PHP_SESSION_ACTIVE) session_start();
      session_regenerate_id(true);

      $_SESSION['user'] = ['id'=>$u['id'],'email'=>$u['email'],'role'=>$role];

      if (!empty($_POST['remember'])) {
        $token = bin2hex(random_bytes(16));
        $pdo->prepare("UPDATE users SET remember_token=? WHERE id=?")->execute([$token, $u['id']]);
        setcookie('rememberme', $u['id'].':'.$token, [
          'expires'  => time()+60*60*24*30,
          'path'     => '/',
          'secure'   => !empty($_SERVER['HTTPS']),
          'httponly' => true,
          'samesite' => 'Lax'
        ]);
      }
      header('Location: '.($role==='admin' ? '/admin/index.php' : '/client/dashboard.php'));
      exit;
    } else {
      $error = 'Credenziali non valide';
    }

  } elseif ($mode === 'register') {
    if (!$registration_enabled) {
      $error = 'Registrazione disabilitata dall’amministratore.';
      $mode = 'login';
    } else {
      $email = trim($_POST['email'] ?? '');
      $pass  = $_POST['password'] ?? '';
      $pass2 = $_POST['password_confirm'] ?? '';

      if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Inserisci un indirizzo email valido.';
      } elseif (strlen($pass) < 8) {
        $error = 'La password deve contenere almeno 8 caratteri.';
      } elseif ($pass !== $pass2) {
        $error = 'Le password non coincidono.';
      } else {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        if ($stmt->fetch()) {
          $error = u('Email gi&agrave; registrata.');
        } else {
          $hash = password_hash($pass, PASSWORD_DEFAULT);
          $ins  = $pdo->prepare("INSERT INTO users (email, password_hash, role) VALUES (?, ?, 'client')");
          if ($ins->execute([$email, $hash])) {
            $uid = (int)$pdo->lastInsertId();

            if (session_status() !== PHP_SESSION_ACTIVE) session_start();
            session_regenerate_id(true);

            $_SESSION['user'] = ['id'=>$uid, 'email'=>$email, 'role'=>'client'];

            if (!empty($_POST['remember'])) {
              $token = bin2hex(random_bytes(16));
              $pdo->prepare("UPDATE users SET remember_token=? WHERE id=?")->execute([$token, $uid]);
              setcookie('rememberme', $uid.':'.$token, [
                'expires'  => time()+60*60*24*30,
                'path'     => '/',
                'secure'   => !empty($_SERVER['HTTPS']),
                'httponly' => true,
                'samesite' => 'Lax'
              ]);
            }
            header('Location: /client/dashboard.php');
            exit;
          } else {
            $error = 'Registrazione non riuscita. Riprova.';
          }
        }
      }
    }

  } elseif ($mode === 'reset') {
    // Richiesta link di reset (arriva dal modal)
    $email = trim($_POST['email'] ?? '');
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
      $error = 'Inserisci un indirizzo email valido.';
    } else {
      // Messaggio "neutro" senza rivelare esistenza email
      $st = $pdo->prepare("SELECT id FROM users WHERE email=?");
      $st->execute([$email]);
      if ($u = $st->fetch()) {
        $token = bin2hex(random_bytes(32));
        $exp   = (new DateTime('+1 hour'))->format('Y-m-d H:i:s');
        $pdo->prepare("UPDATE users SET reset_token=?, reset_expires=? WHERE id=?")->execute([$token, $exp, (int)$u['id']]);

        $base = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off' ? 'https' : 'http').'://'.$_SERVER['HTTP_HOST'];
        $link = $base.'/auth/reset.php?token='.$token;

        require_once __DIR__.'/../lib/mailer.php';
        $subject = 'Reimposta la tua password';
        $html = '<p>Ciao,</p><p>abbiamo ricevuto una richiesta di reimpostazione della password.</p>'
              . '<p><a href="'.htmlspecialchars($link,ENT_QUOTES).'">Reimposta password</a> (valido 1 ora)</p>'
              . '<p>Se non hai richiesto tu il reset, ignora questa email.</p>';
        try { send_app_mail($email, $subject, $html); } catch(Throwable $e) {}
      }
      $notice = 'Se l’indirizzo è registrato, riceverai a breve un’email con il link di reset.';
    }
    // Torna sempre alla vista di login
    $mode = 'login';
  }
}
?>
<!DOCTYPE html>
<html lang="it">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= $mode==='register' ? 'Registrazione' : 'Accesso' ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    html, body { height: 100%; margin: 0; overflow: hidden; font-family: Arial, sans-serif; }
    .bg-video { position: fixed; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; z-index: -1; }
    .overlay { position: fixed; inset: 0; background: rgba(0,0,0,.6); z-index: 0; }
    .login-box{
      position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);
      max-width: 460px; width: 92%;
      background: rgba(255,255,255,0.2);
      padding: 26px; border-radius: 16px;
      box-shadow: 0 4px 30px rgba(0,0,0,0.5);
      backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px);
      border: 1px solid rgba(255,255,255,0.3); z-index: 1;
    }
    .toggle{ display: grid; grid-template-columns: 1fr 1fr; gap: 8px; margin-bottom: 16px; }
    .toggle .btn{ font-weight: 700; letter-spacing: .2px; }
    .small-link { display:block; margin-top:6px; color:#fff; text-decoration:underline; cursor:pointer; }
  </style>
</head>
<body>

<video autoplay muted loop playsinline class="bg-video">
  <source src="/uploads/sport-bg.mp4" type="video/mp4">
</video>
<div class="overlay"></div>

<div class="login-box">
  <div class="toggle">
    <button id="btnLogin" class="btn <?= $mode==='login' ? 'btn-light' : 'btn-outline-light' ?> w-100">Accedi</button>
    <?php if($registration_enabled): ?>
      <button id="btnRegister" class="btn <?= $mode==='register' ? 'btn-light' : 'btn-outline-light' ?> w-100">Registrati</button>
    <?php else: ?>
      <button class="btn btn-outline-light w-100" disabled>Registrati</button>
    <?php endif; ?>
  </div>

  <h3 id="formTitle" class="mb-3 text-center text-white"><?= $mode==='register' && $registration_enabled ? 'Registrati' : 'Accedi' ?></h3>

  <?php if($error): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
  <?php elseif($notice): ?>
    <div class="alert alert-info"><?= htmlspecialchars($notice) ?></div>
  <?php endif; ?>

  <?php if(!$registration_enabled): ?>
    <div class="alert alert-warning py-2">Le registrazioni sono attualmente disabilitate.</div>
  <?php endif; ?>

  <form id="authForm" method="post" novalidate>
    <input type="hidden" name="mode" id="modeField" value="<?= htmlspecialchars($mode) ?>">

    <!-- Email -->
    <div class="mb-2">
      <label class="form-label text-white">Email</label>
      <input class="form-control" type="email" name="email"
             value="<?= htmlspecialchars($prefill_email, ENT_QUOTES) ?>"
             autocomplete="username" required>
    </div>

    <!-- LOGIN -->
    <div class="mb-2 mode-login <?= $mode==='login'?'':'d-none' ?>">
      <label class="form-label text-white">Password</label>
      <input class="form-control" type="password" name="password" autocomplete="current-password" required>
      <a href="#" id="linkToReset" class="small-link">Hai dimenticato la password?</a>
    </div>

    <!-- REGISTER -->
    <div class="mb-2 mode-register <?= $mode==='register'?'':'d-none' ?>">
      <label class="form-label text-white">Password</label>
      <input class="form-control" type="password" name="password" minlength="8" autocomplete="new-password" required>
      <div class="form-text text-light">Minimo 8 caratteri.</div>
    </div>
    <div class="mb-2 mode-register <?= $mode==='register'?'':'d-none' ?>">
      <label class="form-label text-white">Conferma Password</label>
      <input class="form-control" type="password" name="password_confirm" autocomplete="new-password" required>
    </div>

    <div class="form-check mb-3 mode-login <?= $mode==='login'?'':'d-none' ?>">
      <input class="form-check-input" type="checkbox" name="remember" id="remember" <?= $prefill_remember ? 'checked' : '' ?>>
      <label for="remember" class="form-check-label text-white">Ricordami su questo dispositivo</label>
    </div>

    <button class="btn btn-primary w-100" id="submitBtn">
      <?= ($mode==='register' && $registration_enabled) ? 'Crea account' : 'Entra' ?>
    </button>
  </form>
</div>

<!-- ===== Modal Recupero Password ===== -->
<div class="modal fade" id="resetModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Recupero password</h5>
        <button class="btn-close" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <form method="post">
        <input type="hidden" name="mode" value="reset">
        <div class="modal-body">
          <label class="form-label">Inserisci la tua email</label>
          <input id="resetEmail" class="form-control" type="email" name="email" required>
          <div class="form-text">Se l’indirizzo è registrato, riceverai un link di reset (valido 1 ora).</div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-primary">Invia link</button>
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Annulla</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
(function(){
  const REG_ENABLED = <?= $registration_enabled ? 'true':'false' ?>;

  const modeField = document.getElementById('modeField');
  const formTitle = document.getElementById('formTitle');
  const btnLogin = document.getElementById('btnLogin');
  const btnRegister = document.getElementById('btnRegister');
  const linkToReset = document.getElementById('linkToReset');

  function show(sel, on){ document.querySelectorAll(sel).forEach(el=>el.classList.toggle('d-none', !on)); }
  function requireFields(sel, on){
    document.querySelectorAll(sel).forEach(inp=>{
      if(on){ inp.setAttribute('required','required'); inp.removeAttribute('disabled'); }
      else { inp.removeAttribute('required'); inp.setAttribute('disabled','disabled'); }
    });
  }
  function toggleBtns(mode){
    const set=(btn,active)=>{ if(!btn) return; btn.classList.toggle('btn-light',active); btn.classList.toggle('btn-outline-light',!active); };
    set(btnLogin, mode==='login'); set(btnRegister, mode==='register');
  }
  function setMode(mode){
    if(!REG_ENABLED && mode==='register') mode='login';
    modeField.value = mode;
    show('.mode-login',   mode==='login');
    show('.mode-register',mode==='register');
    requireFields('.mode-login input[name=password]',   mode==='login');
    requireFields('.mode-register input',               mode==='register');
    formTitle.textContent = (mode==='register') ? 'Registrati' : 'Accedi';
    toggleBtns(mode);
  }

  btnLogin.addEventListener('click',   e=>{ e.preventDefault(); setMode('login'); });
  btnRegister?.addEventListener('click',e=>{ e.preventDefault(); setMode('register'); });

  // Apri modal reset da link
  linkToReset?.addEventListener('click', e=>{
    e.preventDefault();
    const emailField = document.querySelector('input[name="email"]');
    const resetEmail = document.getElementById('resetEmail');
    if(emailField && resetEmail) resetEmail.value = emailField.value.trim();
    const m = new bootstrap.Modal(document.getElementById('resetModal'));
    m.show();
  });

  setMode(<?= json_encode(in_array($mode,['login','register'],true)?$mode:'login') ?>);
})();
</script>

</body>
</html>