<?php
// /auth/logout.php
require_once __DIR__.'/../config.php'; // opzionale, per coerenza dell'ambiente

if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

/* invalida solo il cookie rememberme di questo device */
if (!empty($_COOKIE['rememberme'])) {
  setcookie('rememberme', '', [
    'expires'  => time()-3600,
    'path'     => '/',
    'secure'   => !empty($_SERVER['HTTPS']),
    'httponly' => true,
    'samesite' => 'Lax'
  ]);
}

/* distruggi sessione PHP + cookie di sessione */
$_SESSION = [];
if (ini_get('session.use_cookies')) {
  $p = session_get_cookie_params();
  setcookie(session_name(), '', time()-42000, $p['path'], $p['domain'] ?? '', !empty($_SERVER['HTTPS']), true);
}
session_destroy();

/* redirect al login */
header('Location: /auth/login.php');
exit;