<?php
// /auth/reset.php
require_once __DIR__.'/../config.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset','UTF-8');
mb_internal_encoding('UTF-8');

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$token  = trim($_GET['token'] ?? '');
$error  = '';
$notice = '';

/* --- Validazione token anche in GET, così eviti di mostrare il form se già non valido --- */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  if ($token === '' || strlen($token) < 20) {
    $error = 'Link non valido.';
  } else {
    $st = $pdo->prepare("SELECT id FROM users WHERE reset_token=? AND reset_expires IS NOT NULL AND reset_expires > NOW()");
    $st->execute([$token]);
    if (!$st->fetch()) {
      $error = 'Link scaduto o non valido.';
    }
  }
}

/* --- Submit cambio password --- */
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $token = trim($_POST['token'] ?? '');
  $p1 = (string)($_POST['password'] ?? '');
  $p2 = (string)($_POST['password_confirm'] ?? '');

  if ($token==='' || strlen($token) < 20) {
    $error = 'Link non valido.';
  } elseif (strlen($p1) < 8) {
    $error = 'La nuova password deve avere almeno 8 caratteri.';
  } elseif ($p1 !== $p2) {
    $error = 'Le password non coincidono.';
  } else {
    $st = $pdo->prepare("SELECT id FROM users WHERE reset_token=? AND reset_expires IS NOT NULL AND reset_expires > NOW()");
    $st->execute([$token]);
    if ($row = $st->fetch()) {
      $hash = password_hash($p1, PASSWORD_DEFAULT);
      $pdo->prepare("UPDATE users SET password_hash=?, reset_token=NULL, reset_expires=NULL WHERE id=?")
          ->execute([$hash, (int)$row['id']]);
      $notice = 'Password aggiornata! Ora puoi effettuare l’accesso.';
    } else {
      $error = 'Link scaduto o non valido.';
    }
  }
}
?>
<!doctype html>
<html lang="it">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Reimposta password</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    html, body { height: 100%; margin: 0; overflow: hidden; font-family: Arial, sans-serif; }
    .bg-video { position: fixed; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; z-index: -1; }
    .overlay { position: fixed; inset: 0; background: rgba(0,0,0,.6); z-index: 0; }
    .box{
      position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);
      max-width: 460px; width: 92%;
      background: rgba(255,255,255,0.2);
      padding: 26px; border-radius: 16px;
      box-shadow: 0 4px 30px rgba(0,0,0,0.5);
      backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px);
      border: 1px solid rgba(255,255,255,0.3); z-index: 1;
      color: #fff;
    }
    .box h3{ text-align:center; margin-bottom: 14px; }
    .form-label{ color:#fff; }
    .hint{ color:#e9ecef; opacity:.85; font-size:.9rem; }
  </style>
</head>
<body>

<video autoplay muted loop playsinline class="bg-video">
  <source src="/uploads/sport-bg.mp4" type="video/mp4">
</video>
<div class="overlay"></div>

<div class="box">
  <h3>Reimposta password</h3>

  <?php if($error): ?>
    <div class="alert alert-danger"><?= h($error) ?></div>
    <a class="btn btn-outline-light w-100" href="/auth/login.php">Torna al login</a>

  <?php elseif($notice): ?>
    <div class="alert alert-success"><?= h($notice) ?></div>
    <a class="btn btn-light w-100" href="/auth/login.php">Vai al login</a>

  <?php else: ?>
    <p class="hint">Scegli una nuova password (minimo 8 caratteri) e confermala.</p>
    <form method="post" novalidate>
      <input type="hidden" name="token" value="<?= h($token) ?>">
      <div class="mb-3">
        <label class="form-label">Nuova password</label>
        <input type="password" name="password" class="form-control" minlength="8" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Conferma password</label>
        <input type="password" name="password_confirm" class="form-control" minlength="8" required>
      </div>
      <button class="btn btn-light w-100">Aggiorna password</button>
      <a class="btn btn-outline-light w-100 mt-2" href="/auth/login.php">Annulla</a>
    </form>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
