<?php
require_once __DIR__.'/../config.php';
require_login();
header('Content-Type: application/json; charset=utf-8');

if (empty($API_F1_KEY)) {
  echo json_encode(['error' => 'API key mancante']); exit;
}

// cache 60s
$cacheFile = sys_get_temp_dir() . '/apif1_live_cache.json';
$cacheTTL  = 60;
if (is_file($cacheFile) && (time()-filemtime($cacheFile) < $cacheTTL)) {
  readfile($cacheFile); exit;
}

function apisports_f1_get($path,$params=[]){
  global $API_F1_KEY,$API_F1_HOST;
  $qs = $params ? '?'.http_build_query($params) : '';
  $url = "https://{$API_F1_HOST}/{$path}{$qs}";
  $ch = curl_init($url);
  curl_setopt_array($ch,[
    CURLOPT_RETURNTRANSFER=>true,
    CURLOPT_TIMEOUT=>15,
    CURLOPT_HTTPHEADER=>[
      'Accept: application/json',
      'x-apisports-key: '.$API_F1_KEY,
    ]
  ]);
  $res=curl_exec($ch);
  $info=curl_getinfo($ch);
  curl_close($ch);
  if($res===false) return ['error'=>'curl error'];
  if($info['http_code']>=400) return ['error'=>'HTTP '.$info['http_code'],'raw'=>$res];
  return json_decode($res,true);
}

// Prendi la gara corrente (se live o weekend attivo)
$data = apisports_f1_get('races',['current'=>true]);

$out = ['items'=>[]];
foreach(($data['response']??[]) as $race){
  $out['items'][] = [
    'competition'=>$race['competition']['name'] ?? '',
    'circuit'=>$race['circuit']['name'] ?? '',
    'location'=>$race['circuit']['location']['country'] ?? '',
    'status'=>$race['status'] ?? '',
    'date'=>$race['date'] ?? '',
    'time'=>$race['time'] ?? '',
    'laps'=>$race['laps']['current'] ?? null,
    'distance'=>$race['distance'] ?? '',
  ];
}

$json = json_encode($out);
@file_put_contents($cacheFile,$json);
echo $json;
