<?php
// /client/api_live_presence.php (compat con schema legacy)
require_once __DIR__ . '/../config.php';

if (!headers_sent()) {
  header('Content-Type: application/json; charset=utf-8');
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
}
if (session_status() !== PHP_SESSION_ACTIVE) @session_start();

$uid = (int)($_SESSION['user']['id'] ?? 0);
if ($uid <= 0) { http_response_code(401); echo json_encode(['error'=>'unauthorized']); exit; }

$live_id = isset($_POST['live_id']) ? (int)$_POST['live_id'] : 0;
if ($live_id <= 0) { http_response_code(400); echo json_encode(['error'=>'live_id mancante','count'=>0]); exit; }

$sess = session_id();
if (!$sess) {
  $ua  = (string)($_SERVER['HTTP_USER_AGENT'] ?? '');
  $ip0 = (string)($_SERVER['REMOTE_ADDR'] ?? '');
  $sess = substr(hash('sha256', $ip0.'|'.$ua), 0, 64);
}

// cookie device (se la colonna c'è, lo usiamo, altrimenti no)
$devKey = $_COOKIE['dev_id'] ?? '';
if (!preg_match('/^[A-Fa-f0-9]{40,128}$/', $devKey)) {
  try { $devKey = bin2hex(random_bytes(24)); } catch (Throwable $e) { $devKey = bin2hex(openssl_random_pseudo_bytes(24)); }
  setcookie('dev_id', $devKey, [
    'expires'=> time()+60*60*24*365*5,
    'path'=>'/', 'secure'=>!empty($_SERVER['HTTPS']), 'httponly'=>true, 'samesite'=>'Lax'
  ]);
  $_COOKIE['dev_id'] = $devKey;
}

// helpers
function col_exists(PDO $pdo, string $table, string $col): bool {
  try {
    $db = $pdo->query("SELECT DATABASE()")->fetchColumn();
    $q  = $pdo->prepare("SELECT COUNT(*) FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND COLUMN_NAME=?");
    $q->execute([$db,$table,$col]); return (bool)$q->fetchColumn();
  }catch(Throwable $e){ return false; }
}
function idx_exists(PDO $pdo, string $table, string $idx): bool {
  try {
    $db = $pdo->query("SELECT DATABASE()")->fetchColumn();
    $q  = $pdo->prepare("SELECT COUNT(*) FROM information_schema.STATISTICS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND INDEX_NAME=?");
    $q->execute([$db,$table,$idx]); return (bool)$q->fetchColumn();
  }catch(Throwable $e){ return false; }
}

// assicura tabella base (non altera se esiste già)
try {
  $pdo->exec("CREATE TABLE IF NOT EXISTS live_presence (
    live_id INT NOT NULL,
    sess_id VARCHAR(128) NULL,
    user_id INT NULL,
    updated_at DATETIME NOT NULL,
    KEY idx_live (live_id),
    KEY idx_user (user_id),
    KEY idx_updated (updated_at)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
} catch (Throwable $e) {}

$hasDev = col_exists($pdo,'live_presence','device_key');
$hasIp  = col_exists($pdo,'live_presence','ip');

// se possiamo, crea indici unici che servono per l'upsert
if ($hasDev && !idx_exists($pdo,'live_presence','uniq_live_user_dev')) {
  try { $pdo->exec("CREATE UNIQUE INDEX uniq_live_user_dev ON live_presence(live_id,user_id,device_key)"); } catch(Throwable $e){}
}
if (!idx_exists($pdo,'live_presence','uniq_live_sess')) {
  try { $pdo->exec("CREATE UNIQUE INDEX uniq_live_sess ON live_presence(live_id,sess_id)"); } catch(Throwable $e){}
}

// TTL breve
$TTL = 20;

// GC
try {
  $gc = $pdo->prepare("DELETE FROM live_presence WHERE updated_at < (NOW() - INTERVAL ? SECOND)");
  $gc->execute([$TTL]);
} catch (Throwable $e) {}

// upsert presenza
try {
  if ($hasDev) {
    if ($hasIp) {
      $st = $pdo->prepare("INSERT INTO live_presence (live_id,user_id,device_key,ip,updated_at)
                           VALUES (?,?,?,?,NOW())
                           ON DUPLICATE KEY UPDATE ip=VALUES(ip), updated_at=NOW()");
      $st->execute([$live_id,$uid,$devKey,($_SERVER['REMOTE_ADDR'] ?? '')]);
    } else {
      $st = $pdo->prepare("INSERT INTO live_presence (live_id,user_id,device_key,updated_at)
                           VALUES (?,?,?,NOW())
                           ON DUPLICATE KEY UPDATE updated_at=NOW()");
      $st->execute([$live_id,$uid,$devKey]);
    }
  } else {
    // schema legacy: niente device_key
    if ($hasIp) {
      $st = $pdo->prepare("INSERT INTO live_presence (live_id,sess_id,user_id,ip,updated_at)
                           VALUES (?,?,?,?,NOW())
                           ON DUPLICATE KEY UPDATE user_id=VALUES(user_id), ip=VALUES(ip), updated_at=NOW()");
      $st->execute([$live_id,$sess,$uid,($_SERVER['REMOTE_ADDR'] ?? '')]);
    } else {
      $st = $pdo->prepare("INSERT INTO live_presence (live_id,sess_id,user_id,updated_at)
                           VALUES (?,?,?,NOW())
                           ON DUPLICATE KEY UPDATE user_id=VALUES(user_id), updated_at=NOW()");
      $st->execute([$live_id,$sess,$uid]);
    }
  }
} catch (Throwable $e) {
  // se proprio fallisse, non blocchiamo la risposta
}

// conteggio
$count = 0;
try {
  $q = $pdo->prepare("SELECT COUNT(*) FROM live_presence WHERE live_id=? AND updated_at >= (NOW() - INTERVAL ? SECOND)");
  $q->execute([$live_id, $TTL]);
  $count = (int)$q->fetchColumn();
} catch (Throwable $e) {}

// altro device stesso utente?
$other = false;
try {
  if ($hasDev) {
    $q = $pdo->prepare("SELECT 1 FROM live_presence
                        WHERE live_id=? AND user_id=? AND device_key<>?
                          AND updated_at >= (NOW() - INTERVAL ? SECOND)
                        LIMIT 1");
    $q->execute([$live_id,$uid,$devKey,$TTL]);
  } else {
    $q = $pdo->prepare("SELECT 1 FROM live_presence
                        WHERE live_id=? AND user_id=? AND sess_id<>?
                          AND updated_at >= (NOW() - INTERVAL ? SECOND)
                        LIMIT 1");
    $q->execute([$live_id,$uid,$sess,$TTL]);
  }
  $other = (bool)$q->fetchColumn();
} catch (Throwable $e) {}

echo json_encode(['count'=>$count,'other_device'=>$other,'ts'=>time()]);