<?php
// /client/api_plan_request.php
require_once __DIR__ . '/../config.php';

function back($url){ if(!headers_sent()) header('Location: '.$url); exit; }
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

// Utente loggato?
$uid = (int)($_SESSION['user']['id'] ?? 0);
if($uid<=0){ back('/auth/login.php?mode=login'); }

$pid = (int)($_POST['plan_id'] ?? 0);
if($pid<=0){ back('/pricing.php'); }

// Carica piano attivo
$st = $pdo->prepare("SELECT * FROM plans WHERE id=? AND is_active=1");
$st->execute([$pid]); $p = $st->fetch();
if(!$p){ back('/pricing.php'); }

$months = (int)$p['months'];
$subject = "Richiesta attivazione piano {$p['name']} ({$months} ".($months===1?'mese':'mesi').")";
$fields = [
  'Piano'     => $p['name'],
  'Durata'    => $months.' '.($months===1?'mese':'mesi'),
  'Prezzo'    => number_format((float)$p['price'], 2, ',', '.').' '.($p['currency'] ?: 'EUR'),
  'Listino'   => $p['list_price'] ? number_format((float)$p['list_price'], 2, ',', '.').' '.($p['currency'] ?: 'EUR') : '-',
  'Slug'      => $p['slug'],
  'Note'      => 'Richiesta generata automaticamente dalla pagina prezzi.'
];

// Crea ticket + primo messaggio (come /client/ticket.php)
$pdo->beginTransaction();
$pdo->prepare("INSERT INTO tickets (user_id,subject,status,priority,form_json,created_at,updated_at)
               VALUES (?,?,?,?,?,NOW(),NOW())")
    ->execute([$uid,$subject,'open','Alta', json_encode($fields, JSON_UNESCAPED_UNICODE)]);
$tid = (int)$pdo->lastInsertId();

$msgLines = [];
foreach($fields as $k=>$v){ $msgLines[] = "$k: $v"; }
$pdo->prepare("INSERT INTO ticket_messages (ticket_id,sender,message,created_at) VALUES (?,?,?,NOW())")
    ->execute([$tid,'user',implode("\n",$msgLines)]);
$pdo->commit();

// piccolo flash
$_SESSION['flash'] = ['type'=>'success','msg'=>'Richiesta inviata! Ti risponderemo a breve con le istruzioni di pagamento.'];

back('/client/ticket.php?view='.$tid);
