<?php
require_once __DIR__.'/../config.php';
require_login();
header('Content-Type: application/json; charset=utf-8');

if (empty($API_FOOTBALL_KEY)) {
  echo json_encode(['error' => 'API key mancante in config.php']); exit;
}

// --- Cache per non superare i limiti del piano free ---
$cacheFile = sys_get_temp_dir() . '/apif_live_cache.json';
$cacheTTL  = 60; // secondi
$nocache   = isset($_GET['nocache']);

if (!$nocache && is_file($cacheFile) && (time() - filemtime($cacheFile) < $cacheTTL)) {
  readfile($cacheFile); exit;
}

// Chiamata a API-Sports (NO RapidAPI)
// Host corretto: v3.football.api-sports.io
// Path corretto: /fixtures  (senza /v3/)
function apisports_get_live(&$debug = null) {
  global $API_FOOTBALL_KEY, $API_FOOTBALL_HOST;

  $url = "https://{$API_FOOTBALL_HOST}/fixtures?live=all&timezone=Europe/Rome";

  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 20,
    CURLOPT_HTTPHEADER => [
      'Accept: application/json',
      'User-Agent: supersport.xo.je/1.0',
      'x-apisports-key: ' . $API_FOOTBALL_KEY,   // header corretto per API-Sports
    ],
  ]);
  $body = curl_exec($ch);
  $err  = curl_error($ch);
  $info = curl_getinfo($ch);
  curl_close($ch);

  $debug = ['info'=>$info, 'err'=>$err, 'body_sample'=>substr($body ?? '',0,500)];

  if ($body === false) return ['http'=>$info['http_code'] ?? 0, 'error'=>"cURL: $err"];
  $json = json_decode($body, true);
  if (($info['http_code'] ?? 0) >= 400) return ['http'=>$info['http_code'], 'error'=>"HTTP ".$info['http_code'], 'raw'=>$json ?: $body];

  return $json;
}

$debug = null;
$liveData = apisports_get_live($debug);

// Errori restituiti dall'API nel campo "errors"
if (isset($liveData['errors']) && $liveData['errors']) {
  $out = json_encode(['error' => json_encode($liveData['errors']), 'http' => 200]);
  @file_put_contents($cacheFile, $out);
  echo $out; exit;
}
if (isset($liveData['error'])) {
  $out = json_encode(['error' => $liveData['error'], 'http' => $liveData['http'] ?? null, 'raw' => $liveData['raw'] ?? null]);
  @file_put_contents($cacheFile, $out);
  echo $out; exit;
}

$leagueFilter = $LIVE_LEAGUE_IDS ?? [];
$items = [];

foreach (($liveData['response'] ?? []) as $fx) {
  $fixture   = $fx['fixture'] ?? [];
  $league    = $fx['league'] ?? [];
  $teams     = $fx['teams'] ?? [];
  $goals     = $fx['goals'] ?? [];
  $score     = $fx['score'] ?? [];

  // Filtra per leghe (se impostato)
  $leagueId  = $league['id'] ?? null;
  if (!empty($leagueFilter) && $leagueId && !in_array($leagueId, $leagueFilter, true)) continue;

  $items[] = [
    'fixture_id' => $fixture['id'] ?? null,
    'timestamp'  => $fixture['timestamp'] ?? null,
    'date'       => $fixture['date'] ?? null,
    'status'     => $fixture['status']['short'] ?? '',
    'elapsed'    => $fixture['status']['elapsed'] ?? null,
    'league_id'  => $leagueId,
    'league'     => $league['name'] ?? '',
    'country'    => $league['country'] ?? '',
    'round'      => $league['round'] ?? '',
    'home'       => [
      'id'   => $teams['home']['id'] ?? null,
      'name' => $teams['home']['name'] ?? '',
      'logo' => $teams['home']['logo'] ?? '',
      'goals'=> $goals['home'] ?? null,
    ],
    'away'       => [
      'id'   => $teams['away']['id'] ?? null,
      'name' => $teams['away']['name'] ?? '',
      'logo' => $teams['away']['logo'] ?? '',
      'goals'=> $goals['away'] ?? null,
    ],
    'score'      => [
      'halftime'  => $score['halftime'] ?? null,
      'fulltime'  => $score['fulltime'] ?? null,
      'extratime' => $score['extratime'] ?? null,
      'penalty'   => $score['penalty'] ?? null,
    ],
  ];
}

// <-- qui la riga corretta senza arrow function
usort($items, function($a, $b){
  return ($a['timestamp'] <=> $b['timestamp']);
});

$out = json_encode(['items'=>$items, 'cached_at'=>time()]);
@file_put_contents($cacheFile, $out);
echo $out;
