<?php
// client/api_search_lives.php
require_once __DIR__ . '/../partials/authguard.php'; // proteggi l'endpoint (solo utenti loggati)
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json; charset=utf-8');

$q = trim($_GET['q'] ?? '');
if ($q === '') {
  echo json_encode(['items' => []]);
  exit;
}

try {
  // Cerca per titolo; ordina dando priorit ai match prefisso
  $sql = "SELECT l.title, l.slug, l.image_path, l.event_at, l.always_live, c.name AS category
          FROM lives l
          JOIN categories c ON c.id = l.category_id
          WHERE l.is_active = 1 AND l.title LIKE ?
          ORDER BY CASE WHEN l.title LIKE ? THEN 0 ELSE 1 END, l.sort_order, l.id DESC
          LIMIT 20";
  $like = "%{$q}%";
  $prefix = "{$q}%";
  $st = $pdo->prepare($sql);
  $st->execute([$like, $prefix]);

  $items = [];
  while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
    $label = '';
    if (!empty($row['always_live'])) {
      $label = 'Sempre live';
    } elseif (!empty($row['event_at'])) {
      $label = date('d/m/Y H:i', strtotime($row['event_at']));
    } else {
      $label = 'Live';
    }
    $items[] = [
      'title'    => $row['title'],
      'slug'     => $row['slug'],
      'image'    => $row['image_path'],
      'category' => $row['category'],
      'label'    => $label,
    ];
  }

  echo json_encode(['items' => $items]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['items' => [], 'error' => 'query_failed']);
}
