<?php
// /client/api_user_devices_unlink.php
// Dissocia un device: se è il corrente => logout immediato; altrimenti kill remoto.
// Compatibile con schema user_devices: id,user_id,device_key,ip,user_agent,created_at,last_seen

require_once __DIR__.'/../config.php';
if (session_status() !== PHP_SESSION_ACTIVE) @session_start();

if (!headers_sent()) {
  header('Content-Type: application/json; charset=utf-8');
  header('Cache-Control: no-store');
}

// Richiede login
$uid = (int)($_SESSION['user']['id'] ?? 0);
if ($uid <= 0) { http_response_code(401); echo json_encode(['ok'=>false,'error'=>'unauthorized']); exit; }

// Helpers
function jerr($msg){ echo json_encode(['ok'=>false,'error'=>$msg]); exit; }

// Assicura tabelle minime
try {
  $pdo->exec("CREATE TABLE IF NOT EXISTS user_devices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    device_key VARCHAR(128) NOT NULL,
    ip VARCHAR(45) NULL,
    user_agent VARCHAR(255) NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_seen DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_user_device (user_id, device_key),
    KEY idx_user (user_id)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
  $pdo->exec("CREATE TABLE IF NOT EXISTS user_device_kill (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    device_key VARCHAR(128) NOT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    KEY idx_user_key (user_id, device_key)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
} catch (Throwable $e) {
  jerr('db_init');
}

// Per riconoscere il device corrente (baseKey + eventuali split "~")
require_once __DIR__.'/../partials/device_tracker.php';
$curBase = '';
try { $curBase = dt_devkey_base(); } catch(Throwable $e){ /* ok */ }

// Input
$device_key = trim((string)($_POST['device_key'] ?? ''));
$device_id  = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($device_key === '' && $device_id <= 0) jerr('missing_params');

// Carica riga device
try {
  if ($device_key !== '') {
    $st = $pdo->prepare("SELECT id, user_id, device_key, ip, user_agent FROM user_devices WHERE user_id=? AND device_key=? LIMIT 1");
    $st->execute([$uid,$device_key]);
  } else {
    $st = $pdo->prepare("SELECT id, user_id, device_key, ip, user_agent FROM user_devices WHERE user_id=? AND id=? LIMIT 1");
    $st->execute([$uid,$device_id]);
  }
  $dev = $st->fetch(PDO::FETCH_ASSOC);
  if (!$dev) jerr('not_found');
} catch (Throwable $e) {
  jerr('db_read');
}

// È il device corrente? (pari al baseKey o chiave "splittata" baseKey~...)
$dk = (string)$dev['device_key'];
$isSelf = false;
if ($curBase !== '') {
  $isSelf = hash_equals($dk, $curBase) || str_starts_with($dk, $curBase.'~');
}

// Funzione: registra un "kill" per device_key (esatto e varianti split)
function enqueue_kill(PDO $pdo, int $uid, string $keyBaseOrExact): void {
  // mettiamo sia la chiave esatta, sia (se è un base) anche un kill generico per tutte le ~varianti
  try {
    $ins = $pdo->prepare("INSERT INTO user_device_kill (user_id, device_key) VALUES (?, ?)");
    $ins->execute([$uid, $keyBaseOrExact]);
  } catch(Throwable $e){}
}

// SELF → sloggati subito, rimuovi la riga, optional kill (non necessario ma innocuo)
if ($isSelf) {
  try {
    $pdo->prepare("DELETE FROM user_devices WHERE user_id=? AND device_key=?")->execute([$uid, $dk]);
  } catch(Throwable $e){}
  enqueue_kill($pdo, $uid, $dk);

  // pulizia presence (best effort, indipendente dallo schema)
  try {
    $pdo->exec("DELETE FROM live_presence WHERE user_id=".$uid);
  } catch (Throwable $e){}

  // invalida rememberme e sessione
  if (!empty($_COOKIE['rememberme'])) {
    setcookie('rememberme','', time()-3600, '/', '', !empty($_SERVER['HTTPS']), true);
  }
  // kill sessione corrente
  $_SESSION = [];
  if (session_status() === PHP_SESSION_ACTIVE) {
    if (ini_get('session.use_cookies')) {
      $p = session_get_cookie_params();
      setcookie(session_name(), '', time()-42000, $p['path'], $p['domain'] ?? '', !empty($_SERVER['HTTPS']), true);
    }
    session_destroy();
  }

  echo json_encode(['ok'=>true,'self'=>true,'redirect'=>'/auth/login.php']);
  exit;
}

// REMOTO → elimina la riga e metti un kill, così quel device verrà sloggato al prossimo hit
try {
  $pdo->prepare("DELETE FROM user_devices WHERE user_id=? AND device_key=?")->execute([$uid, $dk]);
} catch(Throwable $e){}
enqueue_kill($pdo, $uid, $dk);

// (facoltativo) prova anche a killare sessioni note se usi una tabella user_sessions
try {
  $pdo->exec("DELETE FROM user_sessions WHERE user_id=".$uid." AND user_agent=". $pdo->quote((string)$dev['user_agent']));
} catch(Throwable $e){}

echo json_encode(['ok'=>true,'self'=>false]);