<?php
// /client/api_user_devices.php — compat con schema senza device_name/revoked_at
require_once __DIR__.'/../partials/authguard.php';
if (!headers_sent()) {
  header('Content-Type: application/json; charset=UTF-8');
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
}

$uid = (int)($_SESSION['user']['id'] ?? 0);
if ($uid <= 0) { http_response_code(401); echo json_encode(['error'=>'unauthorized']); exit; }

// Assicura tabella base (quella che usi davvero)
try {
  $pdo->exec("CREATE TABLE IF NOT EXISTS user_devices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    device_key VARCHAR(128) NOT NULL,
    ip VARCHAR(45) NULL,
    user_agent VARCHAR(255) NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_seen DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_user_device (user_id, device_key),
    KEY idx_user (user_id)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
} catch (Throwable $e) {
  http_response_code(500); echo json_encode(['error'=>'db-init']); exit;
}

// Helpers
function col_exists(PDO $pdo, string $table, string $col): bool {
  try {
    $db = $pdo->query("SELECT DATABASE()")->fetchColumn();
    $q  = $pdo->prepare("SELECT COUNT(*) FROM information_schema.COLUMNS
                         WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND COLUMN_NAME=?");
    $q->execute([$db,$table,$col]);
    return (bool)$q->fetchColumn();
  } catch (Throwable $e) { return false; }
}
function ua_label(string $ua): string {
  $u = strtolower($ua);
  if (str_contains($u,'hbbtv') || str_contains($u,'smart-tv') || str_contains($u,'tizen') || str_contains($u,'web0s') || str_contains($u,'webos') || str_contains($u,'bravia')) return 'Smart TV';
  if (str_contains($u,'aft') || str_contains($u,'fire tv') || str_contains($u,'silk/')) return 'Fire TV';
  if (str_contains($u,'appletv') || str_contains($u,'tvos')) return 'Apple TV';
  if (str_contains($u,'android tv')) return 'Android TV';
  if (str_contains($u,'kodi') || str_contains($u,'xbmc')) return 'Kodi';
  if (str_contains($u,'iphone')) return 'iPhone';
  if (str_contains($u,'ipad')) return 'iPad';
  if (str_contains($u,'android')) return 'Android';
  if (str_contains($u,'windows nt')) return 'Windows';
  if (str_contains($u,'macintosh') || str_contains($u,'mac os x')) return 'macOS';
  if (str_contains($u,'cros')) return 'ChromeOS';
  if (str_contains($u,'linux')) return 'Linux';
  if (str_contains($u,'safari') && !str_contains($u,'chrome')) return 'Safari';
  if (str_contains($u,'edg/')) return 'Edge';
  if (str_contains($u,'chrome')) return 'Chrome';
  if (str_contains($u,'firefox')) return 'Firefox';
  return 'Dispositivo';
}

// Device corrente per marcare in UI
$curKey = $_COOKIE['dev_id'] ?? '';
if ($curKey === '' && session_status() === PHP_SESSION_ACTIVE) {
  $sid = session_id();
  if ($sid) $curKey = 'sess:'.$sid;
}

// Se ESISTONO nuove colonne le includo, altrimenti no
$hasDevName = col_exists($pdo,'user_devices','device_name');
$hasRevoked = col_exists($pdo,'user_devices','revoked_at');

$selectCols = "id, device_key, ip, user_agent, created_at, last_seen";
if ($hasDevName) $selectCols .= ", device_name";
if ($hasRevoked) $selectCols .= ", revoked_at";

$orderBy = $hasRevoked
  ? "(revoked_at IS NULL) DESC, last_seen DESC, id DESC"
  : "last_seen DESC, id DESC";

try {
  $sql = "SELECT $selectCols FROM user_devices WHERE user_id=? ORDER BY $orderBy";
  $st  = $pdo->prepare($sql);
  $st->execute([$uid]);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  $items = [];
  foreach ($rows as $r) {
    $ua   = (string)($r['user_agent'] ?? '');
    $name = $hasDevName && !empty($r['device_name']) ? (string)$r['device_name'] : ua_label($ua);
    $status = ($hasRevoked && !empty($r['revoked_at'])) ? 'revoked' : 'active';

    $items[] = [
      'id'          => (int)$r['id'],
      'device_key'  => (string)$r['device_key'],
      'device_name' => $name,
      'ip'          => (string)($r['ip'] ?? ''),
      'user_agent'  => $ua,
      'created_at'  => (string)$r['created_at'],
      'last_seen'   => (string)$r['last_seen'],
      'status'      => $status,
      'is_current'  => ($curKey && hash_equals($curKey, (string)$r['device_key'])),
    ];
  }

  echo json_encode(['items'=>$items], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_INVALID_UTF8_SUBSTITUTE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error'=>'db-read']);
}