<?php
// /client/api_user_payments.php
require_once __DIR__.'/../partials/authguard.php';
if (!headers_sent()) header('Content-Type: application/json; charset=UTF-8');

$uid = (int)($_SESSION['user']['id'] ?? 0);

try{
  $st = $pdo->prepare("
    SELECT id, created_at, amount, currency, method, status, period_from, period_to, note
    FROM payments
    WHERE user_id = ?
    ORDER BY created_at DESC, id DESC
  ");
  $st->execute([$uid]);
  $rows = $st->fetchAll() ?: [];

  $items = array_map(function($r){
    return [
      'id'         => (int)$r['id'],
      'created_at' => $r['created_at'],
      'amount'     => (float)$r['amount'],
      'currency'   => $r['currency'],
      'method'     => $r['method'],
      'status'     => $r['status'],
      'period_from'=> $r['period_from'],
      'period_to'  => $r['period_to'],
      'note'       => $r['note'],
    ];
  }, $rows);

  echo json_encode(['items'=>$items], JSON_UNESCAPED_UNICODE);
} catch(Throwable $e){
  echo json_encode(['items'=>[]]);
}
