<?php
require_once __DIR__.'/../config.php';
require_admin(); // solo admin

header('Content-Type: text/plain; charset=utf-8');

if (empty($API_FOOTBALL_KEY)) {
  echo "API key mancante in config.php\n";
  exit;
}

$url = "https://{$API_FOOTBALL_HOST}/v3/fixtures?live=all&timezone=Europe/Rome";
$ch = curl_init($url);
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_HEADER => true,
  CURLOPT_TIMEOUT => 20,
  CURLOPT_HTTPHEADER => [
    'Accept: application/json',
    'User-Agent: supersport.xo.je/1.0',
    'X-RapidAPI-Key: ' . $API_FOOTBALL_KEY,
    'X-RapidAPI-Host: ' . $API_FOOTBALL_HOST,
  ],
]);

$res = curl_exec($ch);
if ($res === false) { echo "cURL error: ".curl_error($ch)."\n"; exit; }
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$hdrSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$headers = substr($res, 0, $hdrSize);
$body = substr($res, $hdrSize);
curl_close($ch);

echo "URL: $url\nHTTP: $code\n\n--- HEADERS ---\n$headers\n--- BODY (first 1000) ---\n";
echo substr($body, 0, 1000), "\n";
