<?php
// /client/category.php
$page_title = 'Categoria';
require_once __DIR__.'/../partials/authguard.php';
require_once __DIR__.'/../partials/header.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
@date_default_timezone_set('Europe/Rome');

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

/* --- Carica categoria per slug --- */
$slug = isset($_GET['slug']) ? (string)$_GET['slug'] : '';
// fallback se mai passasse via PATH_INFO
if ($slug === '' && !empty($_SERVER['PATH_INFO'])) {
  $slug = trim($_SERVER['PATH_INFO'], '/');
}

$st = $pdo->prepare("SELECT * FROM categories WHERE slug=? LIMIT 1");
$st->execute([$slug]);
$cat = $st->fetch();

if(!$cat){
  http_response_code(404);
  echo '<div class="container my-4"><div class="alert alert-danger">Categoria non trovata.</div></div>';
  require_once __DIR__.'/../partials/footer.php'; exit;
}

/* === Live attive per questa categoria, con fallback alla live collegata === */
$st = $pdo->prepare("
  SELECT
    l.*,
    COALESCE(NULLIF(TRIM(l.m3u8_url),''), NULLIF(TRIM(l2.m3u8_url),''))      AS eff_m3u8_url,
    COALESCE(NULLIF(TRIM(l.image_path),''), NULLIF(TRIM(l2.image_path),''))  AS eff_image_path
  FROM lives l
  LEFT JOIN lives l2 ON l.linked_live_id = l2.id
  WHERE l.category_id=? AND l.is_active=1
  ORDER BY
    l.always_live DESC,
    CASE WHEN l.event_at IS NULL THEN 1 ELSE 0 END,
    l.event_at ASC,
    l.sort_order ASC,
    l.id DESC
");
$st->execute([(int)$cat['id']]);
$lives = $st->fetchAll();

/* === Data/ora ITA === */
$DOW = ['Domenica','Lunedì','Martedì','Mercoledì','Giovedì','Venerdì','Sabato'];
$MON = [1=>'Gennaio','Febbraio','Marzo','Aprile','Maggio','Giugno','Luglio','Agosto','Settembre','Ottobre','Novembre','Dicembre'];
function fmt_it_datetime(?string $mysql): string {
  if(!$mysql) return '';
  $ts = strtotime($mysql); if(!$ts) return '';
  global $DOW, $MON;
  $dow = $DOW[(int)date('w',$ts)];
  $d   = date('d',$ts);
  $m   = $MON[(int)date('n',$ts)];
  $hm  = date('H:i',$ts);
  return "$dow $d $m • Ore $hm";
}

/* === Preconnect/preload m3u8 EFFETTIVI === */
$hosts = []; $prefetchUrls = [];
foreach ($lives as $l) {
  $u = trim($l['eff_m3u8_url'] ?? '');
  if ($u==='') continue;
  $prefetchUrls[] = $u;
  if (preg_match('~^(https?:)//([^/]+)~i', $u, $m)) $hosts[] = $m[1].'//'.$m[2];
}
$hosts = array_values(array_unique($hosts));
$prefetchUrls = array_values(array_unique($prefetchUrls));
?>
<style>
  :root{
    --radius: 22px;
    --overlay-grad: linear-gradient(180deg, rgba(0,0,0,0) 40%, rgba(0,0,0,.70) 100%);
    --chip-bg: rgba(15,18,22,.75);
    --chip-brd: rgba(255,255,255,.28);
    --prog-height: 4px;
    --prog-track: rgba(255,255,255,.10);
    --prog-c1: #0b1b3a;
    --prog-c2: #1d3f72;
  }

  .cat-head{ margin-top:.25rem; margin-bottom:.75rem; }
  .back-btn i{ vertical-align:-1px; }

  .section-title{
    display:flex; align-items:center; gap:.6rem;
    font-weight:800; letter-spacing:.3px; color:#fff;
    margin:0;
  }

  .ev-card{
    position:relative; border-radius: var(--radius);
    background:#0f1216; border:1px solid rgba(255,255,255,.14);
    box-shadow: 0 10px 30px rgba(0,0,0,.35);
    overflow:hidden; transition: box-shadow .25s ease, transform .2s ease;
    height:100%;
  }
  .ev-card:hover{ box-shadow: 0 14px 38px rgba(0,0,0,.45); transform: translateY(-2px); }

  .ev-media{ position:relative; aspect-ratio: 16/9; background:#0a0d11; }

  .ev-media img.thumb{
    width:100%; height:100%; object-fit: contain; display:block; background:#0a0d11;
    transition: opacity .25s ease, transform .25s ease;
  }
  .ev-video{
    position:absolute; inset:0; z-index:2; width:100%; height:100%;
    object-fit: contain; background:#000; opacity:0; transition: opacity .25s ease;
    pointer-events:none;
  }
  .ev-card.playing .ev-video{ opacity:1; }
  .ev-card.playing .ev-media img.thumb{ opacity:0; transform:scale(1.01); }

  .ev-overlay{ position:absolute; inset:0; background: var(--overlay-grad); pointer-events:none; }

  .ev-progress{
    position:absolute; left:0; top:0; width:100%; height:var(--prog-height);
    z-index:6; background:var(--prog-track);
    opacity:0; transform: translateY(-4px);
    transition: opacity .16s ease, transform .16s ease;
  }
  .ev-card.loading .ev-progress{ opacity:1; transform: translateY(0); }
  .ev-progress .bar{
    position:absolute; left:0; top:0; height:100%; width:0%;
    background: linear-gradient(90deg, var(--prog-c1), var(--prog-c2));
    box-shadow: 0 0 8px rgba(29,63,114,.35);
    border-top-left-radius:12px; border-top-right-radius:12px;
    animation: evProgress 1.6s linear infinite;
  }
  @keyframes evProgress { from{width:0%} to{width:100%} }

  .when-chip{
    position:absolute; left:12px; top:12px; z-index:3;
    display:inline-flex; align-items:center; max-width:70%;
    padding:.45rem .75rem; border-radius:14px;
    background:var(--chip-bg); border:1px solid var(--chip-brd);
    color:#fff; font-weight:800; letter-spacing:.2px; box-shadow:0 6px 18px rgba(0,0,0,.35);
    transition: opacity .2s ease;
  }
  .live-badge{
    position:absolute; right:12px; top:12px; z-index:3;
    background:#c52222; color:#fff; font-weight:900;
    border-radius:999px; padding:.35rem .9rem; border:1px solid rgba(255,255,255,.18);
    box-shadow:0 6px 18px rgba(0,0,0,.35); transition: opacity .2s ease;
  }
  .ev-card.playing .when-chip, .ev-card.playing .live-badge{ opacity:.25; }

  .ev-bottom{ position:absolute; left:0; right:0; bottom:0; z-index:3; padding:10px 12px 12px 12px; color:#e6ecf7; }
  .ev-title{
    margin:0 0 .35rem 0; font-weight:900; font-size:1.06rem; color:#fff;
    text-shadow:0 2px 6px rgba(0,0,0,.45); transform-origin:left bottom;
    transition: transform .18s ease, letter-spacing .18s ease, text-shadow .18s ease;
  }
  .ev-card:hover .ev-title, .ev-card.playing .ev-title{
    transform: translateY(-1px) scale(1.05); letter-spacing:.2px; text-shadow:0 4px 10px rgba(0,0,0,.55);
  }

  .cta-pill{
    display:inline-flex; align-items:center; gap:.45rem; padding:.32rem .7rem; border-radius:12px;
    font-weight:800; font-size:.88rem; letter-spacing:.2px; color:#0b1118; background:#fff; border:1px solid rgba(255,255,255,.25);
    box-shadow:0 6px 16px rgba(0,0,0,.28); opacity:0; transform: translateY(6px) scale(.98);
    transition: opacity .18s ease, transform .18s ease;
  }
  .cta-pill i{ font-size:.95rem; }
  .ev-card:hover .cta-pill, .ev-card.playing .cta-pill{ opacity:1; transform: translateY(0) scale(1); }

  .ev-desc{ margin:.35rem 0 0 0; color:#d1d7e3; opacity:.95; font-size:.95rem; }
  .always-chip{ display:inline-inline; padding:.22rem .55rem; border-radius:999px; background:rgba(34,197,94,.15); color:#d4ffe4; font-weight:700; font-size:.9rem; border:1px solid rgba(34,197,94,.35); }

  .ev-grid .col{ display:flex; }
</style>

<script>
/* Preconnect/preload nel <head> */
(function(){
  const hosts = <?= json_encode($hosts, JSON_UNESCAPED_SLASHES) ?>;
  const urls  = <?= json_encode($prefetchUrls, JSON_UNESCAPED_SLASHES) ?>;
  const head = document.head || document.getElementsByTagName('head')[0];
  hosts.forEach(h => {
    try{
      const l=document.createElement('link'); l.rel='preconnect'; l.href=h; l.crossOrigin='anonymous'; head.appendChild(l);
      const d=document.createElement('link'); d.rel='dns-prefetch'; d.href=h; head.appendChild(d);
    }catch(e){}
  });
  urls.slice(0,8).forEach(u => {
    try{
      const l=document.createElement('link'); l.rel='preload'; l.as='fetch'; l.href=u; l.crossOrigin='anonymous'; head.appendChild(l);
    }catch(e){}
  });
})();
</script>

<div class="d-flex align-items-center justify-content-between cat-head">
  <h4 class="section-title"><?= h($cat['name'] ?? 'Categoria') ?></h4>
  <!-- back con pretty URL -->
  <a href="/dashboard" class="btn btn-outline-secondary btn-sm back-btn">
    <i class="bi bi-arrow-left"></i> Torna alla Dashboard
  </a>
</div>

<div class="row row-cols-1 row-cols-md-2 row-cols-xl-3 g-3 ev-grid">
<?php foreach($lives as $l):
  $href   = '/live/'.rawurlencode($l['slug']); // pretty URL verso la live
  $when   = (!empty($l['event_at']) && empty($l['always_live'])) ? fmt_it_datetime($l['event_at']) : '';
  $desc   = trim($l['description'] ?? '');
  $always = !empty($l['always_live']);
  $thumb  = trim($l['eff_image_path'] ?? '');
  $m3u8   = trim($l['eff_m3u8_url'] ?? '');
  $hasVideo = $m3u8 !== '';
?>
  <div class="col">
    <a class="text-decoration-none w-100" href="<?= h($href) ?>">
      <div class="ev-card w-100<?= $hasVideo?' has-video':'' ?>" <?= $hasVideo?('data-m3u8="'.h($m3u8).'"'):'' ?>>
        <div class="ev-media">
          <?php if($thumb): ?><img class="thumb" src="<?= h($thumb) ?>" alt=""><?php endif; ?>
          <?php if($hasVideo): ?><video class="ev-video" muted playsinline preload="none"></video><?php endif; ?>

          <div class="ev-progress"><span class="bar"></span></div>

          <?php if($when): ?><div class="when-chip"><?= h($when) ?></div><?php endif; ?>
          <div class="live-badge">LIVE</div>
          <div class="ev-overlay"></div>

          <div class="ev-bottom">
            <h6 class="ev-title"><?= h($l['title'] ?? '') ?></h6>
            <span class="cta-pill"><i class="bi bi-play-circle-fill"></i> Guarda ora</span>
            <?php if($always): ?>
              <p class="ev-desc"><span class="always-chip">Sempre live</span></p>
            <?php elseif($desc!==''): ?>
              <p class="ev-desc"><?= h(mb_strimwidth($desc,0,90,'…')) ?></p>
            <?php else: ?>
              <p class="ev-desc" style="opacity:.7"> </p>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </a>
  </div>
<?php endforeach; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/hls.js@1.5.7/dist/hls.min.js" defer></script>
<script>
document.addEventListener('DOMContentLoaded', function(){
  const cards = document.querySelectorAll('.ev-card[data-m3u8]');
  let active = null;

  function clearState(card){
    if(!card) return;
    card.classList.remove('playing');
    card.classList.remove('loading');
  }
  function stopCard(card){
    if(!card) return;
    const v = card.querySelector('video.ev-video');
    if (v){ try{ v.pause(); }catch(e){} }
    const hls = card._hls;
    if (hls){ try{ hls.stopLoad(); }catch(e){} }
    clearState(card);
  }

  cards.forEach(card => {
    const url = card.getAttribute('data-m3u8');
    const video = card.querySelector('video.ev-video');
    if (!url || !video) return;

    let hls = null, started = false, stopTimer = null;

    function startPreview(){
      clearTimeout(stopTimer);
      if (active && active !== card) stopCard(active);
      active = card;

      card.classList.add('loading');

      if (started){
        video.muted = true;
        video.play().catch(()=>{});
        return;
      }
      started = true;

      const cfg = {
        lowLatencyMode:true, backBufferLength:0, liveSyncDuration:3,
        maxBufferLength:6, capLevelToPlayerSize:true, maxInitialBitrate:300000,
        startLevel:0, fragLoadingTimeOut:8000, manifestLoadingTimeOut:8000
      };

      if (video.canPlayType('application/vnd.apple.mpegurl')) {
        video.src = url; video.muted = true; video.play().catch(()=>{});
      } else if (window.Hls && Hls.isSupported()){
        hls = new Hls(cfg); card._hls = hls;
        hls.loadSource(url); hls.attachMedia(video);
        hls.on(Hls.Events.MANIFEST_PARSED, () => {
          try { hls.currentLevel = 0; }catch(e){}
          video.muted = true; video.play().catch(()=>{});
        });
      }
    }

    function stopPreview(){
      stopTimer = setTimeout(() => {
        if (active === card) active = null;
        stopCard(card);
      }, 300);
    }

    video.addEventListener('waiting', () => card.classList.add('loading'));
    video.addEventListener('stalled', () => card.classList.add('loading'));
    video.addEventListener('seeking', () => card.classList.add('loading'));
    video.addEventListener('canplay', () => card.classList.remove('loading'));
    video.addEventListener('playing', () => { card.classList.add('playing'); card.classList.remove('loading'); });
    video.addEventListener('pause',   () => card.classList.remove('playing'));
    video.addEventListener('ended',   () => clearState(card));
    video.addEventListener('error',   () => clearState(card));

    card.addEventListener('mouseenter', startPreview);
    card.addEventListener('mouseleave', stopPreview);

    const io = new IntersectionObserver(entries => {
      entries.forEach(e => { if (!e.isIntersecting) stopPreview(); });
    }, {threshold: 0});
    io.observe(card);

    const nearIo = new IntersectionObserver(entries => {
      entries.forEach(e => {
        if (e.isIntersecting) {
          nearIo.unobserve(card);
          try { fetch(url, {mode:'cors', credentials:'omit'}).catch(()=>{}); }catch(err){}
        }
      });
    }, {rootMargin: '300px'});
    nearIo.observe(card);
  });

  document.addEventListener('click', e => {
    const a = e.target.closest('a[href]');
    if (a) { if (active) stopCard(active); active = null; }
  });
});
</script>

<?php require_once __DIR__.'/../partials/footer.php'; ?>