<?php
// /client/dashboard.php
$page_title='Dashboard';
require_once __DIR__.'/../partials/authguard.php';
require_once __DIR__.'/../partials/header.php';

if (!headers_sent()) {
  header('Content-Type: text/html; charset=UTF-8');
}
@date_default_timezone_set('Europe/Rome');

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

/* ---------- AUTO-DISATTIVAZIONE LIVE PASSATE (alle 00:30) ---------- */
try {
  $now = new DateTime('now');
  $cut = new DateTime($now->format('Y-m-d').' 00:30:00'); // oggi alle 00:30
  $pdo->prepare("
    UPDATE lives
    SET is_active = 0
    WHERE is_active = 1
      AND (always_live IS NULL OR always_live = 0)
      AND event_at IS NOT NULL
      AND event_at < ?
  ")->execute([$cut->format('Y-m-d H:i:s')]);
} catch (Throwable $e) {
  // non bloccare la pagina
}

/* ---------- BADGE DA SETTINGS ---------- */
$st1 = $pdo->prepare("SELECT value FROM settings WHERE `key`='client_badge_enabled'");
$st1->execute(); $enRow = $st1->fetch();
$badge_enabled = $enRow && $enRow['value'] === '1';

$st2 = $pdo->prepare("SELECT value FROM settings WHERE `key`='client_badge_html'");
$st2->execute(); $htmlRow = $st2->fetch();
$badge_html = $htmlRow ? $htmlRow['value'] : '';

/* ---------- Categorie (SOLO visibili) ---------- */
$cols = is_mobile() ? 2 : 4;
$cats = $pdo->query("
  SELECT *
  FROM categories
  WHERE COALESCE(is_hidden,0)=0
  ORDER BY sort_order ASC, name ASC
")->fetchAll();

/* ---------- Eventi in programma (anche se la categoria è nascosta) ---------- */
$evtCols = is_mobile() ? 1 : 3;
$upcomingAll = $pdo->query("
  SELECT l.*,
         c.slug AS cat_slug, c.name AS cat_name,
         l2.m3u8_url  AS linked_m3u8_url,
         l2.image_path AS linked_image_path
  FROM lives l
  JOIN categories c ON c.id = l.category_id
  LEFT JOIN lives l2 ON l.linked_live_id = l2.id
  WHERE l.is_active = 1
    AND (l.always_live IS NULL OR l.always_live = 0)
    AND l.event_at IS NOT NULL
  ORDER BY l.event_at ASC, l.sort_order, l.id DESC
")->fetchAll();

/* ---------- Stato abbonamento utente ---------- */
$uid = (int)($_SESSION['user']['id'] ?? 0);
$user_email = $_SESSION['user']['email'] ?? '';
$sub_until = null;

if ($uid) {
  $st = $pdo->prepare("SELECT email, subscription_until FROM users WHERE id=?");
  $st->execute([$uid]);
  if ($row = $st->fetch()) {
    $user_email = $row['email'] ?: $user_email;
    $sub_until  = $row['subscription_until'] ?? null;
  }
}
function is_zero_dt($s){ return !$s || $s==='0000-00-00 00:00:00' || $s==='0000-00-00'; }

$status = 'free';  // free | vip | expired
$badge_title = 'No VIP';
$badge_desc  = 'Nessun abbonamento attivo';
if ($sub_until && !is_zero_dt($sub_until)) {
  try{
    $dt  = new DateTime($sub_until);
    $now = new DateTime();
    if ($dt > $now) { $status='vip'; $badge_title='VIP'; $badge_desc='Scade il '.$dt->format('d/m/Y H:i'); }
    else            { $status='expired'; $badge_title='Scaduto'; $badge_desc='Scaduto il '.$dt->format('d/m/Y H:i'); }
  }catch(Throwable $e){}
}

/* ---------- Formattazione data in ITA ---------- */
$DOW = ['Domenica','Lunedì','Martedì','Mercoledì','Giovedì','Venerdì','Sabato'];
$MON = [1=>'Gennaio','Febbraio','Marzo','Aprile','Maggio','Giugno','Luglio','Agosto','Settembre','Ottobre','Novembre','Dicembre'];
function fmt_it_datetime(?string $mysql): string {
  if(!$mysql) return '';
  $ts = strtotime($mysql); if(!$ts) return '';
  global $DOW, $MON;
  $dow = $DOW[(int)date('w',$ts)];
  $d   = date('d',$ts);
  $m   = $MON[(int)date('n',$ts)];
  $hm  = date('H:i',$ts);
  return "$dow $d $m • Ore $hm";
}

/* ---------- Preconnect/Preload HLS (su tutti gli eventi) ---------- */
$hosts = [];
$prefetchUrls = [];
foreach ($upcomingAll as $ev) {
  $u = trim($ev['m3u8_url'] ?? '');
  if ($u === '') $u = trim($ev['linked_m3u8_url'] ?? ''); // fallback
  if ($u === '') continue;
  $prefetchUrls[] = $u;
  if (preg_match('~^(https?:)//([^/]+)~i', $u, $m)) {
    $hosts[] = $m[1].'//'.$m[2];
  }
}
$hosts = array_values(array_unique($hosts));
$prefetchUrls = array_values(array_unique($prefetchUrls));
?>
<style>
  :root{
    --glass-bg: rgba(255,255,255,0.14);
    --glass-brd: rgba(255,255,255,0.28);
    --shadow: 0 10px 30px rgba(0,0,0,.35);
    --radius: 18px;
    --radius-lg: 22px;
    --overlay-grad: linear-gradient(180deg, rgba(0,0,0,0) 40%, rgba(0,0,0,.70) 100%);
    --chip-bg: rgba(15,18,22,.75);
    --chip-brd: rgba(255,255,255,.28);
    /* Progress bar blu */
    --prog-height: 4px;
    --prog-track: rgba(255,255,255,.10);
    --prog-c1: #0b1b3a;
    --prog-c2: #1d3f72;
  }
  @media (prefers-color-scheme: dark){
    :root{ --glass-bg: rgba(17,17,17,0.28); --glass-brd: rgba(255,255,255,0.14); }
  }
  .section-title{display:flex;align-items:center;gap:.6rem;font-weight:700;letter-spacing:.3px;margin-bottom:.75rem;color:#fff;}
  @supports (-webkit-background-clip: text) or (background-clip: text){
    .section-title{background:linear-gradient(90deg,#ffffff,#cfe0ff);-webkit-background-clip:text;background-clip:text;-webkit-text-fill-color:transparent;color:transparent;}
  }
  .section-sub{margin-top:-.25rem;margin-bottom:1rem;color:#9aa3b2;font-size:.95rem;}
  .user-header{margin-bottom:1rem;}
  .hello{margin:0 0 .35rem 0;font-weight:800;letter-spacing:.2px;color:var(--topbar-link,#222);}
  html[data-theme="dark"] .hello{color:var(--topbar-link,#fff);}
  .membership{display:flex;align-items:center;gap:.9rem;padding:12px 14px;border-radius:16px;border:1px solid var(--glass-brd);background:var(--glass-bg);box-shadow:var(--shadow);backdrop-filter:blur(10px);-webkit-backdrop-filter:blur(10px);}
  .m-icon{display:inline-flex;align-items:center;justify-content:center;width:42px;height:42px;border-radius:12px;font-size:1.2rem;border:1px solid rgba(255,255,255,.25);}
  .m-body{line-height:1.2;}
  .m-title{font-weight:800;letter-spacing:.3px;}
  .m-sub{font-size:.92rem;opacity:.9;}
  .membership.vip{border-color:rgba(255,215,0,.35);background:linear-gradient(135deg,rgba(255,215,0,.18),rgba(255,255,255,.06));}
  .membership.vip .m-icon{background:rgba(255,215,0,.28);}
  .membership.vip .m-title{color:#c9a306;} html[data-theme="dark"] .membership.vip .m-title{color:#ffd200;}
  .membership.expired{border-color:rgba(220,53,69,.35);background:linear-gradient(135deg,rgba(220,53,69,.16),rgba(255,255,255,.06));}
  .membership.expired .m-icon{background:rgba(220,53,69,.28);}
  .membership.expired .m-title{color:#b02a37;} html[data-theme="dark"] .membership.expired .m-title{color:#ff6b7d;}
  .membership.free{border-color:rgba(108,117,125,.28);background:linear-gradient(135deg,rgba(108,117,125,.16),rgba(255,255,255,.06));}
  .membership.free .m-title{color:#6c757d;} html[data-theme="dark"] .membership.free .m-title{color:#cbd3e1;}

  /* Categorie */
  .cat-card{position:relative;overflow:hidden;border-radius:var(--radius);height:100%;background:var(--glass-bg);border:1px solid var(--glass-brd);box-shadow:var(--shadow);transition:transform .25s ease,box-shadow .25s ease;}
  .cat-card:hover{transform:translateY(-4px);box-shadow:0 14px 36px rgba(0,0,0,.45);}
  .cat-bg{width:100%;height:170px;object-fit:cover;display:block;filter:saturate(1.05) contrast(1.02);transition:transform .35s ease, filter .35s ease;}
  .cat-card:hover .cat-bg{transform:scale(1.06);filter:saturate(1.15) contrast(1.06);}
  .cat-overlay{position:absolute;inset:0;background:linear-gradient(180deg,rgba(0,0,0,0) 40%,rgba(0,0,0,.55) 100%);}
  .cat-title{position:absolute;left:12px;bottom:10px;right:12px;color:#fff;font-weight:700;font-size:1.02rem;text-shadow:0 2px 6px rgba(0,0,0,.5);display:flex;align-items:center;gap:.5rem;}
  .cat-body{padding:10px 12px 12px 12px;color:#cfd6e4;font-size:.9rem;}
  .cat-placeholder{height:170px;display:flex;align-items:center;justify-content:center;background:radial-gradient(1200px 300px at 50% 0%,rgba(255,255,255,.08),rgba(0,0,0,.35));}

  /* Barra date filtrabili */
  .date-chips{display:flex;flex-wrap:wrap;gap:.5rem;margin:-.25rem 0 1rem 0; justify-content:center;}
  .chip{
    display:inline-flex;align-items:center;gap:.45rem;padding:.35rem .7rem;border-radius:999px;
    border:1px solid rgba(255,255,255,.25); background:rgba(255,255,255,.12); color:#fff; text-decoration:none;
    font-weight:800;font-size:.9rem; letter-spacing:.2px; box-shadow:0 4px 14px rgba(0,0,0,.25);
    transition:transform .12s ease, box-shadow .12s ease, background .12s ease, color .12s ease;
  }
  .chip:hover{ transform:translateY(-1px); box-shadow:0 8px 20px rgba(0,0,0,.35); }
  .chip .cnt{font-weight:700;opacity:.95;padding:.1rem .45rem;border-radius:999px;border:1px solid rgba(255,255,255,.25);background:rgba(0,0,0,.18);font-size:.82rem;}
  .chip.active{ background:#ffffff; color:#0b1118; border-color:transparent; }
  .chip.active .cnt{ border-color:rgba(0,0,0,.18); background:rgba(0,0,0,.06); }
  .chip[data-day]{ cursor:pointer; user-select:none; }

  html:not([data-theme="dark"]) .chip{ color:#0f172a; background:#eef2ff; border-color:#c7d2fe; }
  html:not([data-theme="dark"]) .chip .cnt{ background:#e2e8f0; border-color:#cbd5e1; }
  html:not([data-theme="dark"]) .chip.active{ background:#0f172a; color:#fff; }

  /* Eventi (card + progress bar) */
  .ev-card{ position:relative;border-radius:var(--radius);background:#0f1216;border:1px solid var(--glass-brd);box-shadow:var(--shadow);overflow:hidden;transition:box-shadow .25s ease, transform .2s ease; }
  .ev-card:hover{ box-shadow: 0 14px 38px rgba(0,0,0,.45); transform: translateY(-2px); }
  .ev-media{ position:relative; aspect-ratio: 16/9; background:#0a0d11; }
  .ev-media img.thumb{ width:100%; height:100%; object-fit: contain; background:#0a0d11; display:block; transition: opacity .25s ease, transform .25s ease; }
  .ev-video{ position:absolute; inset:0; z-index:2; width:100%; height:100%; object-fit: contain; background:#000; opacity:0; transition: opacity .25s ease; pointer-events:none; }
  .ev-card.playing .ev-video{ opacity:1; }
  .ev-card.playing .ev-media img.thumb{ opacity:0; transform: scale(1.01); }
  .ev-overlay{ position:absolute; inset:0; background: var(--overlay-grad); pointer-events:none; }

  .ev-progress{ position:absolute; left:0; top:0; width:100%; height:var(--prog-height); z-index:7; background:var(--prog-track); opacity:0; transform: translateY(-4px); transition: opacity .16s ease, transform .16s ease; }
  .ev-card.loading .ev-progress{ opacity:1; transform: translateY(0); }
  .ev-progress .bar{ position:absolute; left:0; top:0; height:100%; width:0%; background: linear-gradient(90deg, var(--prog-c1), var(--prog-c2)); box-shadow: 0 0 8px rgba(29,63,114,.35); border-top-left-radius:12px; border-top-right-radius:12px; animation: evDashProgress 1.6s linear infinite; }
  @keyframes evDashProgress { from{width:0%} to{width:100%} }

  .when-chip{ position:absolute; left:12px; top:12px; z-index:5; display:inline-flex; align-items:center; max-width:70%; padding:.45rem .75rem; border-radius:14px; background: var(--chip-bg); border:1px solid var(--chip-brd); color:#fff; font-weight:800; letter-spacing:.2px; box-shadow: 0 6px 18px rgba(0,0,0,.35); }
  .live-badge{ position:absolute; right:12px; top:12px; z-index:6; background:#c52222; color:#fff; font-weight:900; border-radius:999px; padding:.35rem .9rem; border:1px solid rgba(255,255,255,.18); box-shadow:0 6px 18px rgba(0,0,0,.35); }
  .ev-card.playing .when-chip, .ev-card.playing .live-badge{ opacity:.25; }

  .ev-bottom{ position:absolute; left:0; right:0; bottom:0; z-index:4; padding:10px 12px 12px 12px; color:#e6ecf7; }
  .ev-title{ margin:0 0 .35rem 0; font-weight:900; font-size:1.05rem; color:#fff; text-shadow:0 2px 6px rgba(0,0,0,.45); transform-origin:left bottom; transition: transform .18s ease, letter-spacing .18s ease, text-shadow .18s ease; }
  .ev-card:hover .ev-title, .ev-card.playing .ev-title{ transform: translateY(-1px) scale(1.05); letter-spacing:.2px; text-shadow: 0 4px 10px rgba(0,0,0,.55); }
  .cta-pill{ display:inline-flex; align-items:center; gap:.45rem; padding:.32rem .7rem; border-radius:12px; font-weight:800; font-size:.88rem; letter-spacing:.2px; color:#0b1118; background:#ffffff; border:1px solid rgba(255,255,255,.25); box-shadow: 0 6px 16px rgba(0,0,0,.28); opacity:0; transform: translateY(6px) scale(.98); transition: opacity .18s ease, transform .18s ease; }
  .cta-pill i{ font-size:.95rem; }
  .ev-card:hover .cta-pill, .ev-card.playing .cta-pill{ opacity:1; transform: translateY(0) scale(1); }

  .ev-desc { margin:0; color:#d1d7e3; opacity:.95; font-size:.95rem; }

  /* Centratura titolo “Prossimi eventi in programma” */
  #upcoming.section-title{ text-align:center; justify-content:center; }

  /* Animazione filtro items */
  .ev-item{ transition: opacity .22s ease, transform .22s ease; }
  .ev-item.filter-hide{ opacity:0; transform: translateY(6px) scale(.98); pointer-events:none; }
  .ev-item.filter-hidden{ display:none !important; }

  html:not([data-theme="dark"]) .section-title{ background:none!important; -webkit-text-fill-color:initial!important; color:#0f172a!important; text-shadow:none!important; }
  html:not([data-theme="dark"]) .section-sub{ color:#475569!important; }
</style>

<!-- Preconnect/Preload per i domini/manifest HLS -->
<script>
(function(){
  const hosts = <?= json_encode($hosts, JSON_UNESCAPED_SLASHES) ?>;
  const urls  = <?= json_encode($prefetchUrls, JSON_UNESCAPED_SLASHES) ?>;
  const head = document.head || document.getElementsByTagName('head')[0];

  hosts.forEach(h => {
    try{
      const l = document.createElement('link');
      l.rel = 'preconnect'; l.href = h; l.crossOrigin = 'anonymous';
      head.appendChild(l);
      const d = document.createElement('link'); d.rel='dns-prefetch'; d.href=h; head.appendChild(d);
    }catch(e){}
  });

  urls.slice(0,8).forEach(u => {
    try{
      const l = document.createElement('link');
      l.rel='preload'; l.as='fetch'; l.href=u; l.crossOrigin='anonymous';
      head.appendChild(l);
    }catch(e){}
  });
})();
</script>

<div class="user-header">
  <h3 class="hello">Ciao, <span class="usr"><?= htmlspecialchars($user_email) ?></span></h3>
  <div class="membership <?= htmlspecialchars($status) ?>">
    <div class="m-icon" aria-hidden="true">
      <?php if($status==='vip'): ?>&#x1F451;<?php elseif($status==='expired'): ?>&#x26A0;<?php else: ?>&#x1F464;<?php endif; ?>
    </div>
    <div class="m-body">
      <div class="m-title"><?php if($status==='vip') echo 'VIP'; elseif($status==='expired') echo 'Scaduto'; else echo 'No VIP'; ?></div>
      <div class="m-sub"><?php if($status==='vip'||$status==='expired') echo htmlspecialchars($badge_desc,ENT_QUOTES); else echo 'Nessun abbonamento attivo'; ?></div>
    </div>
  </div>
</div>

<?php if($badge_enabled && $badge_html): ?>
  <div class="se-badge mb-4 mt-3">
    <div class="se-badge-inner d-flex align-items-center">
      <span class="me-2" aria-hidden="true">&#128274;</span>
      <span><?= $badge_html /* HTML deciso dall'admin */ ?></span>
    </div>
  </div>
<?php endif; ?>

<h4 class="section-title mt-4">Categorie</h4>
<p class="section-sub">Scegli una categoria per iniziare a guardare i contenuti disponibili.</p>

<div class="row row-cols-<?= $cols ?> g-3 mb-5">
<?php foreach($cats as $c): ?>
  <div class="col">
    <a class="text-decoration-none" href="/categoria/<?= urlencode($c['slug']) ?>">
      <div class="cat-card h-100">
        <?php if($c['image_path']): ?>
          <img class="cat-bg" src="<?= htmlspecialchars($c['image_path']) ?>" alt="">
        <?php else: ?>
          <div class="cat-placeholder text-muted">Nessuna immagine</div>
        <?php endif; ?>
        <div class="cat-overlay"></div>
        <div class="cat-title"><span><?= htmlspecialchars($c['name']) ?></span></div>
        <div class="cat-body"></div>
      </div>
    </a>
  </div>
<?php endforeach; ?>
</div>

<?php if (!empty($upcomingAll)): ?>
  <h4 id="upcoming" class="section-title mt-2">Prossimi eventi in programma</h4>

  <?php
    // Giorni unici + conteggi
    $eventDays = [];
    foreach ($upcomingAll as $ev) {
      $d = date('Y-m-d', strtotime($ev['event_at']));
      $eventDays[$d] = ($eventDays[$d] ?? 0) + 1;
    }
    ksort($eventDays);

    function chip_label_it_short(string $ymd): string {
      $ts = strtotime($ymd);
      if (!$ts) return $ymd;
      $today  = strtotime(date('Y-m-d'));
      $tomorr = strtotime('+1 day', $today);
      if ($ts === $today)  return 'Oggi';
      if ($ts === $tomorr) return 'Domani';
      $dow = ['Dom','Lun','Mar','Mer','Gio','Ven','Sab'][(int)date('w', $ts)];
      return $dow.' '.date('d/m', $ts);
    }
  ?>

  <!-- Barra date filtrabili (solo bottone, no link) -->
  <div class="date-chips" id="dateChips">
    <span class="chip active" data-day="">Tutti <span class="cnt"><?= array_sum($eventDays) ?></span></span>
    <?php foreach($eventDays as $ymd => $cnt): ?>
      <span class="chip" data-day="<?= h($ymd) ?>"><?= h(chip_label_it_short($ymd)) ?> <span class="cnt"><?= (int)$cnt ?></span></span>
    <?php endforeach; ?>
  </div>

  <!-- Griglia eventi: tutti, filtrati via JS -->
  <div id="evGrid" class="row row-cols-<?= $evtCols ?> g-3 mb-4">
  <?php foreach($upcomingAll as $ev):
        $href = '/live/'.urlencode($ev['slug']);
        $when = fmt_it_datetime($ev['event_at']);
        $desc = trim($ev['description'] ?? '');

        $thumb = trim($ev['image_path'] ?? '');
        if ($thumb === '') $thumb = trim($ev['linked_image_path'] ?? '');

        $m3u8  = trim($ev['m3u8_url'] ?? '');
        if ($m3u8 === '')  $m3u8 = trim($ev['linked_m3u8_url'] ?? '');

        $hasVideo = $m3u8 !== '';
        $dayKey = date('Y-m-d', strtotime($ev['event_at']));
  ?>
    <div class="col ev-item" data-day="<?= h($dayKey) ?>">
      <a class="text-decoration-none" href="<?= h($href) ?>">
        <div class="ev-card h-100<?= $hasVideo ? ' has-video' : '' ?>" <?= $hasVideo ? 'data-m3u8="'.h($m3u8).'"' : '' ?>>
          <div class="ev-media">
            <?php if($thumb): ?>
              <img class="thumb" src="<?= h($thumb) ?>" alt="">
            <?php endif; ?>
            <?php if($hasVideo): ?>
              <video class="ev-video" muted playsinline preload="none"></video>
            <?php endif; ?>

            <div class="ev-progress"><span class="bar"></span></div>
            <?php if($when): ?><div class="when-chip"><?= h($when) ?></div><?php endif; ?>
            <div class="live-badge">LIVE</div>

            <div class="ev-overlay"></div>

            <div class="ev-bottom">
              <h6 class="ev-title"><?= h($ev['title']) ?></h6>
              <span class="cta-pill"><i class="bi bi-play-circle-fill"></i> Guarda ora</span>
              <?php if($desc!==''): ?>
                <p class="ev-desc"><?= h(mb_strimwidth($desc,0,90,'…')) ?></p>
              <?php else: ?>
                <p class="ev-desc" style="opacity:.7"> </p>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </a>
    </div>
  <?php endforeach; ?>
  </div>
<?php endif; ?>

<!-- hls.js -->
<script src="https://cdn.jsdelivr.net/npm/hls.js@1.5.7/dist/hls.min.js" defer></script>
<script>
document.addEventListener('DOMContentLoaded', function(){
  const cards = document.querySelectorAll('.ev-card[data-m3u8]');
  let active = null;

  function clearState(card){
    if(!card) return;
    card.classList.remove('playing');
    card.classList.remove('loading');
  }
  function stopCard(card){
    if(!card) return;
    const v = card.querySelector('video.ev-video');
    if (v){ try{ v.pause(); }catch(e){} }
    const hls = card._hls;
    if (hls){ try{ hls.stopLoad(); }catch(e){} }
    clearState(card);
  }

  cards.forEach(card => {
    const url = card.getAttribute('data-m3u8');
    const video = card.querySelector('video.ev-video');
    if (!url || !video) return;

    let hls = null, started = false, stopTimer = null;

    function startPreview(){
      clearTimeout(stopTimer);

      if (active && active !== card) stopCard(active);
      active = card;

      card.classList.add('loading');

      if (started){
        video.muted = true;
        video.play().catch(()=>{});
        return;
      }
      started = true;

      const cfg = {
        lowLatencyMode: true, backBufferLength: 0, liveSyncDuration: 3,
        maxBufferLength: 6, capLevelToPlayerSize: true, maxInitialBitrate: 300000,
        startLevel: 0, fragLoadingTimeOut: 8000, manifestLoadingTimeOut: 8000,
      };

      if (video.canPlayType('application/vnd.apple.mpegurl')) {
        video.src = url; video.muted = true; video.play().catch(()=>{});
      } else if (window.Hls && Hls.isSupported()){
        hls = new Hls(cfg); card._hls = hls;
        hls.loadSource(url); hls.attachMedia(video);
        hls.on(Hls.Events.MANIFEST_PARSED, () => {
          try { hls.currentLevel = 0; } catch(e){}
          video.muted = true; video.play().catch(()=>{});
        });
      }
    }

    function stopPreview(){
      stopTimer = setTimeout(() => {
        if (active === card) active = null;
        stopCard(card);
      }, 300);
    }

    video.addEventListener('waiting', () => card.classList.add('loading'));
    video.addEventListener('stalled', () => card.classList.add('loading'));
    video.addEventListener('seeking', () => card.classList.add('loading'));
    video.addEventListener('canplay', () => card.classList.remove('loading'));
    video.addEventListener('playing', () => { card.classList.add('playing'); card.classList.remove('loading'); });
    video.addEventListener('pause',   () => card.classList.remove('playing'));
    video.addEventListener('ended',   () => clearState(card));
    video.addEventListener('error',   () => clearState(card));

    card.addEventListener('mouseenter', startPreview);
    card.addEventListener('mouseleave', stopPreview);

    const io = new IntersectionObserver(entries => {
      entries.forEach(e => { if (!e.isIntersecting) stopPreview(); });
    }, {threshold: 0});
    io.observe(card);

    const nearIo = new IntersectionObserver(entries => {
      entries.forEach(e => {
        if (e.isIntersecting) {
          nearIo.unobserve(card);
          try { fetch(url, {mode:'cors', credentials:'omit'}).catch(()=>{}); }catch(err){}
        }
      });
    }, {rootMargin: '300px'});
    nearIo.observe(card);
  });

  document.addEventListener('click', function(e){
    const a = e.target.closest('a[href]');
    if (a) { if (active) stopCard(active); active = null; }
  });
});
</script>

<!-- Filtro in-page con transizione -->
<script>
document.addEventListener('DOMContentLoaded', function(){
  const chips = document.querySelectorAll('#dateChips .chip[data-day]');
  const items = Array.from(document.querySelectorAll('#evGrid .ev-item'));

  function setActiveChip(day){
    chips.forEach(c => c.classList.toggle('active', c.getAttribute('data-day') === day));
  }

  function applyFilter(day){
    setActiveChip(day);
    const showAll = (day === '' || day === null);

    items.forEach(el => {
      const match = showAll || el.getAttribute('data-day') === day;
      const isHidden = el.classList.contains('filter-hidden');

      if (match && isHidden) {
        el.classList.remove('filter-hidden');
        el.classList.add('filter-hide');
        void el.offsetWidth; // reflow
        el.classList.remove('filter-hide');
      } else if (!match && !isHidden) {
        el.classList.add('filter-hide');
        setTimeout(() => {
          el.classList.add('filter-hidden');
          el.classList.remove('filter-hide');
        }, 220);
      }
    });

    // Scroll gentile al titolo
    const anchor = document.getElementById('upcoming');
    if (anchor) anchor.scrollIntoView({behavior:'smooth', block:'start'});
  }

  chips.forEach(ch => {
    ch.addEventListener('click', () => {
      const day = ch.getAttribute('data-day') || '';
      applyFilter(day);
    });
  });
});
</script>

<?php require_once __DIR__.'/../partials/footer.php'; ?>