<?php
// /client/live.php
$page_title = 'Live';

require_once __DIR__.'/../partials/authguard.php';
require_once __DIR__.'/../partials/header.php';

/* === forza UTF-8 === */
if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset','UTF-8');
mb_internal_encoding('UTF-8');

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

/* ================= Helpers ================= */
function extract_iframe_src($html){
  return (preg_match('/<iframe[^>]*src=["\']([^"\']+)["\'][^>]*>/i', (string)$html, $m)) ? $m[1] : null;
}
function embed_host_allowed($url){
  if (!defined('ALLOWED_EMBED_HOSTS') || !is_array(ALLOWED_EMBED_HOSTS) || empty(ALLOWED_EMBED_HOSTS)) return true;
  $host = parse_url($url, PHP_URL_HOST) ?: '';
  $host = strtolower(preg_replace('/^www\./i','', $host));
  foreach (ALLOWED_EMBED_HOSTS as $allowed){
    $allowed = strtolower($allowed);
    if ($host === $allowed || str_ends_with($host, '.'.$allowed)) return true;
  }
  return false;
}
function parse_embed_variants($val): array {
  $val = trim((string)$val);
  if ($val === '') return [];
  if ($val[0] === '[' || $val[0] === '{') {
    $j = json_decode($val, true);
    if (json_last_error() === JSON_ERROR_NONE) {
      if (isset($j['list']) && is_array($j['list'])) $j = $j['list'];
      $out=[];
      foreach ($j as $i=>$it) {
        if (is_string($it)) {
          $out[] = ['label'=>'Embed '.($i+1), 'code'=>$it, 'sort'=>0];
        } elseif (is_array($it) && !empty($it['code'])) {
          $out[] = [
            'label'=>trim((string)($it['label'] ?? ('Embed '.($i+1)))),
            'code' =>trim((string)$it['code']),
            'sort' =>(int)($it['sort'] ?? 0),
          ];
        }
      }
      usort($out, fn($a,$b)=>($a['sort'] <=> $b['sort']));
      return $out;
    }
  }
  return [['label'=>'Embed 1','code'=>$val,'sort'=>0]];
}
function client_ip(): string {
  foreach (['HTTP_CF_CONNECTING_IP','HTTP_X_FORWARDED_FOR','HTTP_X_REAL_IP','REMOTE_ADDR'] as $k) {
    if (!empty($_SERVER[$k])) {
      $ip = trim(explode(',', $_SERVER[$k])[0]);
      if (filter_var($ip, FILTER_VALIDATE_IP)) return substr($ip,0,45);
    }
  }
  return '';
}

/* ================= Carica live (id o slug) ================= */
$id   = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$slug = isset($_GET['slug']) ? (string)$_GET['slug'] : '';
if ($slug === '' && !empty($_SERVER['PATH_INFO'])) {
  $slug = trim($_SERVER['PATH_INFO'], '/');
}

if ($id > 0) {
  $st = $pdo->prepare("SELECT * FROM lives WHERE id=? AND is_active=1");
  $st->execute([$id]);
} else {
  $st = $pdo->prepare("SELECT * FROM lives WHERE slug=? AND is_active=1");
  $st->execute([$slug]);
}
$live = $st->fetch();

if(!$live){
  http_response_code(404);
  echo '<div class="container my-4"><div class="alert alert-danger">Live non trovata.</div></div>';
  require_once __DIR__.'/../partials/footer.php'; exit;
}

/* ================= Live collegata (per MEDIA) ================= */
$media = $live; $linkInfo = null;
if (!empty($live['linked_live_id'])) {
  $st2 = $pdo->prepare("SELECT * FROM lives WHERE id=? AND is_active=1");
  $st2->execute([(int)$live['linked_live_id']]);
  if ($link = $st2->fetch()) {
    $media = $link;
    $linkInfo = ['id'=>(int)$link['id'], 'title'=>(string)$link['title'], 'slug'=>(string)$link['slug']];
  }
}

/* ================= Categoria per Back ================= */
$catSlug=''; $catName=''; $catHidden=0;
if (!empty($live['category_id'])) {
  $stc=$pdo->prepare("SELECT slug,name,COALESCE(is_hidden,0) AS is_hidden FROM categories WHERE id=?");
  $stc->execute([(int)$live['category_id']]);
  if($r=$stc->fetch()){
    $catSlug=$r['slug']; $catName=$r['name']; $catHidden=(int)$r['is_hidden'];
  }
}
$backUrl = $catHidden
  ? '/dirette'
  : ($catSlug ? ('/categoria/'.rawurlencode($catSlug)) : '/dirette');

/* ================= Dati evento ================= */
$isAlwaysLive = !empty($live['always_live']);
$eventLabel   = !empty($live['event_at']) ? date('d/m/Y H:i', strtotime($live['event_at'])) : null;
$description  = trim($live['description'] ?? '');

/* ================= Sorgenti (embed/m3u8) ================= */
$embeds = parse_embed_variants($media['embed_code'] ?? '');
$embeds = array_values(array_filter($embeds, function($e){
  $src = extract_iframe_src($e['code'] ?? '');
  return $src && embed_host_allowed($src);
}));
$hasEmbeds = count($embeds) > 0;

$m3u8Url  = trim($media['m3u8_url'] ?? '');
$useEmbed = $hasEmbeds; // se ci sono embed validi, usa quelli

/* ================= Stato abbonamento ================= */
$subscribed = user_is_subscribed();
$returnTo   = $_SERVER['REQUEST_URI'] ?? '/dirette';
$pricingUrl = '/prezzi?r='.urlencode($returnTo);

/* ================= Limite 1 dispositivo + Presenza (TTL 20s) ================= */
$uid    = (int)($_SESSION['user']['id'] ?? 0);
$liveId = (int)$live['id'];
$TTL_SEC = 20; // finestra attivo corta
$ipNow   = client_ip();

// device_key da cookie dev_id (come in authguard)
$devKey = $_COOKIE['dev_id'] ?? '';
if (!preg_match('/^[A-Fa-f0-9]{40,128}$/',$devKey)) {
  try { $devKey = bin2hex(random_bytes(24)); } catch(Throwable $e){ $devKey = bin2hex(openssl_random_pseudo_bytes(24)); }
  setcookie('dev_id',$devKey,[
    'expires'=> time()+60*60*24*365*5,
    'path'=>'/',
    'secure'=> !empty($_SERVER['HTTPS']),
    'httponly'=> true,
    'samesite'=> 'Lax'
  ]);
  $_COOKIE['dev_id']=$devKey;
}

// Assicura tabella presenza (schema compatibile con API)
try{
  $pdo->exec("CREATE TABLE IF NOT EXISTS live_presence (
    id INT AUTO_INCREMENT PRIMARY KEY,
    live_id INT NOT NULL,
    user_id INT NULL,
    device_key VARCHAR(128) NULL,
    sess_id VARCHAR(128) NULL,
    ip VARCHAR(45) NULL,
    updated_at DATETIME NOT NULL,
    KEY idx_live (live_id),
    KEY idx_user (user_id),
    KEY idx_updated (updated_at)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
}catch(Throwable $e){/* no-op */}

// Prova a creare indice unico su (live_id,user_id,device_key)
try { $pdo->exec("CREATE UNIQUE INDEX IF NOT EXISTS uniq_live_user_dev ON live_presence(live_id,user_id,device_key)"); } catch (Throwable $e) {}

// 1) Registra SUBITO la presenza di questo device
try{
  $up = $pdo->prepare("INSERT INTO live_presence (live_id,user_id,device_key,ip,updated_at)
                       VALUES (?,?,?,?,NOW())
                       ON DUPLICATE KEY UPDATE ip=VALUES(ip), updated_at=NOW()");
  $up->execute([$liveId,$uid,$devKey,$ipNow]);
}catch(Throwable $e){ /* silenzioso */ }

// 2) Blocco immediato: altro device?
$blocked = false;
try{
  $q = $pdo->prepare("SELECT 1 FROM live_presence 
                      WHERE user_id=? AND live_id=? AND device_key<>?
                        AND updated_at >= (NOW() - INTERVAL $TTL_SEC SECOND)
                      LIMIT 1");
  $q->execute([$uid,$liveId,$devKey]);
  $blocked = (bool)$q->fetchColumn();
}catch(Throwable $e){ $blocked=false; }

// 3) Contatore iniziale
$onlineCount = 0;
try{
  $q = $pdo->prepare("SELECT COUNT(*) FROM live_presence 
                      WHERE live_id=? AND updated_at >= (NOW() - INTERVAL ? SECOND)");
  $q->execute([$liveId, $TTL_SEC]);
  $onlineCount = (int)$q->fetchColumn();
}catch(Throwable $e){ $onlineCount = 0; }
?>
<style>
  :root{
    --shadow: 0 10px 30px rgba(0,0,0,.35);
    --radius: 18px;
    --radius-lg: 22px;
    --glass-bg: rgba(20,23,28,.55);
    --glass-brd: rgba(255,255,255,.22);
    --text-strong: #ffffff;
    --text-muted: #d7deea;
    --chip-bg: rgba(255,255,255,.12);
  }
  .section-title{ margin:0; font-weight:700; letter-spacing:.3px; color: var(--text-strong); }
  @supports (-webkit-background-clip: text) or (background-clip: text){
    .section-title{ background: linear-gradient(90deg,#ffffff,#cfe0ff); -webkit-background-clip: text; background-clip:text; -webkit-text-fill-color: transparent; color: transparent; }
  }
  .glass-head, .glass-card, .glass-alert{
    background: var(--glass-bg);
    border:1px solid var(--glass-brd);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    color: var(--text-strong);
  }
  .glass-head{ padding:14px 16px; }
  .glass-card{ overflow: hidden; }
  .glass-card .card-body{ padding: 12px; }
  .glass-alert{ padding: .75rem .9rem; }
  .btn-ghost{ border:1px solid var(--glass-brd); background: rgba(255,255,255,0.08); color: var(--text-strong); backdrop-filter: blur(6px); -webkit-backdrop-filter: blur(6px); }
  .btn-ghost:hover{ background: rgba(255,255,255,0.18); color: var(--text-strong); }
  .online-chip{ display:inline-flex; align-items:center; gap:.5rem; background: var(--chip-bg); border:1px solid var(--glass-brd); border-radius:999px; padding:.35rem .75rem; font-weight:700; color: var(--text-strong); backdrop-filter: blur(6px); -webkit-backdrop-filter: blur(6px); }
  .online-dot{ width:10px; height:10px; border-radius:50%; background:#22c55e; box-shadow:0 0 0 3px rgba(34,197,94,.2); }
  .player-wrap{ padding: 8px; }
  .player-aspect{ aspect-ratio: 16 / 9; width: 100%; max-width: 1600px; margin: 0 auto; max-height: 80vh; }
  .player-aspect .video-js{ width: 100%; height: 100%; border-radius: 14px; overflow: hidden; }
  .player-aspect iframe{ width:100% !important; height:100% !important; border:0; border-radius:14px; display:block; }
  .device-lock { border-left:4px solid #f59e0b; }
</style>

<!-- Header -->
<div class="glass-head d-flex justify-content-between align-items-center mb-3">
  <h4 class="section-title"><?= h($live['title']) ?></h4>
  <div class="d-flex align-items-center gap-2">
    <a href="<?= h($backUrl) ?>" class="btn btn-sm btn-ghost">
      &larr; <?= $catName ? 'Categoria: '.h($catName) : 'Categoria' ?>
    </a>
  </div>
</div>

<!-- Alert area -->
<div id="alerts" class="mb-3">
  <?php if ($blocked): ?>
    <div class="alert glass-alert device-lock">
      Questo contenuto &egrave; gi&agrave; in riproduzione su un altro dispositivo del tuo account.<br>
      Per continuare, disconnetti l&rsquo;altro dispositivo da <strong>Profilo &rarr; Dispositivi</strong>.
      <div class="mt-2">
        <a class="btn btn-warning btn-sm" href="/profilo#devices">Gestisci dispositivi</a>
      </div>
    </div>
  <?php endif; ?>
</div>

<?php if ($subscribed && !$blocked): ?>
  <!-- Player / Embed -->
  <div class="glass-card player-wrap mb-2">
    <div id="playerAspect" class="player-aspect">
      <?php if ($useEmbed): ?>
        <div id="embedContainer" style="width:100%;height:100%">
          <?= $embeds ? $embeds[0]['code'] : '' ?>
        </div>
      <?php else: ?>
        <video id="player" class="video-js vjs-default-skin vjs-fill" controls playsinline></video>
      <?php endif; ?>
    </div>

    <?php if ($useEmbed && count($embeds) > 1): ?>
      <div class="switchers d-flex gap-2 flex-wrap justify-content-center p-2">
        <?php foreach ($embeds as $i=>$e): ?>
          <button type="button" class="btn btn-outline-light btn-sm<?= $i===0?' active':'' ?>" data-embed-idx="<?= (int)$i ?>">
            <?= h($e['label'] ?: ('Embed '.($i+1))) ?>
          </button>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>

  <?php if ($linkInfo): ?>
    <p class="text-center text-muted">Contenuto fornito da:
      <a class="text-decoration-underline" href="/live/<?= h(rawurlencode($linkInfo['slug'])) ?>">
        <?= h($linkInfo['title']) ?>
      </a>
    </p>
  <?php endif; ?>

<?php elseif (!$subscribed): ?>
  <!-- CTA abbonamento -->
  <div class="glass-card mb-2">
    <div class="card-body d-flex flex-column flex-md-row align-items-md-center gap-3">
      <div class="lock-icon"><i class="bi bi-lock-fill"></i></div>
      <div class="flex-grow-1">
        <h5 class="mb-1">Abbonamento richiesto</h5>
        <div class="text-muted">Per guardare questa live &egrave; necessario un abbonamento attivo.</div>
      </div>
      <div class="d-flex gap-2">
        <a class="btn btn-primary" href="<?= h($pricingUrl) ?>">Vedi prezzi</a>
        <a class="btn btn-outline-light" href="/assistenza">Hai gi&agrave; pagato?</a>
      </div>
    </div>
  </div>
<?php endif; ?>

<!-- Info -->
<div class="glass-card mb-4">
  <div class="card-body d-flex flex-wrap align-items-start gap-2">
    <div class="flex-grow-1">
      <h5 class="m-0"><?= h($live['title']) ?></h5>
      <div class="text-muted mt-1">
        <?php if ($isAlwaysLive): ?>
          <span class="badge bg-success">Sempre live</span>
        <?php elseif ($eventLabel): ?>
          <span class="badge bg-primary"><?= h($eventLabel) ?></span>
        <?php else: ?>
          <span class="badge bg-secondary">Data da definire</span>
        <?php endif; ?>
        <?php if (!empty($catName)): ?>
          <span class="badge bg-dark ms-1"><?= h($catName) ?></span>
        <?php endif; ?>
      </div>
      <p class="mt-2 mb-0"><?= $description!=='' ? nl2br(h($description)) : '<span class="text-muted">Nessuna descrizione disponibile.</span>' ?></p>
    </div>
    <div class="ms-auto">
      <div id="presence-chip" class="online-chip" title="Utenti connessi a questa live">
        <span class="online-dot" aria-hidden="true"></span>
        <span><span id="presence-count"><?= (int)$onlineCount ?></span> online</span>
      </div>
    </div>
  </div>
</div>

<?php if ($subscribed && !$blocked): ?>
<?php if (!$useEmbed): /* === Player JS per m3u8 con device lock === */ ?>
<script>
window.addEventListener('load', function () {
  var m3u8 = <?= json_encode($m3u8Url) ?>;

  function showDeviceLock(){
    try { player.pause(); } catch(e){}
    var wrap = document.getElementById('playerAspect');
    if (wrap) wrap.innerHTML = '<div class="d-flex align-items-center justify-content-center h-100 text-center p-3 text-warning">Riproduzione bloccata: la live &egrave; attiva su un altro dispositivo.<br><a class="btn btn-warning btn-sm mt-2" href="/profilo#devices">Gestisci dispositivi</a></div>';
    document.getElementById('alerts').innerHTML = '<div class="alert glass-alert device-lock">Questo contenuto &egrave; gi&agrave; in riproduzione su un altro dispositivo del tuo account.<div class="mt-2"><a class="btn btn-warning btn-sm" href="/profilo#devices">Gestisci dispositivi</a></div></div>';
  }
  window.__deviceLock = showDeviceLock;

  var overrideNative = !(videojs.browser && (videojs.browser.IS_SAFARI || videojs.browser.IS_IOS));
  var player = videojs('player', {
    autoplay:false, preload:'auto', liveui:true, fluid:false, fill:true,
    html5:{ vhs:{ overrideNative:overrideNative, enableLowInitialPlaylist:true, experimentalBufferBasedABR:true, withCredentials:false } }
  });
  try { if (player.chromecast) player.chromecast({ addButtonToControlBar: true }); } catch(e){}
  try { if (player.airPlay)   player.airPlay(); } catch(e){}
  try { if (player.hlsQualitySelector) player.hlsQualitySelector({ displayCurrentQuality:true, vjsIconClass:'vjs-icon-hd' }); } catch(e){}
  player.on('loadedmetadata', function(){
    var vw = player.videoWidth && player.videoWidth();
    var vh = player.videoHeight && player.videoHeight();
    var wrap = document.getElementById('playerAspect');
    if (wrap && vw && vh) wrap.style.aspectRatio = vw + ' / ' + vh;
  });
  try{ if (m3u8) { player.src({ src:m3u8, type:'application/x-mpegURL' }); player.play().catch(function(){}); } }catch(e){}
});
</script>
<?php else: /* === Embed === */ ?>
<script>
window.addEventListener('load', function(){
  function showDeviceLock(){
    var c = document.getElementById('embedContainer');
    if (c) c.innerHTML = '<div class="d-flex align-items-center justify-content-center h-100 text-center p-3 text-warning">Riproduzione bloccata: la live &egrave; attiva su un altro dispositivo.<br><a class="btn btn-warning btn-sm mt-2" href="/profilo#devices">Gestisci dispositivi</a></div>';
    document.getElementById('alerts').innerHTML = '<div class="alert glass-alert device-lock">Questo contenuto &egrave; gi&agrave; in riproduzione su un altro dispositivo del tuo account.<div class="mt-2"><a class="btn btn-warning btn-sm" href="/profilo#devices">Gestisci dispositivi</a></div></div>';
  }
  window.__deviceLock = showDeviceLock;

  // switcher embed
  document.querySelectorAll('[data-embed-idx]').forEach(function(btn){
    btn.addEventListener('click', function(){
      document.querySelectorAll('[data-embed-idx]').forEach(b=>b.classList.remove('active'));
      btn.classList.add('active');
      var idx = parseInt(btn.getAttribute('data-embed-idx'),10);
      var embeds = <?= json_encode($embeds) ?>;
      var html = (embeds[idx] && embeds[idx].code) ? embeds[idx].code : '';
      var c = document.getElementById('embedContainer');
      if (c) c.innerHTML = html;
    });
  });
});
</script>
<?php endif; ?>
<?php endif; ?>

<!-- PRESENCE (heartbeat: count + device-lock realtime) -->
<script>
(function(){
  const LIVE_ID = <?= (int)$live['id'] ?>;
  const COUNT_EL = document.getElementById('presence-count');
  const INTERVAL_MS = 4000; // ping ogni 4s

  async function ping(){
    try{
      const r = await fetch('/client/api_live_presence.php', {
        method: 'POST',
        headers: {'Content-Type':'application/x-www-form-urlencoded'},
        body: 'live_id=' + encodeURIComponent(LIVE_ID),
        cache: 'no-store',
        credentials: 'same-origin'
      });
      const ct = (r.headers.get('Content-Type') || '').toLowerCase();
      if (!ct.includes('application/json')) return;
      const j = await r.json();
      if (typeof j.count === 'number') COUNT_EL.textContent = j.count;
      if (j.other_device === true && typeof window.__deviceLock === 'function') {
        window.__deviceLock();
      }
    }catch(e){ /* silent */ }
  }

  ping();
  setInterval(ping, INTERVAL_MS);
  document.addEventListener('visibilitychange', function(){
    if (document.visibilityState === 'visible') ping();
  });
})();
</script>

<!-- Blocco strumenti (facoltativo) -->
<script>
document.addEventListener('contextmenu', e => e.preventDefault());
document.addEventListener('keydown', (e) => {
  const k = (e.key || '').toLowerCase();
  if (e.key === 'F12' || (e.ctrlKey && e.shiftKey && (k === 'i' || k === 'j' || k === 'c'))) {
    e.preventDefault(); e.stopPropagation();
    location.href = '/eh_volevi.php';
  }
}, true);
</script>

<?php require_once __DIR__.'/../partials/footer.php'; ?>