<?php
$page_title='Risultati Live';
require_once __DIR__.'/../partials/authguard.php';
require_once __DIR__.'/../partials/header.php';
?>

<style>
  :root{
    --shadow: 0 10px 30px rgba(0,0,0,.35);
    --radius: 18px;
    --radius-lg: 22px;
    /* Valori base per look “glass” leggibile in light/dark */
    --glass-bg: rgba(20,23,28,.55);
    --glass-brd: rgba(255,255,255,.22);
    --text-strong: #ffffff;
    --text-muted: #d7deea;
  }
  @media (prefers-color-scheme: dark){
    :root{
      --glass-bg: rgba(17,17,17,.32);
      --glass-brd: rgba(255,255,255,.12);
      --text-strong: #e8e8e8;
      --text-muted: #b9c0cc;
    }
  }

  /* Titolo con fallback solido + gradiente solo se supportato */
  .section-title{
    margin:0; font-weight:700; letter-spacing:.3px;
    color: var(--text-strong);
  }
  @supports (-webkit-background-clip: text) or (background-clip: text){
    .section-title{
      background: linear-gradient(90deg,#ffffff,#cfe0ff);
      -webkit-background-clip: text; background-clip: text;
      -webkit-text-fill-color: transparent; color: transparent;
    }
  }
  @media (max-width:576px){
    .section-title{
      background:none !important;
      -webkit-background-clip: initial; background-clip: initial;
      -webkit-text-fill-color: initial; color: var(--text-strong) !important;
      text-shadow: 0 1px 2px rgba(0,0,0,.35);
    }
  }

  .glass-head{
    background: var(--glass-bg);
    border:1px solid var(--glass-brd);
    border-radius: var(--radius-lg);
    padding:14px 16px;
    box-shadow: var(--shadow);
    color: var(--text-strong);
    backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px);
  }
  .btn-ghost{
    border:1px solid var(--glass-brd);
    background: rgba(255,255,255,0.08);
    color: var(--text-strong);
    backdrop-filter: blur(6px); -webkit-backdrop-filter: blur(6px);
  }
  .btn-ghost:hover{ background: rgba(255,255,255,0.18); color: var(--text-strong); }

  .glass-card{
    background: var(--glass-bg);
    border:1px solid var(--glass-brd);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow);
    color: var(--text-strong);
    backdrop-filter: blur(12px); -webkit-backdrop-filter: blur(12px);
    overflow:hidden;
  }
  .glass-card .card-body{ padding: 14px; }

  /* Tabella */
  .table-live thead th{ color:var(--text-muted); font-weight:600; white-space:nowrap; }
  .table-live td img{ height:18px; }
  /* Mobile: nasconde la colonna competizione per evitare overflow */
  @media (max-width: 576px){
    .table-live thead th:nth-child(2),
    .table-live tbody td:nth-child(2){ display:none; }
  }
</style>

<!-- Header glass: titolo + stamp + back (sempre dashboard) -->
<div class="glass-head d-flex justify-content-between align-items-center mb-3">
  <h4 class="section-title mb-0">Risultati Live</h4>
  <div class="d-flex align-items-center gap-2">
    <small id="live-updated" class="text-muted"></small>
    <a href="/client/dashboard.php" class="btn btn-sm btn-ghost" aria-label="Torna alla dashboard">← Dashboard</a>
  </div>
</div>

<div class="glass-card">
  <div class="card-body">
    <div id="live-box" class="table-responsive" aria-live="polite">
      <div class="text-muted">Caricamento…</div>
    </div>
  </div>
</div>

<script>
async function loadScores(){
  try{
    const r = await fetch('/client/api_scores_auto.php', {cache:'no-store'});
    const j = await r.json();
    if (j.error){ throw new Error(j.error); }
    render(j.items || []);
    setTS();
  }catch(e){
    document.getElementById('live-box').innerHTML =
      '<div class="alert alert-danger mb-0">Errore nel caricamento dei risultati: '+escapeHtml(e.message)+'</div>';
    setTS();
  }
}

function render(items){
  if(!items.length){
    document.getElementById('live-box').innerHTML =
      '<div class="alert alert-info mb-0">Nessuna partita in diretta al momento.</div>';
    return;
  }
  let html = `
  <table class="table table-sm align-middle mb-0 table-live">
    <thead>
      <tr><th style="width:64px">Ora</th><th>Competizione</th><th>Match</th><th style="width:90px">Parziale</th><th style="width:70px">Stato</th></tr>
    </thead><tbody>`;
  for (const fx of items){
    const dt = fx.date ? new Date(fx.date) : null;
    const hh = dt ? String(dt.getHours()).padStart(2,'0') : '--';
    const mm = dt ? String(dt.getMinutes()).padStart(2,'0') : '--';
    const score = (fx.home?.goals!=null && fx.away?.goals!=null) ? `<strong>${fx.home.goals} - ${fx.away.goals}</strong>` : '-';
    const elapsed = fx.elapsed!=null ? `${fx.elapsed}'` : escapeHtml(fx.status || '');
    html += `
      <tr>
        <td>${hh}:${mm}</td>
        <td>${escapeHtml(fx.league||'')} <span class="text-muted">(${escapeHtml(fx.country||'')})</span><div class="small text-muted">${escapeHtml(fx.round||'')}</div></td>
        <td class="d-flex align-items-center gap-2">
          ${fx.home?.logo ? `<img src="${fx.home.logo}" alt="" loading="lazy">` : ''}<strong>${escapeHtml(fx.home?.name||'')}</strong>
          <span class="text-muted">vs</span>
          ${fx.away?.logo ? `<img src="${fx.away.logo}" alt="" loading="lazy">` : ''}<strong>${escapeHtml(fx.away?.name||'')}</strong>
        </td>
        <td>${score}</td>
        <td>${elapsed}</td>
      </tr>`;
  }
  html += '</tbody></table>';
  document.getElementById('live-box').innerHTML = html;
}

function setTS(){
  const el = document.getElementById('live-updated');
  if(!el) return;
  const d = new Date();
  el.textContent = 'Agg. ' + d.toLocaleTimeString();
}
function escapeHtml(s){ return (s??'').replace(/[&<>"']/g, c=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;', "'":'&#39;' }[c])); }

loadScores();
setInterval(loadScores, 15000); // 15 secondi
</script>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
