<?php
// /client/pricing.php
$page_title = 'Piani & Prezzi';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../partials/header.php';

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function euros($n){ return number_format((float)$n, 2, ',', '.'); }

$isLogged = !empty($_SESSION['user']);
$plans = $pdo->query("SELECT * FROM plans WHERE is_active=1 ORDER BY sort_order ASC, months ASC")->fetchAll();
?>
<style>
  /* ===== Modal theming (segue tema chiaro/scuro) ===== */
  :root{ --modal-bg:#fff; --modal-text:#222; --modal-border:#e5e7eb; }
  html[data-theme="dark"]{ --modal-bg:#121416; --modal-text:#e8edf4; --modal-border:rgba(255,255,255,.14); }
  .modal-content{ background:var(--modal-bg); color:var(--modal-text); border:1px solid var(--modal-border); }
  .modal-header,.modal-footer{ border-color:var(--modal-border); }
  .modal-title{ color:var(--modal-text); }
  html[data-theme="dark"] .modal-content .text-muted{ color:#cbd3e1 !important; }
  html[data-theme="dark"] .btn-close{ filter: invert(1) grayscale(100%); opacity:.9; }
  html[data-theme="dark"] .modal-backdrop.show{ opacity:.75; }

  /* ===== Pricing cards ===== */
  .pricing-wrap{max-width:1200px;margin:32px auto;}
  .cards{display:grid;grid-template-columns:repeat(3,minmax(0,1fr));gap:28px}
  @media (max-width: 992px){ .cards{grid-template-columns:repeat(2,1fr);} }
  @media (max-width: 600px){ .cards{grid-template-columns:1fr;} }

  .pcard{
    background:var(--body-bg,#fff);
    border:1px solid rgba(0,0,0,.08);
    border-radius:12px;
    padding:26px;text-align:center;
    box-shadow:0 6px 26px rgba(0,0,0,.06);
  }
  html[data-theme="dark"] .pcard{ background:#121416; border-color:rgba(255,255,255,.12); }
  .old{color:#9aa0a6;text-decoration:line-through;margin-bottom:.2rem;font-weight:700}
  .price{font-size:2.2rem;font-weight:900;margin-bottom:.2rem}
  .per{color:#6b7280}
  ul.feats{list-style:none;padding:0;margin:16px 0 18px}
  ul.feats li{margin:.35rem 0;}
  html[data-theme="dark"] ul.feats li{color:#ddd}
  .foot-note{color:#6b7280;font-size:.95rem;margin:18px 0 10px}
  .btn-cta{display:inline-flex;align-items:center;gap:.6rem;justify-content:center;width:100%;padding:10px 14px;font-weight:800;}
  .icon-power{font-size:1.1rem}
</style>

<div class="pricing-wrap container">
  <div class="mb-3 text-center">
    <h3 class="fw-bold">Scegli il tuo abbonamento</h3>
    <div class="text-muted">Nessun rinnovo automatico: scade da solo al termine del periodo.</div>
  </div>

  <div class="cards">
    <?php foreach($plans as $p):
      $months = (int)$p['months'];
      $per = $months===1 ? ' / 1 mese' : " / {$months} mesi";
      $features = array_filter(array_map('trim', preg_split('/\r?\n/', (string)$p['features'])));
    ?>
      <div class="pcard">
        <?php if((float)$p['list_price']>0): ?>
          <div class="old">€<?= euros($p['list_price']) ?></div>
        <?php endif; ?>

        <div class="price">€<?= euros($p['price']) ?><span class="per"><?= h($per) ?></span></div>

        <?php if($features): ?>
          <ul class="feats">
            <?php foreach($features as $f): ?><li><?= h($f) ?></li><?php endforeach; ?>
          </ul>
        <?php else: ?>
          <ul class="feats">
            <li>Accesso illimitato a tutti gli eventi sportivi</li>
            <li>Streaming in alta definizione</li>
            <li>Compatibile con tutti i dispositivi</li>
            <li>Supporto clienti 24/7</li>
          </ul>
        <?php endif; ?>

        <div class="foot-note">Nessun vincolo: l’abbonamento scade dopo il periodo scelto.</div>

        <?php if($isLogged): ?>
          <button
            class="btn btn-dark btn-cta mt-2 btn-activate"
            data-plan-id="<?= (int)$p['id'] ?>"
            data-plan-name="<?= h($p['name'] ?: 'Piano') ?>"
            data-plan-months="<?= (int)$p['months'] ?>"
            data-plan-price="€<?= euros($p['price']) ?>"
            type="button"
          >
            <i class="bi bi-power icon-power"></i> ATTIVA ORA
          </button>
        <?php else: ?>
          <a class="btn btn-dark btn-cta mt-2" href="/auth/login.php?mode=login">
            <i class="bi bi-power icon-power"></i> ACCEDI PER ATTIVARE
          </a>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- ===== Modal conferma ===== -->
<div class="modal fade" id="planConfirmModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Conferma richiesta</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <div class="modal-body">
        <p class="mb-2">
          <strong>Piano selezionato:</strong>
          <span id="selPlanName">—</span> •
          <span id="selPlanMonths">—</span> •
          <span id="selPlanPrice">—</span>
        </p>
        <p class="text-muted mb-0">
          Se confermi, verrà inviato automaticamente <strong>un ticket agli admin</strong>.<br>
          Rimani in attesa di una risposta con le <strong>modalità di pagamento</strong>.
        </p>
      </div>
      <div class="modal-footer">
        <button class="btn btn-outline-secondary" data-bs-dismiss="modal" type="button">Annulla</button>
        <form id="confirmForm" method="post" action="/client/api_plan_request.php" class="m-0">
          <input type="hidden" name="plan_id" id="confirmPlanId">
          <button class="btn btn-primary" id="confirmBtn" type="submit">Conferma e invia ticket</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function(){
  const modalEl = document.getElementById('planConfirmModal');
  const B = window.bootstrap || null;
  let modal = null;
  if (B && modalEl) modal = new B.Modal(modalEl);

  const nameEl   = document.getElementById('selPlanName');
  const monthsEl = document.getElementById('selPlanMonths');
  const priceEl  = document.getElementById('selPlanPrice');
  const idInput  = document.getElementById('confirmPlanId');
  const form     = document.getElementById('confirmForm');

  document.querySelectorAll('.btn-activate').forEach(btn=>{
    btn.addEventListener('click', (e)=>{
      e.preventDefault();
      const pid    = btn.dataset.planId;
      const name   = btn.dataset.planName || 'Piano';
      const months = btn.dataset.planMonths || '';
      const price  = btn.dataset.planPrice || '';

      nameEl.textContent   = name;
      monthsEl.textContent = (months === '1' ? '1 mese' : (months ? months + ' mesi' : '—'));
      priceEl.textContent  = price;
      idInput.value        = pid;

      if (modal) {
        modal.show();
      } else {
        // Fallback se Bootstrap non è disponibile
        if (confirm(`Confermi la richiesta per ${name} (${monthsEl.textContent}) — ${price}?`)) {
          form.submit();
        }
      }
    });
  });
});
</script>

<?php require_once __DIR__ . '/../partials/footer.php'; ?>
