<?php
// /client/profilo.php
$page_title='Profilo';
require_once __DIR__.'/../partials/authguard.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset','UTF-8');
mb_internal_encoding('UTF-8');

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function set_flash(string $type,string $msg){ $_SESSION['flash']=['type'=>$type,'msg'=>$msg]; }
function pop_flash(){ $f=$_SESSION['flash']??null; unset($_SESSION['flash']); return $f; }

/* ====== CSRF ====== */
if (empty($_SESSION['csrf'])) {
  $_SESSION['csrf'] = bin2hex(random_bytes(32));
}
function require_csrf(): bool {
  $ok = isset($_POST['csrf'], $_SESSION['csrf']) && hash_equals($_SESSION['csrf'], (string)$_POST['csrf']);
  if(!$ok) set_flash('danger','Sessione non valida o scaduta. Riprova.');
  $_SESSION['csrf'] = bin2hex(random_bytes(32)); // ruota sempre dopo POST
  return $ok;
}

/* ====== assicurati colonna/indice playlist_token ====== */
function ensure_user_playlist_token_column(PDO $pdo): void {
  static $done=false; if($done) return; $done=true;
  try{
    $db = $pdo->query("SELECT DATABASE()")->fetchColumn();

    $chk=$pdo->prepare("SELECT COUNT(*) FROM information_schema.COLUMNS
                        WHERE TABLE_SCHEMA=? AND TABLE_NAME='users' AND COLUMN_NAME='playlist_token'");
    $chk->execute([$db]);
    if(!$chk->fetchColumn()){
      $pdo->exec("ALTER TABLE users ADD COLUMN playlist_token VARCHAR(128) NULL DEFAULT NULL");
    }
    $idx=$pdo->prepare("SELECT COUNT(*) FROM information_schema.STATISTICS
                        WHERE TABLE_SCHEMA=? AND TABLE_NAME='users' AND INDEX_NAME='uniq_users_playlist_token'");
    $idx->execute([$db]);
    if(!$idx->fetchColumn()){
      try{ $pdo->exec("DROP INDEX idx_users_playlist_token ON users"); }catch(Throwable $e){}
      try{ $pdo->exec("CREATE UNIQUE INDEX uniq_users_playlist_token ON users(playlist_token)"); }catch(Throwable $e){}
    }
  }catch(Throwable $e){}
}
ensure_user_playlist_token_column($pdo);

/* ====== dati utente ====== */
$uid = (int)($_SESSION['user']['id'] ?? 0);
$st  = $pdo->prepare("SELECT id,email,password_hash,playlist_token,playlist_enabled FROM users WHERE id=?");
$st->execute([$uid]);
$user = $st->fetch(PDO::FETCH_ASSOC);
if(!$user){ header('Location:/auth/login.php'); exit; }

$userToken   = trim((string)($user['playlist_token'] ?? ''));
$canPlaylist = !empty($user['playlist_enabled']);

/* ====== Helpers ====== */
function gen_unique_playlist_token(PDO $pdo): string {
  for($i=0; $i<5; $i++){
    try{ $t = bin2hex(random_bytes(24)); }catch(Throwable $e){ $t = bin2hex(openssl_random_pseudo_bytes(24)); }
    $chk = $pdo->prepare("SELECT 1 FROM users WHERE playlist_token=? LIMIT 1");
    $chk->execute([$t]);
    if(!$chk->fetch()) return $t;
  }
  return bin2hex(random_bytes(32));
}

/* ====== POST ====== */
if($_SERVER['REQUEST_METHOD']==='POST'){
  if (!require_csrf()) { header('Location: /client/profilo.php'); exit; }

  if(isset($_POST['change_email'])){
    $raw = trim((string)($_POST['email'] ?? ''));
    $email = strtolower($raw);
    if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
      set_flash('danger','Inserisci un indirizzo email valido.');
    }elseif(strtolower($email) === strtolower($user['email'])){
      set_flash('info','L’email è già impostata a questo valore.');
    }else{
      $chk = $pdo->prepare("SELECT id FROM users WHERE LOWER(email)=LOWER(?) AND id<>?");
      $chk->execute([$email,$uid]);
      if($chk->fetch()){
        set_flash('danger','Email già in uso da un altro account.');
      }else{
        $pdo->prepare("UPDATE users SET email=? WHERE id=?")->execute([$email,$uid]);
        $_SESSION['user']['email'] = $email;
        set_flash('success','Email aggiornata con successo.');
      }
    }
    header('Location: /client/profilo.php'); exit;
  }

  if(isset($_POST['change_password'])){
    $cur = (string)($_POST['current_password'] ?? '');
    $new = (string)($_POST['new_password'] ?? '');
    $rep = (string)($_POST['new_password2'] ?? '');
    if(!password_verify($cur, $user['password_hash'])){
      set_flash('danger','La password attuale non è corretta.');
    }elseif(strlen($new)<8){
      set_flash('danger','La nuova password deve avere almeno 8 caratteri.');
    }elseif(!preg_match('/[A-Za-z]/',$new) || !preg_match('/\d/',$new)){
      set_flash('danger','La nuova password deve contenere lettere e numeri.');
    }elseif($new === $cur){
      set_flash('danger','La nuova password non può essere uguale a quella attuale.');
    }elseif($new !== $rep){
      set_flash('danger','Le nuove password non coincidono.');
    }else{
      $hash = password_hash($new, PASSWORD_DEFAULT);
      $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([$hash,$uid]);
      if(function_exists('session_regenerate_id')) @session_regenerate_id(true);
      set_flash('success','Password aggiornata con successo.');
    }
    header('Location: /client/profilo.php'); exit;
  }

  if(isset($_POST['gen_user_playlist_token'])){
    if(!$canPlaylist){
      set_flash('danger','Funzione playlist non abilitata per il tuo account (contatta l’admin).');
    }else{
      $new = gen_unique_playlist_token($pdo);
      $pdo->prepare("UPDATE users SET playlist_token=? WHERE id=?")->execute([$new, $uid]);
      $userToken = $new;
      set_flash('success','Token playlist generato/rigenerato.');
    }
    header('Location: /client/profilo.php'); exit;
  }

  if(isset($_POST['clear_user_playlist_token'])){
    if(!$canPlaylist){
      set_flash('danger','Funzione playlist non abilitata per il tuo account (contatta l’admin).');
    }else{
      $pdo->prepare("UPDATE users SET playlist_token=NULL WHERE id=?")->execute([$uid]);
      $userToken = '';
      set_flash('success','Token playlist revocato.');
    }
    header('Location: /client/profilo.php'); exit;
  }
}

/* ====== GET (dopo PRG) ====== */
$flash = pop_flash();

/* ====== base URL ====== */
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https' : 'http';
$host   = $_SERVER['HTTP_HOST'] ?? 'localhost';
$base   = $scheme.'://'.$host;

require_once __DIR__.'/../partials/header.php';
?>

<style>
  .profile-header{ display:flex; align-items:center; justify-content:space-between; gap:1rem; margin-bottom:1rem; }
  .profile-title{ font-weight:800; letter-spacing:.2px; }
  .card-glass{ background: var(--modal-bg,#fff); border:1px solid var(--modal-border,#e5e7eb); border-radius:16px; box-shadow:0 10px 30px rgba(0,0,0,.08); }
  .card-glass .card-head{ display:flex; align-items:center; gap:.6rem; border-bottom:1px solid var(--modal-border,#e5e7eb); padding:.85rem 1rem; font-weight:700; }
  .card-glass .card-body{ padding:1rem; }
  .same-height{ display:flex; height:100%; } .same-height > .card-glass{ width:100%; display:flex; flex-direction:column; } .same-height .card-body{ flex:1; }
  .table th, .table td{ vertical-align:middle; }
  .flash-center{ position:fixed; inset:0; display:flex; align-items:center; justify-content:center; background:rgba(0,0,0,.35); z-index:2000; }
  .flash-card{ background:var(--modal-bg,#fff); color:var(--modal-text,#222); border-radius:18px; padding:18px 22px; text-align:center; min-width:260px; box-shadow:0 20px 60px rgba(0,0,0,.35); }
  .flash-card .bi{ font-size:2rem; display:block; margin-bottom:.25rem; }
  .pill-me{ display:inline-flex; align-items:center; gap:.4rem; padding:.15rem .5rem; border-radius:999px; font-size:.8rem; font-weight:700; background:#e7f6ef; color:#136f3a; border:1px solid #cfe9db; }

  /* App download badges */
  .store-card .store-actions{ display:flex; gap:.75rem; flex-wrap:wrap; }
  .store-badge{
    display:inline-flex; align-items:center; gap:.55rem;
    border-radius:14px; padding:.65rem .9rem; font-weight:700; border:1px solid transparent;
    text-decoration:none !important;
  }
  .store-badge .bi{ font-size:1.25rem; }
  .store-badge.android{ background:#e9f7ef; color:#0b7d3b; border-color:#cfe9db; }
  .store-badge.ios{ background:#eef1f5; color:#0f1115; border-color:#d8dde5; }
  .store-note{ font-size:.9rem; color:#6c757d; }
</style>

<?php if($flash): ?>
  <div class="flash-center" id="flashCenter" role="status" aria-live="polite">
    <div class="flash-card">
      <?php if($flash['type']==='success'): ?><i class="bi bi-check-circle-fill"></i>
      <?php elseif($flash['type']==='info'): ?><i class="bi bi-info-circle-fill"></i>
      <?php else: ?><i class="bi bi-exclamation-triangle-fill"></i><?php endif; ?>
      <div class="fw-bold"><?= h($flash['msg']) ?></div>
    </div>
  </div>
  <script> setTimeout(()=>document.getElementById('flashCenter')?.remove(), 1600); </script>
<?php endif; ?>

<div class="profile-header">
  <div>
    <h4 class="profile-title mb-0">Il tuo profilo</h4>
    <div class="text-muted small">Gestisci email, password, dispositivi e playlist personale</div>
  </div>
  <!-- Niente bottoni qui: restano solo in basso -->
</div>

<div class="row g-3">
  <!-- Modifica email -->
  <div class="col-12 col-lg-6 same-height">
    <div class="card-glass">
      <div class="card-head"><i class="bi bi-envelope"></i> Modifica email</div>
      <div class="card-body">
        <form method="post" class="row g-2">
          <input type="hidden" name="csrf" value="<?= h($_SESSION['csrf']) ?>">
          <div class="col-12">
            <label class="form-label">Email</label>
            <input type="email" name="email" value="<?= h($user['email']) ?>" class="form-control" required autocomplete="email">
          </div>
          <div class="col-12">
            <button name="change_email" class="btn btn-primary">Salva</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Modifica password -->
  <div class="col-12 col-lg-6 same-height">
    <div class="card-glass">
      <div class="card-head"><i class="bi bi-shield-lock"></i> Modifica password</div>
      <div class="card-body">
        <form method="post" class="row g-2">
          <input type="hidden" name="csrf" value="<?= h($_SESSION['csrf']) ?>">
          <div class="col-12">
            <label class="form-label">Password attuale</label>
            <input type="password" name="current_password" class="form-control" required autocomplete="current-password">
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label">Nuova password</label>
            <input type="password" name="new_password" minlength="8" class="form-control" required autocomplete="new-password">
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label">Ripeti nuova password</label>
            <input type="password" name="new_password2" minlength="8" class="form-control" required autocomplete="new-password">
          </div>
          <div class="col-12">
            <button name="change_password" class="btn btn-primary">Aggiorna</button>
          </div>
        </form>
        <div class="small text-muted mt-2">
          Suggerimento: usa almeno 8 caratteri con lettere e numeri.
        </div>
      </div>
    </div>
  </div>

  <!-- Scarica l'app -->
  <div class="col-12">
    <div class="card-glass store-card">
      <div class="card-head">
        <i class="bi bi-cloud-arrow-down"></i> Scarica l’app
      </div>
      <div class="card-body">
        <div class="store-actions">
          <!-- ANDROID: scarica APK -->
          <a class="store-badge android" href="/uploads/app/SuperSport.apk" download>
            <i class="bi bi-android2"></i>
            <span>Scarica APK (Android)</span>
          </a>

          <!-- iOS: popup WIP -->
          <button type="button" class="store-badge ios" data-bs-toggle="modal" data-bs-target="#iosWipModal">
            <i class="bi bi-apple"></i>
            <span>iOS (presto)</span>
          </button>
        </div>
        <div class="store-note mt-2">
          Una volta installata l'app aprire un ticket con la richiesta del attivazione facendo presente il vosto nikname inserito sul app <code></code>.<br>
        </div>
      </div>
    </div>
  </div>

  <!-- Playlist M3U personale -->
  <div class="col-12">
    <div class="card-glass">
      <div class="card-head"><i class="bi bi-music-note-list"></i> Playlist M3U personale</div>
      <div class="card-body">
        <?php if(!$canPlaylist): ?>
          <div class="alert alert-warning mb-3">
            Funzione disponibile solo se <strong>abilitata dall’amministratore</strong>.
          </div>
        <?php endif; ?>

        <form method="post" class="d-flex flex-wrap gap-2 mb-3">
          <input type="hidden" name="csrf" value="<?= h($_SESSION['csrf']) ?>">
          <button class="btn btn-primary" name="gen_user_playlist_token" <?= $canPlaylist ? '' : 'disabled' ?>>
            Genera / Rigenera token
          </button>
          <?php if($userToken): ?>
            <button class="btn btn-outline-danger" name="clear_user_playlist_token" <?= $canPlaylist ? '' : 'disabled' ?>>
              Revoca token
            </button>
          <?php endif; ?>
        </form>

        <?php if($userToken): ?>
          <?php
            $url_view = $base.'/client/playlist.php?token='.urlencode($userToken).'&download=0';
            $url_down = $base.'/client/playlist.php?token='.urlencode($userToken);
            $pretty_m3u  = $base.'/client/playlist/'.rawurlencode($userToken).'.m3u';
            $pretty_m3u8 = $base.'/client/playlist/'.rawurlencode($userToken).'.m3u8';
          ?>
          <div class="row g-2">
            <div class="col-12 col-md-6">
              <div class="input-group input-group-sm">
                <span class="input-group-text">Visualizza (browser)</span>
                <input type="text" class="form-control" readonly value="<?= h($url_view) ?>">
                <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('<?= h($url_view) ?>')">Copia</button>
                <a class="btn btn-outline-primary" target="_blank" rel="noopener" href="<?= h($url_view) ?>">Apri</a>
              </div>
            </div>
            <div class="col-12 col-md-6">
              <div class="input-group input-group-sm">
                <span class="input-group-text">Scarica (.m3u)</span>
                <input type="text" class="form-control" readonly value="<?= h($url_down) ?>">
                <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('<?= h($url_down) ?>')">Copia</button>
                <a class="btn btn-outline-success" href="<?= h($url_down) ?>">Scarica</a>
              </div>
            </div>
            <div class="col-12 col-md-6">
              <div class="input-group input-group-sm">
                <span class="input-group-text">Link .m3u (pulito)</span>
                <input type="text" class="form-control" readonly value="<?= h($pretty_m3u) ?>">
                <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('<?= h($pretty_m3u) ?>')">Copia</button>
                <a class="btn btn-outline-primary" target="_blank" rel="noopener" href="<?= h($pretty_m3u.'?download=0') ?>">Apri</a>
              </div>
            </div>
            <div class="col-12 col-md-6">
              <div class="input-group input-group-sm">
                <span class="input-group-text">Link .m3u8 (pulito)</span>
                <input type="text" class="form-control" readonly value="<?= h($pretty_m3u8) ?>">
                <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('<?= h($pretty_m3u8) ?>')">Copia</button>
                <a class="btn btn-outline-primary" target="_blank" rel="noopener" href="<?= h($pretty_m3u8.'?download=0') ?>">Apri</a>
              </div>
            </div>
          </div>
          <div class="small text-muted mt-2">
            Suggerimento: molte app IPTV preferiscono link che terminano in <code>.m3u</code> o <code>.m3u8</code>.
          </div>
        <?php else: ?>
          <div class="text-muted">Nessun token generato. Clicca “Genera / Rigenera token”.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<!-- ===== Pulsanti azione: SOLO qui in basso (sempre visibili) ===== -->
<div class="mt-3 d-flex gap-2 justify-content-end">
  <button class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#devicesModal" id="btnOpenDevices">
    <i class="bi bi-phone"></i> Dispositivi
  </button>
  <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#paymentsModal" id="btnOpenPayments">
    <i class="bi bi-receipt"></i> Pagamenti
  </button>
</div>

<!-- ======================= MODAL Dispositivi ======================= -->
<div class="modal fade" id="devicesModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><i class="bi bi-phone"></i> I tuoi dispositivi</h5>
        <button class="btn-close" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="csrfDevices" value="<?= h($_SESSION['csrf']) ?>">
        <div id="devLoading" class="text-center py-3">
          <div class="spinner-border" role="status"></div>
          <div class="small text-muted mt-2">Caricamento…</div>
        </div>
        <div id="devEmpty" class="alert alert-info d-none">Nessun dispositivo registrato.</div>
        <div class="table-responsive d-none" id="devTableWrap">
          <table class="table table-sm align-middle">
            <thead>
              <tr>
                <th style="width:50%;">Dispositivo</th>
                <th style="width:30%;">IP</th>
                <th style="width:20%;">Azione</th>
              </tr>
            </thead>
            <tbody id="devBody"></tbody>
          </table>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Chiudi</button>
      </div>
    </div>
  </div>
</div>

<!-- ======================= MODAL Pagamenti ======================= -->
<div class="modal fade" id="paymentsModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><i class="bi bi-receipt"></i> Storico pagamenti</h5>
        <button class="btn-close" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <div class="modal-body">
        <div id="payLoading" class="text-center py-3">
          <div class="spinner-border" role="status"></div>
          <div class="small text-muted mt-2">Caricamento…</div>
        </div>
        <div id="payEmpty" class="alert alert-info d-none">Non risultano pagamenti.</div>
        <div class="table-responsive d-none" id="payTableWrap">
          <table class="table table-sm align-middle">
            <thead>
              <tr>
                <th>Data</th>
                <th>Importo</th>
                <th>Metodo</th>
                <th>Stato</th>
                <th>Periodo</th>
                <th>ID</th>
              </tr>
            </thead>
            <tbody id="payBody"></tbody>
          </table>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Chiudi</button>
      </div>
    </div>
  </div>
</div>

<!-- ======================= MODAL iOS WIP ======================= -->
<div class="modal fade" id="iosWipModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><i class="bi bi-apple"></i> App iOS</h5>
        <button class="btn-close" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <div class="modal-body">
        <p class="mb-1 fw-bold">Work in progress 🚧</p>
        <p class="mb-0 text-muted">La versione iOS non è ancora disponibile. Torna a trovarci a breve: pubblicheremo qui il link all’App Store.</p>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" data-bs-dismiss="modal">Ok</button>
      </div>
    </div>
  </div>
</div>

<script>
function td(text){ const el=document.createElement('td'); el.textContent = text??''; return el; }
function fmtAmount(a, c){ const n = Number(a); if(!isFinite(n)) return '-'; const cur = (c||'').toUpperCase(); const sym = cur==='EUR' ? '€' : cur==='USD' ? '$' : cur; return (sym? sym+' ':'') + n.toFixed(2); }
function fmtPeriod(from, to){
  if(!from && !to) return '—';
  const f = from ? new Date(from.replace(' ','T')) : null;
  const t = to   ? new Date(to.replace(' ','T'))   : null;
  const fStr = f ? f.toLocaleDateString() : '—';
  const tStr = t ? t.toLocaleDateString() : '—';
  return fStr + ' → ' + tStr;
}
async function copyToClipboard(text){
  try{
    if(navigator.clipboard && window.isSecureContext){
      await navigator.clipboard.writeText(text);
    }else{
      const ta=document.createElement('textarea'); ta.value=text; document.body.appendChild(ta);
      ta.select(); document.execCommand('copy'); ta.remove();
    }
  }catch(e){
    prompt('Copia manualmente questo testo:', text);
  }
}

/* ===== Dispositivi ===== */
async function unlinkDevice(id){
  const csrf = document.getElementById('csrfDevices')?.value || '';
  const res = await fetch('/client/api_user_device_unlink.php', {
    method: 'POST',
    headers: {'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'},
    body: new URLSearchParams({ id: String(id), csrf })
  });
  if(!res.ok) throw new Error('http '+res.status);
  const j = await res.json();
  if(!j.ok) throw new Error(j.error || 'Operazione non riuscita');
  if (j.self) { window.location.href = '/auth/logout.php'; return false; }
  return true;
}

document.getElementById('devicesModal')?.addEventListener('shown.bs.modal', async ()=>{
  const wrp = document.getElementById('devTableWrap');
  const body= document.getElementById('devBody');
  const load= document.getElementById('devLoading');
  const empty= document.getElementById('devEmpty');
  wrp.classList.add('d-none'); empty.classList.add('d-none'); load.classList.remove('d-none');
  body.innerHTML='';
  try{
    const r = await fetch('/client/api_user_devices.php', {cache:'no-store'});
    if(!r.ok) throw new Error('http '+r.status);
    const j = await r.json();
    const items = Array.isArray(j.items) ? j.items : [];

    if(items.length===0){ empty.classList.remove('d-none'); }
    else{
      wrp.classList.remove('d-none');
      for(const it of items){
        const tr = document.createElement('tr');

        // Nome dispositivo + badge "Questo dispositivo"
        const tdDev = document.createElement('td');
        const name = document.createElement('div');
        name.textContent = it.device_name || 'Dispositivo';
        tdDev.appendChild(name);

        if (it.is_current === true) {
          const badge = document.createElement('span');
          badge.className = 'pill-me mt-1';
          badge.innerHTML = '<span class="bi bi-dot"></span> Questo dispositivo';
          tdDev.appendChild(document.createElement('br'));
          tdDev.appendChild(badge);
          tr.classList.add('table-success');
        }
        tr.appendChild(tdDev);

        // IP
        tr.appendChild(td(it.ip || '—'));

        // Azione
        const tdAct = document.createElement('td');
        const btn = document.createElement('button');
        btn.className = 'btn btn-sm ' + (it.is_current ? 'btn-outline-secondary' : 'btn-outline-danger');
        btn.textContent = it.is_current ? 'In uso' : 'Dissocia';
        btn.disabled = !!it.is_current;
        if (!it.is_current) {
          btn.addEventListener('click', async ()=>{
            if(!confirm('Dissociare questo dispositivo?')) return;
            btn.disabled = true;
            try{
              const ok = await unlinkDevice(it.id);
              if (ok) {
                tr.remove();
                if(!body.querySelector('tr')) { wrp.classList.add('d-none'); empty.classList.remove('d-none'); }
              }
            }catch(e){
              alert(e.message || 'Errore durante la dissociazione.');
            }finally{
              btn.disabled = false;
            }
          });
        }
        tdAct.appendChild(btn);
        tr.appendChild(tdAct);

        body.appendChild(tr);
      }
    }
  }catch(e){
    empty.textContent = 'Impossibile caricare i dispositivi.';
    empty.classList.remove('d-none');
  }finally{
    load.classList.add('d-none');
  }
});

/* ===== Pagamenti ===== */
document.getElementById('paymentsModal')?.addEventListener('shown.bs.modal', async ()=>{
  const wrp = document.getElementById('payTableWrap');
  const body= document.getElementById('payBody');
  const load= document.getElementById('payLoading');
  const empty= document.getElementById('payEmpty');
  wrp.classList.add('d-none'); empty.classList.add('d-none'); load.classList.remove('d-none');
  body.innerHTML='';
  try{
    const r = await fetch('/client/api_user_payments.php', {cache:'no-store'});
    if(!r.ok) throw new Error('http '+r.status);
    const j = await r.json();
    const items = (j && j.items) ? j.items : [];
    if(items.length===0){ empty.classList.remove('d-none'); }
    else{
      wrp.classList.remove('d-none');
      for(const it of items){
        const tr = document.createElement('tr');
        tr.appendChild(td(it.created_at));
        tr.appendChild(td(fmtAmount(it.amount, it.currency)));
        tr.appendChild(td(it.method || '—'));
        tr.appendChild(td((it.status||'').toUpperCase()));
        tr.appendChild(td(fmtPeriod(it.period_from, it.period_to)));
        tr.appendChild(td(it.id ? String(it.id) : '—'));
        body.appendChild(tr);
      }
    }
  }catch(e){ empty.classList.add('d-none'); }
  finally{ load.classList.add('d-none'); }
});

/* Apri automaticamente i modal se si arriva con #devices o #payments */
document.addEventListener('DOMContentLoaded', ()=>{
  const h = (location.hash || '').toLowerCase();
  if (h === '#devices') document.getElementById('btnOpenDevices')?.click();
  if (h === '#payments') document.getElementById('btnOpenPayments')?.click();
});
</script>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
