<?php
// schedule.php  Palinsesto (hero visibile in box solido + loghi robusti)
if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset','UTF-8'); mb_internal_encoding('UTF-8');
error_reporting(E_ALL); ini_set('display_errors','0');

/* Helpers */
function include_first(array $paths){ foreach ($paths as $p) if (is_file($p)) { require_once $p; return $p; } return null; }
function absolute_url($p){ if(!$p) return ''; if(preg_match('#^https?://#i',$p)) return $p; return ($p[0]==='/'?$p:'/'.$p); }
function local_file_exists($url){
  if(!$url) return false;
  if(preg_match('#^https?://#i',$url)) return true;
  $docroot=rtrim($_SERVER['DOCUMENT_ROOT']??'','/'); if($docroot==='') return true;
  return is_file($docroot.absolute_url($url));
}
function resolve_logo($slug,$dbPath,$map){
  $cand = $dbPath ?: ($map[$slug] ?? ''); $cand = absolute_url($cand);
  if(!local_file_exists($cand)) $cand = absolute_url($map[$slug] ?? '');
  return $cand;
}

/* Config + header/footer */
include_first([__DIR__.'/config.php', __DIR__.'/../config.php', __DIR__.'/../../config.php']);
$page_title='Palinsesto';
include_first([__DIR__.'/partials/header.php', __DIR__.'/../partials/header.php', __DIR__.'/../../partials/header.php']);

/* Competizioni mostrate */
$WHITELIST=['serie-a','serie-b','serie-c','champions-league','europa-league','conference-league','motogp','formula-1'];
$DEFAULT_LOGO=[
  'serie-a'=>'/uploads/competitions/serie-a.png',
  'serie-b'=>'/uploads/competitions/serie-b.png',
  'serie-c'=>'/uploads/competitions/serie-c.png',
  'champions-league'=>'/uploads/competitions/champions-league.png',
  'europa-league'=>'/uploads/competitions/europa-league.png',
  'conference-league'=>'/uploads/competitions/conference-league.png',
  'motogp'=>'/uploads/competitions/motogp.png',
  'formula-1'=>'/uploads/competitions/f1.png',
];

/* Dati card */
$cards=[];
try{
  if(isset($pdo) && $pdo instanceof PDO){
    $in=implode(',',array_fill(0,count($WHITELIST),'?'));
    $st=$pdo->prepare("SELECT name,slug,image_path FROM categories WHERE slug IN ($in)");
    $st->execute($WHITELIST);
    $rows=$st->fetchAll(PDO::FETCH_ASSOC); $by=[]; foreach($rows as $r){ $by[$r['slug']]=$r; }
    foreach($WHITELIST as $slug){
      $db=$by[$slug]??null;
      $cards[]=[
        'name'=>$db['name']??ucwords(str_replace('-',' ',$slug)),
        'logo'=>resolve_logo($slug,$db['image_path']??'',$DEFAULT_LOGO),
        'desc'=>'Trasmissione di tutti gli eventi di questa competizione.',
      ];
    }
  }else{
    foreach($WHITELIST as $slug){
      $cards[]=['name'=>ucwords(str_replace('-',' ',$slug)),'logo'=>absolute_url($DEFAULT_LOGO[$slug]??''),'desc'=>'Trasmissione di tutti gli eventi di questa competizione.'];
    }
  }
}catch(Throwable $e){
  foreach($WHITELIST as $slug){
    $cards[]=['name'=>ucwords(str_replace('-',' ',$slug)),'logo'=>absolute_url($DEFAULT_LOGO[$slug]??''),'desc'=>'Trasmissione di tutti gli eventi di questa competizione.'];
  }
}

/* Base URL per retry double-slash */
$scheme=(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off')?'https':'http';
$host=$_SERVER['HTTP_HOST']??''; $BASE=$scheme.'://'.$host;
?>
<style>
  /* ===== Fascia introduttiva in box SOLIDO ===== */
  .hero-card{
    max-width: 1100px;
    margin: 24px auto 6px;
    background: #f8f9fa;                 /* solido (light) */
    color: #6c757d;                       /* grigio leggibile */
    border: 1px solid #e5e7eb;
    border-radius: 14px;
    box-shadow: 0 10px 24px rgba(0,0,0,.08);
    padding: 16px 18px;
    text-align: center;
  }
  .hero-card *{
    color: inherit !important;            /* ignora gradienti globali */
    -webkit-text-fill-color: currentColor !important;
    background: none !important;
    -webkit-background-clip: initial !important;
    background-clip: initial !important;
    text-shadow: none !important;
    opacity: 1 !important;
    filter: none !important;
    mix-blend-mode: normal !important;
  }
  .hero-card .lead{ font-weight: 800; }

  @media (prefers-color-scheme: dark){
    .hero-card{
      background: #1f2328;               /* solido (dark) */
      color: #ffffff;
      border-color: #2b3036;
      box-shadow: 0 10px 30px rgba(0,0,0,.35);
    }
  }

  /* ===== Griglia ===== */
  .comp-grid{ display:grid; gap:22px; grid-template-columns:repeat(4,minmax(0,1fr));
    margin:22px auto 40px; max-width:1200px; padding:0 12px; }
  @media (max-width:1200px){ .comp-grid{ grid-template-columns:repeat(3,1fr);} }
  @media (max-width:768px){  .comp-grid{ grid-template-columns:repeat(2,1fr);} }
  @media (max-width:520px){  .comp-grid{ grid-template-columns:1fr;} }

  .comp-card{ display:flex; flex-direction:column; height:100%;
    background:#ffffffcc; border:1px solid rgba(0,0,0,.06); border-radius:16px;
    box-shadow:0 10px 24px rgba(0,0,0,.08); transition:transform .2s,box-shadow .2s,border-color .2s;
    text-decoration:none; color:inherit; overflow:hidden; cursor:default; }
  .comp-card:hover{ transform:translateY(-2px); box-shadow:0 14px 28px rgba(0,0,0,.10); border-color:rgba(0,0,0,.12); }
  @media (prefers-color-scheme: dark){
    .comp-card{ background:rgba(20,23,28,.55); border-color:rgba(255,255,255,.14);
      box-shadow:0 10px 30px rgba(0,0,0,.35); backdrop-filter:blur(8px); -webkit-backdrop-filter:blur(8px); }
    .comp-card:hover{ border-color:rgba(255,255,255,.22); }
  }
  .comp-media{ display:flex; align-items:center; justify-content:center;
    height:140px; background:#f3f5f8; border-bottom:1px solid rgba(0,0,0,.06); }
  .comp-media img{ max-height:90px; max-width:90%; object-fit:contain; }
  @media (prefers-color-scheme: dark){
    .comp-media{ background:rgba(255,255,255,.06); border-bottom-color:rgba(255,255,255,.14); }
  }
  .comp-body{ padding:16px; text-align:center; }
  .comp-title{ font-weight:700; margin-bottom:6px; color:#111; }
  .comp-desc{ color:#6b7687; }
  @media (prefers-color-scheme: dark){ .comp-title{ color:#fff; } .comp-desc{ color:#b9c3d3; } }
</style>

<div class="container">
  <!-- HERO: ora  sempre visibile perch sta in un box con sfondo solido -->
  <div class="hero-card" role="region" aria-label="Informazioni palinsesto">
    <p>Offriamo la trasmissione in diretta di tutte le principali competizioni sportive che vedi qui sotto.</p>
    <p class="lead">I canali sono attivati <strong>almeno 30 minuti prima</strong> dell&rsquo;inizio dell&rsquo;evento.</p>
    <p>Non perderti neanche un&rsquo;azione!</p>
  </div>

  <div class="comp-grid">
    <?php foreach($cards as $c):
      $path=$c['logo']; $src=preg_match('#^https?://#',$path)?$path:$BASE.$path;
      $srcDS=preg_match('#^https?://#',$path)?$path:$BASE.'//'.ltrim($path,'/');
    ?>
    <div class="comp-card" role="group" aria-label="<?= htmlspecialchars($c['name']) ?>">
      <div class="comp-media">
        <?php if(!empty($path)): ?>
          <img src="<?= htmlspecialchars($src) ?>"
               alt="Logo <?= htmlspecialchars($c['name']) ?>"
               data-fallback="<?= htmlspecialchars($srcDS) ?>">
        <?php else: ?>
          <div class="text-muted">Logo non disponibile</div>
        <?php endif; ?>
      </div>
      <div class="comp-body">
        <div class="comp-title"><?= htmlspecialchars($c['name']) ?></div>
        <div class="comp-desc small"><?= htmlspecialchars($c['desc']) ?></div>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
</div>

<script>
// Retry "double-slash" per loghi che non caricano con path normale
document.querySelectorAll('img[data-fallback]').forEach(function(img){
  img.addEventListener('error', function handler(){
    const fb = img.getAttribute('data-fallback');
    if (fb && img.src !== fb) { img.src = fb; img.setAttribute('data-fallback',''); }
    else {
      img.removeEventListener('error', handler);
      img.style.display='none';
      const holder=document.createElement('div');
      holder.className='text-muted small';
      holder.textContent='Logo non disponibile';
      img.closest('.comp-media').appendChild(holder);
    }
  });
});
</script>

<?php include_first([__DIR__.'/partials/footer.php', __DIR__.'/../partials/footer.php', __DIR__.'/../../partials/footer.php']); ?>
