<?php
// /client/ticket.php
$page_title = 'Supporto & Ticket';
require_once __DIR__.'/../partials/authguard.php';

if (!headers_sent()) header('Content-Type: text/html; charset=UTF-8');
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

/* ------------ flash helpers ------------ */
function set_flash(string $type, string $msg): void { $_SESSION['flash'] = ['type'=>$type,'msg'=>$msg]; }
function pop_flash(): ?array { $f = $_SESSION['flash'] ?? null; unset($_SESSION['flash']); return $f; }

/* ------------ settings / schema ------------ */
function get_setting($pdo,$k,$def=null){
  $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?"); $st->execute([$k]); $r=$st->fetch();
  return $r ? $r['value'] : $def;
}
function default_schema(): array {
  return [
    ['name'=>'category','label'=>'Categoria','type'=>'select','required'=>true,'options'=>['Supporto tecnico','Pagamenti','Richiesta canali','Altro']],
    ['name'=>'priority','label'=>'Priorità','type'=>'select','required'=>true,'options'=>['Bassa','Media','Alta']],
    ['name'=>'subject','label'=>'Oggetto','type'=>'text','required'=>true],
    ['name'=>'message','label'=>'Messaggio','type'=>'textarea','required'=>true,'rows'=>6],
  ];
}
function load_schema($pdo): array {
  $json = get_setting($pdo,'ticket_form_schema',''); $arr = json_decode($json,true);
  return (is_array($arr) && $arr) ? $arr : default_schema();
}

/* ------------ render field ------------ */
function render_field($f, $old=[]){
  $name = $f['name']; $label = $f['label'] ?? $name; $type = $f['type'] ?? 'text';
  $req  = !empty($f['required']); $val = $old[$name] ?? ''; $reqAttr = $req?'required':'';
  if ($type==='textarea'){
    $rows=(int)($f['rows']??5);
    echo '<div class="mb-3"><label class="form-label">'.h($label).'</label>';
    echo '<textarea class="form-control" name="fields['.h($name).']" rows="'.$rows.'" '.$reqAttr.'>'.h($val).'</textarea></div>';
  } elseif ($type==='select'){
    $opts=(array)($f['options']??[]);
    echo '<div class="mb-3"><label class="form-label">'.h($label).'</label><select class="form-select" name="fields['.h($name).']" '.$reqAttr.'>';
    echo '<option value="">Seleziona…</option>';
    foreach($opts as $o){ $sel=($val===$o)?'selected':''; echo '<option '.$sel.' value="'.h($o).'">'.h($o).'</option>'; }
    echo '</select></div>';
  } else {
    echo '<div class="mb-3"><label class="form-label">'.h($label).'</label>';
    echo '<input class="form-control" type="text" name="fields['.h($name).']" value="'.h($val).'" '.$reqAttr.'></div>';
  }
}

/* ------------ POST (prima dell'header!) ------------ */
$schema = load_schema($pdo);
$uid = (int)($_SESSION['user']['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD']==='POST'){

  // Nuovo ticket
  if (isset($_POST['create']) && $uid){
    $fields = $_POST['fields'] ?? [];
    $error = '';
    foreach($schema as $f){
      if(!empty($f['required'])){
        $n=$f['name']; if(trim((string)($fields[$n]??''))===''){ $error='Compila tutti i campi obbligatori.'; break; }
      }
    }
    if($error){
      set_flash('danger',$error);
      header('Location: /client/ticket.php'); exit;
    }

    $subject = trim((string)($fields['subject'] ?? ''));
    if($subject===''){
      $subject = trim(($fields['category'] ?? '').' - '.mb_strimwidth((string)($fields['message']??''),0,60,'…'));
    }
    $priority = (string)($fields['priority'] ?? 'Media');

    $pdo->beginTransaction();
    $pdo->prepare("INSERT INTO tickets (user_id,subject,status,priority,form_json,created_at,updated_at)
                   VALUES (?,?,?,?,?,NOW(),NOW())")
        ->execute([$uid,$subject,'open',$priority,json_encode($fields,JSON_UNESCAPED_UNICODE)]);
    $tid = (int)$pdo->lastInsertId();
    $lines=[]; foreach($schema as $f){ $n=$f['name']; $lab=$f['label'] ?? $n; $val=trim((string)($fields[$n]??'')); if($val!=='') $lines[]="$lab: $val"; }
    $pdo->prepare("INSERT INTO ticket_messages (ticket_id,sender,message,created_at) VALUES (?,?,?,NOW())")
        ->execute([$tid,'user',implode("\n",$lines)]);
    $pdo->commit();

    set_flash('success','Ticket inviato! Ti risponderemo al più presto.');
    header('Location: /client/ticket.php'); // torna alla lista
    exit;
  }

  // Risposta su ticket proprio
  if (isset($_POST['reply']) && $uid){
    $tid = (int)$_POST['ticket_id'];
    $msg = trim((string)($_POST['message'] ?? ''));
    if($msg!==''){
      $st=$pdo->prepare("SELECT id FROM tickets WHERE id=? AND user_id=?"); $st->execute([$tid,$uid]);
      if($st->fetch()){
        $pdo->beginTransaction();
        $pdo->prepare("INSERT INTO ticket_messages (ticket_id,sender,message,created_at) VALUES (?,?,?,NOW())")
            ->execute([$tid,'user',$msg]);
        $pdo->prepare("UPDATE tickets SET status=IF(status='closed','open',status), updated_at=NOW(), last_user_reply_at=NOW() WHERE id=?")
            ->execute([$tid]);
        $pdo->commit();
        set_flash('success','Messaggio inviato.');
        header('Location: /client/ticket.php?view='.$tid.'#fine'); exit;
      }
    }
    set_flash('danger','Messaggio non valido.');
    header('Location: /client/ticket.php'); exit;
  }
}

/* ------------ vista ------------ */
$view = isset($_GET['view']) ? (int)$_GET['view'] : 0;
$tk=null;
if($view){
  $st=$pdo->prepare("SELECT * FROM tickets WHERE id=? AND user_id=?"); $st->execute([$view,$uid]); $tk=$st->fetch();
  if(!$tk) $view=0;
}

require_once __DIR__.'/../partials/header.php';
$flash = pop_flash();
?>
<style>
  .twrap{ max-width:1000px; margin: 18px auto; }
  .tcard{ background:var(--body-bg,#fff); border:1px solid rgba(0,0,0,.08); border-radius:12px; padding:14px; }
  html[data-theme="dark"] .tcard{ background:#121416; border-color: rgba(255,255,255,.12); }
  .badge-open{ background:#0d6efd; } .badge-pending{ background:#ffc107; color:#000; } .badge-closed{ background:#6c757d; }
  .msg{ border-radius:12px; padding:10px 12px; margin-bottom:10px; border:1px solid rgba(0,0,0,.06);}
  .msg.user{ background: rgba(13,110,253,.07); }
  .msg.admin{ background: rgba(25,135,84,.09); }
  .muted{ color:#6c757d; }

  /* flash centrale */
  .flash-center{ position:fixed; inset:0; display:flex; align-items:center; justify-content:center; background:rgba(0,0,0,.35); z-index:2000; }
  .flash-card{ background:var(--modal-bg,#fff); color:var(--modal-text,#222); border-radius:18px; padding:18px 22px; text-align:center; min-width:260px; box-shadow:0 20px 60px rgba(0,0,0,.35); }
  .flash-card .bi{ font-size:2rem; display:block; margin-bottom:.25rem; }
</style>

<?php if($flash): ?>
  <div class="flash-center" id="flashCenter" role="status" aria-live="polite">
    <div class="flash-card">
      <?php if($flash['type']==='success'): ?><i class="bi bi-check-circle-fill"></i>
      <?php else: ?><i class="bi bi-exclamation-triangle-fill"></i><?php endif; ?>
      <div class="fw-bold"><?= h($flash['msg']) ?></div>
    </div>
  </div>
  <script> setTimeout(()=>document.getElementById('flashCenter')?.remove(), 1600); </script>
<?php endif; ?>

<div class="twrap container">
  <h4 class="mb-3">Assistenza & Ticket</h4>

  <?php if($view && $tk): ?>
    <div class="tcard mb-3">
      <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
        <div><strong>#<?= (int)$tk['id'] ?></strong> — <?= h($tk['subject']) ?></div>
        <div class="d-flex align-items-center gap-2">
          <span class="badge <?= $tk['status']==='closed'?'badge-closed':($tk['status']==='pending'?'badge-pending':'badge-open') ?>"><?= h(strtoupper($tk['status'])) ?></span>
          <span class="badge text-bg-secondary"><?= h($tk['priority']) ?></span>
        </div>
      </div>
      <hr>
      <?php
        $ms=$pdo->prepare("SELECT * FROM ticket_messages WHERE ticket_id=? ORDER BY id ASC");
        $ms->execute([(int)$tk['id']]);
        foreach($ms as $m):
      ?>
        <div class="msg <?= $m['sender']==='admin'?'admin':'user' ?>">
          <div class="small muted mb-1"><?= h($m['sender']==='admin'?'Staff':'Tu') ?> — <?= h($m['created_at']) ?></div>
          <div style="white-space:pre-wrap"><?= h($m['message']) ?></div>
        </div>
      <?php endforeach; ?>

      <?php if($tk['status']!=='closed'): ?>
        <form method="post" class="mt-3">
          <input type="hidden" name="ticket_id" value="<?= (int)$tk['id'] ?>">
          <label class="form-label">Rispondi</label>
          <textarea class="form-control mb-2" name="message" rows="4" required></textarea>
          <button class="btn btn-primary" name="reply">Invia</button>
          <a class="btn btn-outline-secondary" href="/client/ticket.php">Torna alla lista</a>
        </form>
      <?php else: ?>
        <a class="btn btn-outline-secondary mt-2" href="/client/ticket.php">Torna alla lista</a>
      <?php endif; ?>
      <div id="fine"></div>
    </div>
  <?php else: ?>
    <div class="tcard mb-3">
      <h5 class="mb-2">Apri un nuovo ticket</h5>
      <form method="post">
        <?php foreach($schema as $field) render_field($field, $_POST['fields'] ?? []); ?>
        <button class="btn btn-primary" name="create">Invia</button>
      </form>
    </div>

    <div class="tcard">
      <h5 class="mb-2">I miei ticket</h5>
      <table class="table table-sm align-middle">
        <thead><tr><th style="width:80px">ID</th><th>Oggetto</th><th style="width:120px">Stato</th><th style="width:110px">Priorità</th><th style="width:170px">Aggiornato</th><th style="width:90px"></th></tr></thead>
        <tbody>
        <?php
          $st=$pdo->prepare("SELECT * FROM tickets WHERE user_id=? ORDER BY updated_at DESC");
          $st->execute([$uid]);
          foreach($st as $t):
        ?>
          <tr>
            <td><?= (int)$t['id'] ?></td>
            <td><?= h($t['subject']) ?></td>
            <td><span class="badge <?= $t['status']==='closed'?'badge-closed':($t['status']==='pending'?'badge-pending':'badge-open') ?>"><?= h($t['status']) ?></span></td>
            <td><?= h($t['priority']) ?></td>
            <td><?= h($t['updated_at']) ?></td>
            <td><a class="btn btn-outline-primary btn-sm" href="/client/ticket.php?view=<?= (int)$t['id'] ?>">Apri</a></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__.'/../partials/footer.php'; ?>
