<?php
// config.php
session_start();

// --- (facoltativo in debug) ---
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

header('Content-Type: text/html; charset=UTF-8');
ini_set('default_charset', 'UTF-8');
date_default_timezone_set('Europe/Rome');

/* ========= CREDENZIALI DB ========= */
$DB_HOST = 'localhost';
$DB_NAME = 'dsirhost_play';
$DB_USER = 'dsirhost_play';
$DB_PASS = 'gzT#xDWpA~_sF-m=';

/* ========= CONNESSIONE PDO UTF8MB4 ========= */
$dsn = "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4";

try {
    $pdo = new PDO(
        $dsn,
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ]
    );
} catch (PDOException $e) {
    http_response_code(500);
    exit('Errore connessione DB');
}

/* ========= UTILITY DI BASE ========= */
function is_mobile(): bool {
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    return (bool) preg_match('/Android|iPhone|iPad|iPod|Mobile/i', $ua);
}

function require_login(): void {
    if (empty($_SESSION['user'])) {
        header('Location: /auth/login.php');
        exit;
    }
}

function require_admin(): void {
    require_login();
    if (($_SESSION['user']['role'] ?? '') !== 'admin') {
        http_response_code(403);
        exit('Accesso negato');
    }
}

/* ========= ABBONAMENTI =========
   Se non l'hai gi fatto, una tantum puoi eseguire:
   ALTER TABLE users ADD COLUMN subscription_expires_at DATETIME NULL;
   (oppure usa la colonna legacy 'subscription_until')
*/

/**
 * Ricarica lutente loggato dal DB ad ogni richiesta,
 * supportando sia 'subscription_expires_at' che la legacy 'subscription_until'.
 * Unifica in sessione i due campi cos le altre funzioni possono leggerli indifferentemente.
 */
function user_refresh_from_db(PDO $pdo): void {
    if (empty($_SESSION['user']['id'])) return;
    $id = (int) $_SESSION['user']['id'];

    // Proviamo a leggere entrambe le colonne (o il massimo disponibile)
    $tries = [
        // entrambe le colonne
        "SELECT id,email,role,created_at,remember_token,
                subscription_expires_at, subscription_until
         FROM users WHERE id=?",

        // solo expires_at
        "SELECT id,email,role,created_at,remember_token,
                subscription_expires_at, NULL AS subscription_until
         FROM users WHERE id=?",

        // solo until (mappata anche come expires_at)
        "SELECT id,email,role,created_at,remember_token,
                subscription_until AS subscription_expires_at,
                subscription_until
         FROM users WHERE id=?",
    ];

    foreach ($tries as $sql) {
        try {
            $st = $pdo->prepare($sql);
            $st->execute([$id]);
            if ($row = $st->fetch()) {
                // Unifica i due campi
                if (empty($row['subscription_expires_at']) && !empty($row['subscription_until'])) {
                    $row['subscription_expires_at'] = $row['subscription_until'];
                }
                if (empty($row['subscription_until']) && !empty($row['subscription_expires_at'])) {
                    $row['subscription_until'] = $row['subscription_expires_at'];
                }
                $_SESSION['user'] = array_merge($_SESSION['user'] ?? [], $row);
                return;
            } else {
                // Utente eliminato -> logout
                session_unset();
                session_destroy();
                header('Location: /auth/login.php');
                exit;
            }
        } catch (PDOException $e) {
            // Se  "colonna sconosciuta" (42S22) prova il prossimo SQL
            if ($e->getCode() === '42S22') continue;
            // altri errori: lascia invariata la sessione
        }
    }
}

/** True se lutente ha un abbonamento valido oppure  admin. */
function user_is_subscribed(): bool {
    // Admin bypassano il paywall
    if (($_SESSION['user']['role'] ?? '') === 'admin') return true;

    // Leggi la scadenza da uno dei due campi in sessione
    $exp = $_SESSION['user']['subscription_expires_at']
        ?? $_SESSION['user']['subscription_until']
        ?? null;

    if (!$exp) return false;

    $ts = strtotime($exp);
    if ($ts === false) return false;

    return $ts > time();
}

/**
 * Paywall: se non abbonato reindirizza a /pricing.php
 * mantenendo la pagina di ritorno nel parametro ?r=
 */
function require_subscription(string $pricing_url = '/pricing.php'): void {
    require_login();
    if (!user_is_subscribed()) {
        $ret = $_SERVER['REQUEST_URI'] ?? '/';
        header('Location: ' . $pricing_url . '?r=' . urlencode($ret));
        exit;
    }
}

/* Aggiorna SEMPRE i dati utente in sessione ad ogni richiesta */
user_refresh_from_db($pdo);

/* ========= API (se le usi) ========= */
$API_FOOTBALL_KEY  = '232a87cf061a31358e3945e46573418b';
$API_FOOTBALL_HOST = 'v3.football.api-sports.io';
$API_F1_HOST       = 'v1.formula-1.api-sports.io';
$API_F1_KEY        = $API_FOOTBALL_KEY;

$LIVE_LEAGUE_IDS = [135, 136, 2, 3, 848]; // Serie A/B, UCL, EL, Conference
