<?php
// /partials/authguard.php
// Protegge pagine riservate, traccia device, e applica kill remoto via tabella user_device_kill.

require_once __DIR__ . '/../config.php';

if (!function_exists('safe_redirect')) {
  function safe_redirect(string $url): void {
    if (!headers_sent()) { header('Location: '.$url); exit; }
    echo '<meta http-equiv="refresh" content="0;url='.htmlspecialchars($url,ENT_QUOTES).'">';
    exit;
  }
}
if (!function_exists('current_url')) {
  function current_url(): string {
    $sch = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $uri  = $_SERVER['REQUEST_URI'] ?? '/';
    return $sch.'://'.$host.$uri;
  }
}

if (session_status() !== PHP_SESSION_ACTIVE) @session_start();

$require_admin        = $require_admin        ?? false;
$require_subscription = $require_subscription ?? false;

// login required
if (empty($_SESSION['user']) || empty($_SESSION['user']['id'])) {
  $ret = $_GET['r'] ?? current_url();
  safe_redirect('/auth/login.php?r='.urlencode($ret));
}

// opzionale: ricarica dati utente
try { if (function_exists('user_refresh_from_db')) user_refresh_from_db($pdo); } catch (Throwable $e) {}

// ==== TRACKING + KILL SWITCH ====
$uid = (int)($_SESSION['user']['id'] ?? 0);
if ($uid > 0) {
  require_once __DIR__.'/device_tracker.php';

  // 1) track device (mai bloccare se fallisce)
  try { if (function_exists('track_device')) track_device($pdo, $uid); } catch(Throwable $e){}

  // 2) kill remoto se presente in tabella user_device_kill
  try {
    // assicura tabella kill
    $pdo->exec("CREATE TABLE IF NOT EXISTS user_device_kill (
      id INT AUTO_INCREMENT PRIMARY KEY,
      user_id INT NOT NULL,
      device_key VARCHAR(128) NOT NULL,
      created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
      KEY idx_user_key (user_id, device_key)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

    // chiave corrente base (può essere 'dev_id' o fallback 'dk:...')
    $curBase = '';
    try { $curBase = dt_devkey_base(); } catch(Throwable $e){ $curBase = ''; }

    if ($curBase !== '') {
      // match sia la chiave esatta, sia le varianti "splittate" base~xxxx
      $st = $pdo->prepare("SELECT id FROM user_device_kill
                           WHERE user_id=? AND (device_key=? OR device_key LIKE CONCAT(?, '~%'))
                           LIMIT 1");
      $st->execute([$uid, $curBase, $curBase]);
      $killId = $st->fetchColumn();

      if ($killId) {
        // ripulisci kill entries per questo base (tutte) per evitare loop
        $del = $pdo->prepare("DELETE FROM user_device_kill WHERE user_id=? AND (device_key=? OR device_key LIKE CONCAT(?, '~%'))");
        $del->execute([$uid, $curBase, $curBase]);

        // invalida rememberme di questo device
        if (!empty($_COOKIE['rememberme'])) {
          setcookie('rememberme','', time()-3600, '/', '', !empty($_SERVER['HTTPS']), true);
        }
        // distruggi sessione PHP
        $_SESSION = [];
        if (session_status() === PHP_SESSION_ACTIVE) {
          if (ini_get('session.use_cookies')) {
            $p = session_get_cookie_params();
            setcookie(session_name(), '', time()-42000, $p['path'], $p['domain'] ?? '', !empty($_SERVER['HTTPS']), true);
          }
          session_destroy();
        }
        safe_redirect('/auth/login.php?err=remote_logout');
      }
    }
  } catch (Throwable $e) {
    // se qualcosa va storto, non bloccare l'utente
  }
}

// ==== Admin required? ====
if ($require_admin) {
  $role = (string)($_SESSION['user']['role'] ?? 'client');
  if ($role !== 'admin') { http_response_code(403); exit('Accesso negato'); }
}

// ==== Subscription required? (admins bypass) ====
if ($require_subscription) {
  try {
    $role = (string)($_SESSION['user']['role'] ?? 'client');
    if ($role !== 'admin') {
      if (function_exists('require_subscription')) {
        require_subscription('/client/pricing.php');
      } elseif (function_exists('user_is_subscribed')) {
        if (!user_is_subscribed()) {
          $ret = current_url();
          safe_redirect('/client/pricing.php?r='.urlencode($ret));
        }
      }
    }
  } catch (Throwable $e) {
    $ret = current_url();
    safe_redirect('/client/pricing.php?r='.urlencode($ret));
  }
}