<?php require_once __DIR__.'/../config.php'; ?>

<?php
// Badge "ASSISTENZA": numero ticket con risposta admin non ancora letta (solo clienti)
$support_badge_count = 0;
if (!empty($_SESSION['user']) && (($_SESSION['user']['role'] ?? '') !== 'admin')) {
  try {
    $st = $pdo->prepare("
      SELECT COUNT(*)
      FROM tickets
      WHERE user_id = ?
        AND status IN ('open','pending')
        AND last_admin_reply_at IS NOT NULL
        AND (last_user_reply_at IS NULL OR last_admin_reply_at > last_user_reply_at)
    ");
    $st->execute([(int)$_SESSION['user']['id']]);
    $support_badge_count = (int)$st->fetchColumn();
  } catch (Throwable $e) {
    $support_badge_count = 0;
  }
}

// Helper per nav "active"
$REQ = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';
function nav_active(string $pathPrefix): string {
  global $REQ;
  return (strpos($REQ, $pathPrefix) === 0) ? 'active' : '';
}
?>
<!doctype html>
<html lang="it" data-theme="auto">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= htmlspecialchars($page_title ?? 'Super Sport') ?></title>

<!-- Favicon -->
<link rel="icon" href="/balls-sports.ico" sizes="any" type="image/x-icon">

<!-- Tema: applica prima dei CSS -->
<script>
(function(){
  const KEY='site_theme_pref';
  function computeAuto(){ const h=(new Date()).getHours(); return (h>=7&&h<19)?'light':'dark'; }
  let pref='auto';
  try{ const s=localStorage.getItem(KEY); if(['auto','light','dark'].includes(s)) pref=s; }catch(e){}
  const effective=(pref==='auto')?computeAuto():pref;
  document.documentElement.setAttribute('data-theme', effective);
  try{ localStorage.setItem(KEY, pref); }catch(e){}
})();
</script>

<!-- CSS -->
<link rel="preconnect" href="https://cdn.jsdelivr.net">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/video.js@8.16.1/dist/video-js.min.css">

<style>
  :root{
    --topbar-bg:#f8f9fa; --topbar-text:#222; --topbar-link:#222; --topbar-link-muted:#6c757d;
    --topbar-border:rgba(0,0,0,.06); --body-bg:#ffffff; --body-text:#212529;
    --modal-bg:#ffffff; --modal-text:#212529; --modal-border:#e5e7eb;
    --chip-bg:rgba(0,0,0,.06); --chip-brd:rgba(0,0,0,.08);
    --hamburger-icon: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3E%3Cpath stroke='rgba(0,0,0,0.85)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E");
  }
  html[data-theme="dark"]{
    --topbar-bg:#202224; --topbar-text:#f3f6fb; --topbar-link:#ffffff; --topbar-link-muted:#cbd3e1;
    --topbar-border:rgba(255,255,255,.12); --body-bg:#0f1113; --body-text:#e9eef7;
    --modal-bg:#16181b; --modal-text:#e9eef7; --modal-border:#2a2e35;
    --chip-bg:rgba(255,255,255,.08); --chip-brd:rgba(255,255,255,.12);
    --hamburger-icon: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3E%3Cpath stroke='rgba(255,255,255,0.95)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E");
  }
  body{ background:var(--body-bg); color:var(--body-text); }

  /* Topbar */
  .topbar{ background:var(--topbar-bg); color:var(--topbar-text); border-bottom:1px solid var(--topbar-border); }
  .topbar .navbar-brand, .topbar .nav-link{ color:var(--topbar-link); font-weight:700; letter-spacing:.2px; }
  .topbar .nav-link .bi{ font-size:1.05rem; vertical-align:-2px; margin-right:.35rem; }
  .topbar .nav-link:hover{ opacity:.9; }
  .topbar .nav-link.muted{ color:var(--topbar-link-muted); font-weight:600; }
  .topbar .nav-link.active{ text-decoration: underline; text-underline-offset: .3rem; }
  .icon-btn{
    display:inline-flex; align-items:center; justify-content:center; width:36px; height:36px; border-radius:999px;
    border:1px solid var(--topbar-border); color:var(--topbar-link); background:transparent;
  }
  .icon-btn:hover{ background:rgba(127,127,127,.08); }

  .navbar-toggler{ border-color: var(--topbar-border); color: var(--topbar-link); background: transparent; }
  .navbar-toggler:focus{ box-shadow: 0 0 0 .15rem rgba(127,127,127,.25); }
  .navbar-toggler-icon{ background-image: var(--hamburger-icon) !important; }

  .brand-logo{ width:26px; height:26px; margin-right:.5rem; fill:currentColor; }
  .page-wrap{ padding-top:10px; }

  /* Modal ricerca */
  .search-modal .modal-content{ background:var(--modal-bg); color:var(--modal-text); border:1px solid var(--modal-border); }
  .search-modal .form-control{ background:transparent; color:var(--modal-text); border-color:var(--modal-border); }
  .search-modal .list-group-item{ background:transparent; color:var(--modal-text); border-color:var(--modal-border); }
  .result-thumb{ width:48px; height:48px; object-fit:cover; border-radius:8px; border:1px solid var(--modal-border); }
  .chip{
    display:inline-flex; gap:.4rem; align-items:center; padding:.15rem .5rem; border-radius:999px;
    background:var(--chip-bg); border:1px solid var(--chip-brd); font-size:.83rem; font-weight:600;
  }
  .muted{ color:var(--topbar-link-muted); }

  /* Badge su ASSISTENZA */
  .navbar-nav .nav-link.badged{ position: relative; padding-right: 1.5rem; }
  .notif-pill{
    position:absolute; top: .15rem; right: -.25rem;
    display:inline-flex; align-items:center; justify-content:center;
    height: 1.05rem; min-width: 1.05rem; padding: 0 .35rem;
    font-size: .65rem; line-height: 1; border-radius: 999px;
  }

  /* Menu centrato in desktop */
  @media (min-width: 992px){
    .topbar .container{ position: relative; }
    .topbar .center-nav{
      position: absolute;
      left: 50%;
      transform: translateX(-50%);
    }
  }

  img, video { -webkit-touch-callout: none; }
</style>
</head>
<body>

<!-- Disabilita menu contestuale ovunque -->
<script>
  document.addEventListener('contextmenu', function(e){ e.preventDefault(); }, {capture:true});
</script>

<nav class="navbar navbar-expand-lg topbar">
  <div class="container">

    <!-- Brand -->
    <a class="navbar-brand d-flex align-items-center" href="<?= ($_SESSION['user']['role']??'')==='admin' ? '/admin/index.php' : '/dashboard' ?>">
      <svg class="brand-logo" viewBox="0 0 24 24" aria-hidden="true">
        <path d="M12 2a10 10 0 1 0 10 10A10.011 10.011 0 0 0 12 2Zm5.93 6.62a7.99 7.99 0 0 1 .78 2.21c-1.57.59-3.27.48-4.7-.18a7.41 7.41 0 0 0 3.92-2.03ZM12 4a8 8 0 0 1 3.18.67 5.46 5.46 0 0 1-3.11 2.36A5.43 5.43 0 0 1 8.81 4.7 7.99 7.99 0 0 1 12 4ZM6.07 6.62A7.41 7.41 0 0 0 10 8.65c-1.43.66-3.13.77-4.7.18a7.99 7.99 0  0 1 .77-2.21ZM4.1 12a7.93 7.93 0 0 1 .19 1.73c1.89.7 3.97.6 5.75-.23a7.5 7.5 0 0 0 0 3.93C8.26 14.12 6.18 14.02 4.29 13.3A7.93 7.93 0 0 1 4.1 12Zm1.97 5.38a7.99 7.99 0  0 1-.77-2.21c1.57-.59 3.27-.48 4.7.18a7.41 7.41 0 0 0-3.93 2.03ZM12 20a8 8 0 0 1-3.19-.67 5.46 5.46 0 0 1 3.11-2.36 5.43 5.43 0 0 1 3.26 1.66A7.99 7.99 0 0 1 12 20Zm5.93-2.62a7.41 7.41 0 0 0-3.93-2.03c1.43-.66 3.13-.77 4.7-.18a7.99 7.99 0 0 1-.77 2.21ZM19.9 12a7.93 7.93 0 0 1-.19 1.73c-1.89-.71-3.97-.61-5.75.23a7.5 7.5 0 0 0 0-3.93c1.78.83 3.86.93 5.75.23.12.56.19 1.14.19 1.74Z"/>
      </svg>
      <span>Super Sport</span>
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#topbarNav" aria-controls="topbarNav" aria-expanded="false" aria-label="Menu">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="topbarNav">
      <!-- Menu centrato -->
      <ul class="navbar-nav center-nav align-items-lg-center">
        <li class="nav-item">
          <a class="nav-link <?= nav_active('/dashboard') ?>" href="/dashboard">
            <i class="bi bi-tv"></i> DIRETTE
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link <?= nav_active('/palinsesto') ?>" href="/palinsesto">
            <i class="bi bi-calendar-event"></i> PALINSESTO
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link muted <?= nav_active('/pricing') ?>" href="/pricing">
            <i class="bi bi-currency-dollar"></i> PREZZI
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link muted <?= nav_active('/ticket') ?> <?= $support_badge_count>0 ? 'badged' : '' ?>" href="/ticket">
            <i class="bi bi-headset"></i> ASSISTENZA
            <?php if ($support_badge_count > 0): ?>
              <span class="notif-pill bg-danger text-white">
                <?= $support_badge_count > 99 ? '99+' : $support_badge_count ?>
              </span>
            <?php endif; ?>
          </a>
        </li>
      </ul>

      <!-- Lato destro -->
      <div class="ms-auto d-flex align-items-center gap-2">
        <!-- Ricerca -->
        <button class="icon-btn" type="button" data-bs-toggle="modal" data-bs-target="#searchModal" title="Cerca">
          <i class="bi bi-search" aria-hidden="true"></i><span class="visually-hidden">Cerca</span>
        </button>

        <!-- Tema -->
        <button id="themeToggle" class="icon-btn" type="button" title="Tema: Auto">
          <i class="bi bi-circle-half" id="themeIcon" aria-hidden="true"></i>
          <span class="visually-hidden" id="themeSr">Tema: Auto</span>
        </button>

        <!-- Profilo / Login + Logout -->
        <?php if(!empty($_SESSION['user'])): ?>
          <a class="icon-btn text-decoration-none <?= nav_active('/profilo') ?>" href="/profilo" title="Profilo">
            <i class="bi bi-person-circle" aria-hidden="true"></i><span class="visually-hidden">Profilo</span>
          </a>
          <a class="icon-btn text-decoration-none" href="/logout" title="Logout">
            <i class="bi bi-box-arrow-right" aria-hidden="true"></i><span class="visually-hidden">Logout</span>
          </a>
        <?php else: ?>
          <a class="icon-btn text-decoration-none <?= nav_active('/login') ?>" href="/login" title="Accedi">
            <i class="bi bi-box-arrow-in-right" aria-hidden="true"></i><span class="visually-hidden">Accedi</span>
          </a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</nav>

<!-- Modal Ricerca Lives -->
<div class="modal fade search-modal" id="searchModal" tabindex="-1" aria-labelledby="searchTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="searchTitle">Cerca live</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Chiudi"></button>
      </div>
      <div class="modal-body">
        <div class="input-group mb-3">
          <span class="input-group-text"><i class="bi bi-search"></i></span>
          <input type="search" class="form-control" id="liveSearchInput" placeholder="Digita il nome della live&hellip;">
        </div>

        <div id="searchHint" class="text-center muted py-2">Inizia a digitare per cercare&hellip;</div>
        <div id="searchSpinner" class="text-center py-2 d-none">
          <div class="spinner-border" role="status" aria-hidden="true"></div>
          <div class="mt-2 muted">Cerco&hellip;</div>
        </div>

        <div id="searchResults" class="list-group list-group-flush"></div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-outline-secondary" data-bs-dismiss="modal">Chiudi</button>
      </div>
    </div>
  </div>
</div>

<div class="container page-wrap mb-4">

<script>
/* Toggle Tema (Auto  Light  Dark) */
(function(){
  const KEY='site_theme_pref', ROOT=document.documentElement, btn=document.getElementById('themeToggle'),
        ico=document.getElementById('themeIcon'), sr=document.getElementById('themeSr');
  function computeAuto(){ const h=(new Date()).getHours(); return (h>=7&&h<19)?'light':'dark'; }
  function apply(pref){
    const eff=(pref==='auto')?computeAuto():pref;
    ROOT.setAttribute('data-theme', eff);
    try{ localStorage.setItem(KEY,pref); }catch(e){}
    if(pref==='auto'){ ico.className='bi bi-circle-half'; btn.title='Tema: Auto'; sr.textContent='Tema: Auto'; }
    else if(pref==='light'){ ico.className='bi bi-sun-fill'; btn.title='Tema: Chiaro'; sr.textContent='Tema: Chiaro'; }
    else { ico.className='bi bi-moon-stars-fill'; btn.title='Tema: Scuro'; sr.textContent='Tema: Scuro'; }
  }
  function next(pref){ return pref==='auto'?'light':(pref==='light'?'dark':'auto'); }
  let pref='auto'; try{ const s=localStorage.getItem(KEY); if(['auto','light','dark'].includes(s)) pref=s; }catch(e){}
  apply(pref);
  if(btn){ btn.addEventListener('click', ()=>{ pref=next(pref); apply(pref); }); }
})();

/* Ricerca modale live */
(function(){
  const input = document.getElementById('liveSearchInput');
  const box   = document.getElementById('searchResults');
  const hint  = document.getElementById('searchHint');
  const spin  = document.getElementById('searchSpinner');
  let lastQ = '', ctrl, t=null;

  function esc(s){ return (s??'').replace(/[&<>"']/g, m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;', "'":'&#39;' }[m])); }
  function clearUI(){ box.innerHTML=''; hint.classList.remove('d-none'); hint.textContent='Inizia a digitare per cercare\u2026'; spin.classList.add('d-none'); }

  async function search(q){
    if(ctrl) ctrl.abort();
    ctrl = new AbortController();
    spin.classList.remove('d-none'); hint.classList.add('d-none'); box.innerHTML='';
    try{
      const r = await fetch('/client/api_search_lives.php?q='+encodeURIComponent(q), {signal: ctrl.signal, cache:'no-store'});
      const j = await r.json();
      render((j && j.items) ? j.items : []);
    }catch(e){
      hint.textContent='Errore di rete durante la ricerca.'; hint.classList.remove('d-none');
    }finally{ spin.classList.add('d-none'); }
  }

  function render(items){
    box.innerHTML='';
    if(!items.length){ hint.textContent='Nessun risultato.'; hint.classList.remove('d-none'); return; }
    hint.classList.add('d-none');
    for(const it of items){
      const a = document.createElement('a');
      a.className='list-group-item list-group-item-action d-flex align-items-center gap-3 py-2';
      a.href = '/live/' + encodeURIComponent(it.slug); // pretty URL
      a.target = '_blank'; a.rel = 'noopener';
      a.innerHTML =
        (it.image ? `<img src="${esc(it.image)}" alt="" class="result-thumb">`
                  : `<div class="result-thumb d-flex align-items-center justify-content-center muted">-</div>`) +
        `<div class="flex-grow-1">
           <div class="fw-bold">${esc(it.title)}</div>
           <div class="small muted">${esc(it.category || '')}</div>
         </div>
         <div class="chip">${esc(it.label || 'Live')}</div>`;
      box.appendChild(a);
    }
  }

  if (input){
    input.addEventListener('input', function(){
      const q = this.value.trim();
      if(q === lastQ) return;
      lastQ = q;
      if(!q){ clearUI(); return; }
      clearTimeout(t);
      t = setTimeout(()=>search(q), 250);
    });
    input.addEventListener('keydown', function(e){
      if(e.key==='Enter'){
        const first = box.querySelector('a.list-group-item-action');
        if(first){ first.click(); }
      }
    });
  }
  document.getElementById('searchModal')?.addEventListener('shown.bs.modal', ()=>{
    if(input){ input.value=''; input.focus(); } clearUI(); lastQ='';
  });
})();
</script>