<?php
// /privacy.php
$page_title = 'Privacy Policy';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/partials/header.php';

function get_setting($pdo,$k){
  $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?");
  $st->execute([$k]); $r=$st->fetch();
  return $r ? $r['value'] : null;
}

function default_privacy_html(): string {
  ob_start(); ?>
  <section>
    <h3>Raccolta dei Dati</h3>
    <p>La presente Privacy Policy descrive come raccogliamo, utilizziamo e proteggiamo i tuoi dati personali quando utilizzi il nostro servizio.</p>
    <ul>
      <li><strong>Informazioni personali:</strong> indirizzo email e dati di pagamento (solo in caso di abbonamento).</li>
      <li><strong>Dati di utilizzo:</strong> log di accesso, indirizzo IP, dispositivo e cronologia delle sessioni.</li>
      <li><strong>Cookie e tecnologie di tracciamento:</strong> per migliorare l’esperienza di navigazione.</li>
    </ul>
  </section>
  <hr>
  <section>
    <h3>Utilizzo dei Dati</h3>
    <p>I dati raccolti vengono utilizzati per i seguenti scopi:</p>
    <ul>
      <li>Fornire e mantenere il servizio.</li>
      <li>Gestire gli abbonamenti e i pagamenti.</li>
      <li>Migliorare la sicurezza e prevenire accessi non autorizzati.</li>
      <li>Analizzare statistiche di utilizzo per migliorare il servizio.</li>
    </ul>
  </section>
  <hr>
  <section>
    <h3>Protezione e Sicurezza</h3>
    <p>Adottiamo protocolli di cifratura e sistemi di autenticazione avanzati per prevenire accessi non autorizzati ai tuoi dati.</p>
  </section>
  <hr>
  <section>
    <h3>Condivisione dei Dati</h3>
    <p>Non vendiamo i dati personali a terzi. Possiamo condividere dati solo quando necessario per:</p>
    <ul>
      <li>Adempiere a obblighi di legge.</li>
      <li>Prevenire attività fraudolente e proteggere i diritti degli utenti.</li>
      <li>Elaborare pagamenti tramite partner certificati.</li>
    </ul>
  </section>
  <hr>
  <section>
    <h3>Diritti dell’Utente</h3>
    <p>Ai sensi del GDPR, hai diritto di accesso, rettifica, cancellazione, limitazione del trattamento, portabilità e opposizione. Puoi inoltre revocare il consenso in qualsiasi momento.</p>
  </section>
  <hr>
  <section>
    <h3>Contatti</h3>
    <p>Per richieste relative alla privacy o all’esercizio dei diritti, scrivi a <a href="mailto:admin@sportstreaming.net">admin@sportstreaming.net</a>.</p>
  </section>
  <?php
  return (string)ob_get_clean();
}

$policy_html = get_setting($pdo,'privacy_html') ?: default_privacy_html();
?>
<style>
  .policy-wrap{ max-width: 960px; margin: 24px auto 40px; padding: 0 12px; }
  .policy-card{
    background: var(--body-bg, #fff);
    color: var(--body-text, #212529);
    border: 1px solid rgba(0,0,0,.06);
    border-radius: 14px;
    box-shadow: 0 6px 26px rgba(0,0,0,.08);
    padding: 20px 22px;
  }
  html[data-theme="dark"] .policy-card{
    border-color: rgba(255,255,255,.08);
    box-shadow: 0 6px 26px rgba(0,0,0,.35);
    background: #121416; color:#e9eef7;
  }
  .policy-title{ text-align:center; font-weight:800; margin: 6px 0 18px; }
  .policy-content h3{ font-weight:800; font-size:1.1rem; margin: 14px 0 8px; }
  .policy-content p{ margin: .25rem 0 .75rem; line-height:1.65; }
  .policy-content ul{ margin: .25rem 0 .75rem; }
  .policy-content hr{ border:0; border-top:1px solid rgba(0,0,0,.08); margin: 12px 0 14px; }
  html[data-theme="dark"] .policy-content hr{ border-top-color: rgba(255,255,255,.12); }
  .policy-content a{ font-weight:700; text-decoration: none; }
  .policy-content a:hover{ text-decoration: underline; }
</style>

<div class="policy-wrap">
  <div class="policy-card">
    <h2 class="policy-title">Privacy Policy</h2>
    <div class="policy-content">
      <?= $policy_html /* HTML fidato impostato dall'admin */ ?>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>
