<?php
// /regolamento.php
$page_title = 'Regolamento';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/partials/header.php';

function get_setting($pdo,$k){
  $st=$pdo->prepare("SELECT value FROM settings WHERE `key`=?");
  $st->execute([$k]); $r=$st->fetch();
  return $r ? $r['value'] : null;
}

function default_rules_html(): string {
  ob_start(); ?>
  <section>
    <h3>Accesso e Abbonamento</h3>
    <p>Per accedere alla visione delle dirette, è necessario acquistare un abbonamento. L’abbonamento ha una durata di <strong>30 giorni</strong> e non si rinnova automaticamente. Al termine del periodo, l’utente potrà decidere liberamente se rinnovare il servizio per altri 30 giorni.</p>
  </section>
  <hr>
  <section>
    <h3>Utilizzo dell’Account</h3>
    <p>Ogni account è personale e non può essere condiviso con altri utenti. È consentita la visione da <strong>un solo dispositivo per volta</strong> per ogni account. Tentativi di accesso multiplo da diversi dispositivi contemporaneamente verranno automaticamente bloccati.</p>
    <p><strong>La condivisione dell’account è vietata</strong> e potrebbe comportare il blocco permanente del profilo senza possibilità di rimborso.</p>
  </section>
  <hr>
  <section>
    <h3>Eventi e Trasmissioni</h3>
    <p>Sul nostro portale è garantita la trasmissione di tutti gli eventi sportivi inclusi nel <a href="/client/schedule.php">palinsesto</a>. Oltre agli eventi sportivi, sono disponibili <strong>canali di news attivi 24 ore su 24</strong>.</p>
    <p>La trasmissione degli eventi sportivi viene attivata almeno <strong>30 minuti prima dell’inizio dell’evento</strong> per garantirne la completa visione.</p>
  </section>
  <hr>
  <section>
    <h3>Contenuti e Responsabilità</h3>
    <p>I contenuti trasmessi su questa piattaforma sono il risultato di una <strong>ricerca automatizzata</strong> effettuata da un algoritmo che analizza il web. I link ai flussi di trasmissione vengono reperiti in maniera autonoma dal software e <strong>non sono direttamente gestiti dal sito né dal suo amministratore</strong>.</p>
    <p>La gestione del sito è completamente automatizzata e non prevede l’intervento di moderatori o agenti che caricano o filtrano i contenuti. Di conseguenza, il sito e il suo gestore <strong>non si assumono alcuna responsabilità</strong> per le trasmissioni disponibili su questa piattaforma.</p>
    <p>Se si ritiene che un contenuto violi diritti o normative vigenti, si invita a contattare direttamente i detentori del flusso originale per richiederne la rimozione.</p>
  </section>
  <hr>
  <section>
    <h3>Modifiche al Regolamento</h3>
    <p>Il presente regolamento può essere aggiornato periodicamente. Si consiglia agli utenti di controllare questa pagina regolarmente per rimanere informati su eventuali modifiche.</p>
  </section>
  <?php
  return (string)ob_get_clean();
}

$rules_html = get_setting($pdo,'regolamento_html') ?: default_rules_html();
?>
<style>
  .rules-wrap{ max-width: 960px; margin: 24px auto 40px; padding: 0 12px; }
  .rules-card{
    background: var(--body-bg, #fff);
    color: var(--body-text, #212529);
    border: 1px solid rgba(0,0,0,.06);
    border-radius: 14px;
    box-shadow: 0 6px 26px rgba(0,0,0,.08);
    padding: 20px 22px;
  }
  html[data-theme="dark"] .rules-card{
    border-color: rgba(255,255,255,.08);
    box-shadow: 0 6px 26px rgba(0,0,0,.35);
    background: #121416;
    color: #e9eef7;
  }
  .rules-title{ text-align:center; font-weight:800; margin: 6px 0 18px; }
  .rules-content h3{ font-weight:800; font-size:1.1rem; margin: 14px 0 8px; }
  .rules-content p{ margin: .25rem 0 .75rem; line-height:1.65; }
  .rules-content hr{
    border:0; border-top:1px solid rgba(0,0,0,.08); margin: 12px 0 14px;
  }
  html[data-theme="dark"] .rules-content hr{ border-top-color: rgba(255,255,255,.12); }
  .rules-content a{ font-weight:700; text-decoration: none; }
  .rules-content a:hover{ text-decoration: underline; }
</style>

<div class="rules-wrap">
  <div class="rules-card">
    <h2 class="rules-title">Regolamento</h2>
    <div class="rules-content">
      <?= $rules_html /* Contenuto fidato: inserito dall'admin */ ?>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/partials/footer.php'; ?>
