<?php require_once __DIR__.'/../config.php'; ?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/video.js@8.16.1/dist/video-js.min.css">
<title>Player Test</title></head><body class="p-3">
<h4>Test Player HLS</h4>
<form class="row g-2 mb-3" method="get">
  <div class="col-9"><input class="form-control" name="url" placeholder="https://.../stream.m3u8" value="<?= htmlspecialchars($_GET['url'] ?? 'https://test-streams.mux.dev/x36xhzz/x36xhzz.m3u8') ?>"></div>
  <div class="col-3"><button class="btn btn-primary w-100">Prova</button></div>
</form>
<div id="alerts"></div>
<video id="player" class="video-js vjs-default-skin vjs-fluid" controls playsinline></video>
<script src="https://cdn.jsdelivr.net/npm/video.js@8.16.1/dist/video.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/hls.js@1.5.16"></script>
<script>
(function(){
  var m3u8 = <?= json_encode($_GET['url'] ?? 'https://test-streams.mux.dev/x36xhzz/x36xhzz.m3u8') ?>;
  var alerts = document.getElementById('alerts');
  function showAlert(html, cls){
    var d = document.createElement('div');
    d.className = 'alert ' + (cls||'alert-warning');
    d.innerHTML = html;
    alerts.appendChild(d);
  }
  if (location.protocol === 'https:' && /^http:\/\//i.test(m3u8)){
    showAlert('Attenzione: stai tentando di caricare un <strong>HTTP</strong> su pagina HTTPS. Il browser lo bloccherà (Mixed Content).', 'alert-danger');
  }
  var player = videojs('player', { autoplay:false, fluid:true, html5:{ vhs:{ overrideNative:true }}});
  player.on('error', ()=>{ var e=player.error(); showAlert('Video.js: '+(e? (e.code+' - '+e.message):'errore sconosciuto'), 'alert-danger'); });
  player.src({src:m3u8, type:'application/x-mpegURL'});
})();
</script>
</body></html>
