<?php
$hook = array(
    'hook' => 'InvoiceCreated',
    'function' => 'InvoiceCreated',
    'description' => 'Executed when an invoice has left “Draft” status and is available to its respective client.<br>Client Related<br>First Name: {firstname}, Last Name: {lastname}, Email Address: {email}, Company Name: {companyname}, Credit Balance: {credit}, Country: {country}, Currency: {currency}<br>Invoice Related<br> Due Date: {duedate}, Total: {total}, Invoice ID: {invoiceid} , Date Created: {date}, Date Paid: {datepaid}, Sub Total: {subtotal}, Tax: {tax}, Tax Rate: {taxrate}, Invoice Status: {status}, Invoice Payment Method: {paymentmethod}, Invoice Payment Link: {invoice_payment_link}, Invoice Pdf Link: {invoice_file}',
    'type' => 'client',
    'extra' => '',
    'defaultmessage' => 'Hello {firstname} {lastname}, Your invoice with id {invoiceid} has been generated. Total amount is {currency}  {total}. The last day of payment is {duedate}. Kindly pay your bill before due date to use services without interruption',
    'variables' => '{firstname}, {lastname},{email},{companyname},{credit},{country}, {duedate}, {total}, {invoiceid}, {currency} ,{date}, {datepaid},{subtotal}, {tax},{taxrate}, {status},{paymentmethod},{invoice_payment_link},{invoice_file}'
);
if(!function_exists('InvoiceCreated')){
    function InvoiceCreated($args){

        $api = new wachat();
        $template = $api->getTemplateDetails(__FUNCTION__);
        if($template['active'] == 0){
            return null;
        }
        $settings = $api->apiSettings();
        if(!$settings['api_key'] || !$settings['api_token']){
            return null;
        }
 
        $result = $api->getClientAndInvoiceDetailsBy($args['invoiceid']);
        $num_rows = mysql_num_rows($result);
        if($num_rows == 1){
            $UserInformation = mysql_fetch_assoc($result);
            $currency_sql=full_query('SELECT code FROM tblcurrencies WHERE id='.$UserInformation['currency']);
            $replace_currency="";
            if(mysql_num_rows($currency_sql) > 0){
                $currency_result=mysql_fetch_assoc($currency_sql);
                $replace_currency=$currency_result['code'];
            }
            global $CONFIG;
            $URL = $CONFIG['SystemURL'];
            $invoice_payment_link = $URL.'/viewinvoice.php?id='.$args['invoiceid'];
            $invoice_pdf_file = "";
            if($template['attachment'] == 1){
                $invoice_pdf_file = $api->pdfInvoice($args['invoiceid']);
            }
            $invoice_file = $URL.'/dl.php?type=i&id='.$args['invoiceid'].'&viewpdf=1';
            $template['variables'] = str_replace(" ","",$template['variables']);
            $replacefrom = explode(",",$template['variables']);
            $replaceto = array($UserInformation['firstname'],$UserInformation['lastname'],$UserInformation['email'],$UserInformation['companyname'],$UserInformation['credit'],$UserInformation['country'],$api->changeDateFormat($UserInformation['duedate']),$UserInformation['total'],$args['invoiceid'],$replace_currency,$api->changeDateFormat($UserInformation['date']),$api->changeDateFormat($UserInformation['datepaid']),$UserInformation['subtotal'],$UserInformation['tax'],$UserInformation['taxrate'],$UserInformation['status'],$UserInformation['paymentmethod'],$invoice_payment_link, $invoice_file);
            $message = str_replace($replacefrom,$replaceto,$template['template']);
            $gsmnumber = $UserInformation['gsmnumber'];
            if($settings['gsmnumberfield'] > 0){
                $gsmnumber = $api->customfieldsvalues($UserInformation['userid'], $settings['gsmnumberfield']);
            }
            $api->setCountryCode($UserInformation['country']);
            $api->setGsmnumber($gsmnumber);
            $api->setMessage($message, $invoice_pdf_file, $args['invoiceid']);
            $api->setUserid($UserInformation['userid']);
            $api->send();
        }
        logModuleCall('wachat',__FUNCTION__,$args,$api);    
    }
}


return $hook;
