<?php
/* WHMCS WhatsApp Notifications Addon with GNU/GPL Licence
 * WaSender.hu - https://wasender.hu/
 * 
 * Version 1.0.2
 * 
 * Licence: GPLv3 (http://www.gnu.org/licenses/gpl-3.0.txt)
 * */


if (!defined("WHMCS"))

	die("This file cannot be accessed directly");
	

	use WHMCS\Database\Capsule;
	

	



function wasender_config() {

    $configarray = [

            "name" => "WhatsApp Értesítés",
            "description" => "WaSender – WHMCS WhatsApp értesítési kiegészítő. Fiók létrehozása --> <a href=\"https://wasender.hu/\" target='_blank'>WaSender</a>",
            "version" => "1.0.2",
            "author" => "<img src='/modules/addons/wasender/logo.png' height='30' whith='120'>",
            "language" => "hungarian",

        ];
    return $configarray;
}

function wasender_activate() {
    
    try {
            $query = "CREATE TABLE IF NOT EXISTS `mod_wasender_settings` (`id` int(11) NOT NULL AUTO_INCREMENT,`permissionsend_text` varchar(1500) CHARACTER SET utf8 NOT NULL,`api_key` varchar(500) CHARACTER SET utf8 NOT NULL,`api_token` varchar(500) CHARACTER SET utf8 NOT NULL,`sender_id` varchar(500) CHARACTER SET utf8 NULL,`wantwhatsappfield` int(11) DEFAULT NULL,`gsmnumberfield` int(11) DEFAULT 0,`dateformat` varchar(12) CHARACTER SET utf8 DEFAULT NULL,`adminwhatsapp` varchar(40) NOT NULL,`calender` varchar(40) CHARACTER SET utf8 DEFAULT 'gregorian',`permissionsend` tinyint(1) NULL,`active_deactive` tinyint(1) NOT NULL,`all_delete` tinyint(1) NOT NULL,`disable` tinyint(1) NOT NULL,`autoupdate` tinyint(1) NOT NULL DEFAULT '1',`version` varchar(6) CHARACTER SET utf8 DEFAULT NULL,PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
            full_query($query);
        
            $query = "CREATE TABLE IF NOT EXISTS `mod_wasender_messages` (`id` int(11) NOT NULL AUTO_INCREMENT,`group_id` varchar(40) NOT NULL,`to` varchar(15) DEFAULT NULL,`text` text,`uid` varchar(50) DEFAULT NULL,`attachment` varchar(25) DEFAULT NULL,`status` varchar(150) DEFAULT NULL,`errors` text,`logs` text,`user` int(11) DEFAULT NULL,`datetime` datetime NOT NULL,PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
        	full_query($query);
        
            $query = "INSERT IGNORE  INTO `mod_wasender_settings` (`id`, `api_key`, `api_token`,`sender_id`, `wantwhatsappfield`, `gsmnumberfield`,`dateformat`, `calender`, `version`, `all_delete`, `disable`, `autoupdate`, adminwhatsapp,permissionsend,permissionsend_text,active_deactive) VALUES ('1', 'none', 'none','none', 'none', 0,'%y.%m.%d','gregorian','1.0.1',0,0,'1','','','','');";
        	full_query($query);
        
            $query = "CREATE TABLE IF NOT EXISTS `mod_wasender_templates` (`id` int(11) NOT NULL AUTO_INCREMENT,`name` varchar(50) CHARACTER SET utf8 NOT NULL,`type` enum('client','admin') CHARACTER SET utf8 NOT NULL,`admingsm` varchar(255) CHARACTER SET utf8 NOT NULL,`template` varchar(1500) CHARACTER SET utf8 NOT NULL,`variables` varchar(1000) CHARACTER SET utf8 NOT NULL,`active` tinyint(1) NOT NULL,`extra` varchar(3) CHARACTER SET utf8 NOT NULL,`attachment` tinyint(1) NOT NULL,`description` text CHARACTER SET utf8,PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
        	full_query($query);
        
            $query = "CREATE TABLE IF NOT EXISTS `mod_wasender_otp` (`id` int(11) NOT NULL AUTO_INCREMENT,`otp` varchar(50) CHARACTER SET utf8 NOT NULL,`type` enum('client','admin') CHARACTER SET utf8 DEFAULT 'client',`relid` int(10) DEFAULT 0,`request` varchar(50) CHARACTER SET utf8 NOT NULL,`text` text,`status` tinyint(1) DEFAULT 0, `datetime` datetime NOT NULL, `phonenumber` text, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
        	full_query($query);
            
            require_once("api.php");
            $api = new wasender();
            $api->checkLists();
    $update = array(

                "active_deactive" => '1'

            );
            update_query("mod_wasender_settings", $update, "");
            

            return array('status'=>'success','description'=>'WaSender Addon successfully activated');
            return [

            'status' => "success",
            'description' => 'WaSender Addon successfully activated',

        ];
        



    }catch (\Exception $e) {

        return [

            'status' => "error",
            'description' => 'Unable to create WaSender Addon: ' . $e->getMessage(),

        ];
    }    

}



function wasender_deactivate() {

    

    $api = new wasender();
    $settings = $api->apiSettings();
    if($settings['all_delete'] == 1){

    

        try {

            Capsule::schema()->dropIfExists('mod_wasender_templates');
            Capsule::schema()->dropIfExists('mod_wasender_settings');
            Capsule::schema()->dropIfExists('mod_wasender_messages');
            Capsule::schema()->dropIfExists('mod_wasender_otp');
            

            return [

                'status' => 'success',
                'description' => 'WaSender Addon successfully full deactivated',

            ];
        } catch (\Exception $e) {

            return [

                "status" => "error",
                "description" => "Unable to drop WaSender Addon table: {$e->getMessage()}",

            ];
        }

    }else{

            return [

                "status" => "success",
                "description" => "WaSender Addon successfully deactivated",

            ];
    }

}



function wasender_upgrade($vars)

{

    $api = new wasender();
    $api->upgrade($vars);
    

    $update = array(

        "active_deactive" => '0'

    );
    update_query("mod_wasender_settings", $update, "");
}







function wasender_clientarea($vars) {

 

}





function wasender_output($vars){

	$modulelink = $vars['modulelink'];
	$version = $vars['version'];
	$LANG = $vars['_lang'];
	putenv("TZ=Europe/Budapest");
    $api = new wasender();
    $tab = $_GET['tab'];
    $settings = $api->apiSettings();
    if($settings['active_deactive'] != 1){

        echo '<div class="detail">

        <span style="font-weight: 700; color: red;" >Megjegyzés: A frissítés után deaktiválnia és aktiválnia kell a modult.</span>

        </div>';
    }

    echo '<div id="newsletters_whatsapp_system">

    

    <style>

    .contentarea{

        background: #f5f5f5 !important;
    }

    #clienttabs *{

        margin: inherit;
        padding: inherit;
        border: inherit;
        color: inherit;
        background: inherit;
        background-color: inherit;
    }

  



    #clienttabs{position: relative; z-index: 99;}

     #clienttabs ul li {

        display: inline-block;
        margin-right: 3px;
        border: 1px solid #ddd;
        border-bottom:0px;
        padding: 12px;
        margin-bottom: -1px;
     }

     #clienttabs ul a {

     border: 0px;;
     }

     #clienttabs ul {

        float:left;
        margin-bottom:0px;
     }

     #clienttabs{

        float:left;
     }

     



    </style>

    



    

    <div id="clienttabs">

        <ul>

            <li class="' . (($tab == "settings" || (@$_GET['type'] == "" && $tab == "")) ? "tabselected" : "tab") . '"><a href="addonmodules.php?module=wasender&tab=settings">' . $LANG['settings'] . '</a></li>
            <li class="' . ((@$_GET['type'] == "client") ? "tabselected" : "tab") . '"><a href="addonmodules.php?module=wasender&tab=templates&type=client">' . $LANG['clientwhatsapptemplates'] . '</a></li>
            <li class="' . ((@$_GET['type'] == "admin") ? "tabselected" : "tab") . '"><a href="addonmodules.php?module=wasender&tab=templates&type=admin">' . $LANG['adminwhatsapptemplates'] . '</a></li>
            <li class="' . (($tab == "sendtoclients") ? "tabselected" : "tab") . '"><a href="addonmodules.php?module=wasender&tab=sendtoclients">' . $LANG['sendwhatsapp'] . '</a></li>
            <li class="' . (($tab == "messages") ? "tabselected" : "tab") . '"><a href="addonmodules.php?module=wasender&amp;tab=messages">' . $LANG['messages'] . '</a></li>
            <li class="' . (($tab == "c") ? "tabselected" : "tab") . '"><a href="addonmodules.php?module=wasender&amp;tab=support">' . $LANG['support'] . '</a></li>

        </ul>

    </div>

    <div style="clear:both;"></div>

    ';
    if (!isset($tab) || $tab == "settings")

    {

        /* UPDATE SETTINGS */
        if (isset($_POST['params'])) {
            $update = array(
                "api_key" => $_POST['api_key'],
                "api_token" => $_POST['api_token'],
                "sender_id" => $_POST['sender_id'],
                'gsmnumberfield' => $_POST['gsmnumberfield'],
                'dateformat' => $_POST['dateformat'],
				'calender' => $_POST['calender'],
				'all_delete' => $_POST['all_delete'],
				'disable' => $_POST['disable'],
				'autoupdate' => $_POST['autoupdate'],
				'wantwhatsappfield' => $_POST['whatsappotp'],
				'adminwhatsapp' => $_POST['adminwhatsapp'],
				'permissionsend' => $_POST['permissionsend'],
				'permissionsend_text' => $_POST['permissionsend_text']
            );
            update_query("mod_wasender_settings", $update, "");
            
            if($_POST['whatsappotp'] == 1){
                $receive = 'on';
            }else if ($_POST['whatsappotp'] == 0 || $_POST['whatsappotp'] === null){
                $receive = 'off';
            }
            $api->wacurl('/receive/','?receive='.$receive);
        }
        /* UPDATE SETTINGS */



        $settings = $api->apiSettings();
        $api_key = $settings['api_key'];
        $api_token = $settings['api_token'];
		$sender_id=$settings['sender_id'];
		
		
		
		$calender = array("gregorian", "jalali");
		

        foreach($calender as $item){

    		if ($item == $settings['calender']) {

    			$selected = 'selected="selected"';
    		} else {

    			$selected = "";
    		}

    		$calender .= '<option value="' . $item . '" ' . $selected . '>' . $item . '</option>';
		}		
		
		
		
		if ($settings['all_delete'] == 1) {
                $all_delete = 'checked = "checked"';
            } else {
                $all_delete = '';
            }
		
        if ($settings['autoupdate'] == 1) {
                $autoupdate = 'checked = "checked"';
            } else {
                $autoupdate = '';
            }
		
		if ($settings['wantwhatsappfield'] == 1) {
                $whatsappotp = 'checked = "checked"';
            } else {
                $whatsappotp = '';
            }
		
        if ($settings['permissionsend'] == 1) {
                $permissionsend = 'checked = "checked"';
            } else {
                $permissionsend = '';
            }



        //Start User Authorization Check

        $checker = new wasenderAPI();
        $checker->setUser($api_key, $api_token);
        $checker->CheckBalance();
if ($settings['autoupdate'] == 1) {

                $autoupdate = 'checked = "checked"';
            } else {

                $autoupdate = '';
            }


        if ($checker == 'balance') {

            echo '

 <style>

.card {

  box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
  transition: 0.3s;
  width: 100%;
}





.container {

  padding: 2px 16px;
  display: flex;
  justify-content: center;
  flex-direction: row;
}

</style>

<br><br>

        <div class="card">

         <div class="container">

        <form action="" method="post" id="form">

        <input type="hidden" name="action" value="save" />

            <div class="internalDiv">

            <span id="responsemsg"></span>

			<input type="hidden" name="params" value="0"/>

 

                            <td class="fieldlabel" width="30%">' . $LANG['accesstoken'] . '</td>

                            <div class="input-group">

                            <input type="text" name="api_key" class="form-control" size="40" value="' . $settings['api_key'] . '">

                            </div>


                            <td class="fieldlabel" width="30%">' . $LANG['instanceid'] . '</td>

                            <div class="input-group">

                            <input type="text" name="api_token" class="form-control" size="40" value="' . $settings['api_token'] . '">

                            </div>

                            <div style="padding:10px 0;"><a class="btn btn-primary" href="https://wasender.hu/" target="_blank">' . $LANG['signupid'] . '</a></div>


                            <td class="fieldlabel" width="30%">'.$LANG['dateformat'].'</td>

                            <div class="input-group">

                            <input type="text" name="dateformat" class="form-control" size="40" value="'.$settings['dateformat'].'">  </div> Pl:  %y.%m.%d (2023.03.09)

                           

                            </div>
							
							<td class="fieldlabel" width="30%">'.$LANG['autoupdate'].'</td>

                                <td><input type="checkbox" value="1" name="autoupdate" '.$autoupdate.'></td>

                            <p><br>
							
							<tr>

                                <td class="fieldlabel" width="30%">'.$LANG['all_data_delete'].'</td>

                                <td><input type="checkbox" value="1" name="all_delete"'.$all_delete.'></td>

                            </tr><br>'.$LANG['all_data_delete_desc'].'<p><br>
							<tr>
                                <td class="fieldlabel" width="30%">'.$LANG['permissionsend'].'</td>
                                <td><input type="checkbox" value="1" name="permissionsend" ' . $permissionsend . '>
                                <textarea cols="50" name="permissionsend_text" class="form-control" placeholder="'.$LANG['permissionsend_text'].'">' . $settings['permissionsend_text'] . '</textarea>
                                '.$LANG['permissionsenddec'].'
                            </tr><p><br>
                            
                            

            <div class="btn-container">

                <input type="submit" value="' . $LANG['save'] . '" class="btn btn-primary" />

            </div>

        </form>

        </div>

        </div>

        ';
        } else {

            //Please setup your api akey

            echo '

        <style>

.card {

  box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);
  transition: 0.3s;
  width: 100%;
}





.container {

  padding: 2px 16px;
  display: flex;
  justify-content: center;
  flex-direction: row;
}

</style>

<br><br>

        <div class="card">

         <div class="container">

        <form action="" method="post" id="form">

        <input type="hidden" name="action" value="save" />

            <div class="internalDiv">

            <span id="responsemsg"></span>

			<input type="hidden" name="params" value="0"/>

 

                            <td class="fieldlabel" width="30%">' . $LANG['accesstoken'] . '</td>

                            <div class="input-group">

                            <input type="text" name="api_key" class="form-control" size="40" value="' . $settings['api_key'] . '">

                            </div>

                            <td class="fieldlabel" width="30%">' . $LANG['instanceid'] . '</td>

                            <div class="input-group">

                            <input type="text" name="api_token" class="form-control" size="40" value="' . $settings['api_token'] . '">

                            </div>

                            <div style="padding:10px 0;"><a class="btn btn-primary" href="https://wasender.hu/" target="_blank">'.$LANG['signupid'].'</a></div>


                            <td class="fieldlabel" width="30%">'.$LANG['dateformat'].'</td>

                            <div class="input-group">

                            <input type="text" name="dateformat" class="form-control" size="40" value="'.$settings['dateformat'].'">  </div> Pl:  %y.%m.%d (2023.03.09)

                           

                            </div></br>
							
							<td class="fieldlabel" width="30%">'.$LANG['autoupdate'].'</td>

                                <td><input type="checkbox" value="1" name="autoupdate" '.$autoupdate.'></td>

                            <p><br>
							
							<tr>

                                <td class="fieldlabel" width="30%">'.$LANG['all_data_delete'].'</td>

                                <td><input type="checkbox" value="1" name="all_delete"'.$all_delete.'></td>

                            </tr><br>'.$LANG['all_data_delete_desc'].'<p><br>
							<tr>
                                <td class="fieldlabel" width="30%">'.$LANG['permissionsend'].'</td>
                                <td><input type="checkbox" value="1" name="permissionsend" '.$permissionsend.'>
                                <textarea cols="50" name="permissionsend_text" class="form-control" placeholder="'.$LANG['permissionsend_text'].'">'.$settings['permissionsend_text'].'</textarea>
                                '.$LANG['permissionsenddec'].'
                            </tr><p><br>
                            
                            

            <div class="btn-container">

                <input type="submit" value="'.$LANG['save'].'" class="btn btn-primary" />

            </div>

        </form>

        </div>

        </div>

        ';
        }
    } 
	elseif ($tab == "templates")
    {
        if (isset($_POST['params'])) { 
            $where = array("type" => array("sqltype" => "LIKE", "value" => $_GET['type']));
            $result = select_query("mod_wasender_templates", "*", $where);
            while ($data = mysql_fetch_array($result)) {
                if ($_POST[$data['id'] . '_active'] == "on") {
                    $tmp_active = 1;
                } else {
                    $tmp_active = 0;
                }
                if ($_POST[$data['id'] . '_attachment'] == "on") {
                    $tmp_attachment = 1;
                } else {
                    $tmp_attachment = 0;
                }
                $update = array(
                    "template" => $_POST[$data['id'] . '_template'],
                    "active" => $tmp_active,
                    "attachment" => $tmp_attachment
                );

                if(isset($_POST[$data['id'] . '_extra'])){
                    $update['extra']= trim($_POST[$data['id'] . '_extra']);
                }
                if(isset($_POST[$data['id'] . '_admingsm'])){
                    $update['admingsm']= $_POST[$data['id'] . '_admingsm'];
                    $update['admingsm'] = str_replace(" ","",$update['admingsm']);
                }
                update_query("mod_wasender_templates", $update, "id = " . $data['id']);
            }
        }

        echo '<form action="" method="post">
        <input type="hidden" name="action" value="save" />
        <input type="hidden" name="params" value="0"/>
            <div class="internalDiv">
                <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3" style="margin:0px;border: 0px;">
                    <tbody>';
        $where = array("type" => array("sqltype" => "LIKE", "value" => $_GET['type']));
        $result = select_query("mod_wasender_templates", "*", $where);

        while ($data = mysql_fetch_array($result)) {
            if ($data['active'] == 1) {
                $active = 'checked = "checked"';
            } else {
                $active = '';
            }
            if ($data['attachment'] == 1) {
                $attachment = 'checked = "checked"';
            } else {
                $attachment = '';
            }
            $desc = json_decode($data['description']);
            if(isset($desc->$LANG['lang'])){
                $name = $desc->$LANG['lang'];
            }else{
                $name = $data['name'];
            }
            echo '
                <tr>
                    <td class="fieldlabel" width="30%">' . substr($name, 0, -2) . '</td>
                    <td class="fieldarea">
                        <textarea cols="50" name="' . $data['id'] . '_template">' . $data['template'] . '</textarea>
                    </td>
                </tr>';
            echo '
            <tr>
                <td class="fieldlabel"  style="float:right;">'.$LANG['parameter'].'</td>
                <td>' . $data['description'] . '</td>
            </tr>
            ';
            if(!empty($data['extra'])){
                echo '
                <tr>
                    <td class="fieldlabel" width="30%">'.$LANG['ekstra'].'</td>
                    <td class="fieldarea">
                        <input type="text" name="'.$data['id'].'_extra" value="'.$data['extra'].'">
                    </td>
                </tr>
                ';
            }
            if($_GET['type'] == "admin" && !str_contains($data['name'], 'ClientAreaNavbars_WaSender')){
                echo '
                <tr>
                    <td class="fieldlabel" width="30%">'.$LANG['admingsm'].'</td>
                    <td class="fieldarea">
                        <input type="text" class="extraField" name="'.$data['id'].'_admingsm" placeholder="'.$LANG['admin_placeholder'].'" value="'.$data['admingsm'].'">
                    </td>
                </tr>
                ';
            }
            echo '
            <tr>
                <td class="fieldlabel" width="30%" style="float:right;">'.$LANG['active'].'</td>
                <td><input type="checkbox" value="on" name="' . $data['id'] . '_active" ' . $active . '></td>
            </tr>
            ';
            if (str_contains($data['name'], 'Invoice')) {
                echo '
            <tr>
                <td class="fieldlabel"  style="float:right;">'.$LANG['attachment'].'</td>
                <td><input type="checkbox" value="on" name="' . $data['id'] . '_attachment" ' . $attachment . '></td>
            </tr>
            ';
            }




            echo '<tr>
                <td colspan="2"><hr></td>
            </tr>';
        }
        echo '
        </tbody>
                </table>
        
            </div>
            <div class="btn-container">
                <input type="submit" value="'.$LANG['save'].'" class="btn btn-primary" />
            </div>
            </form>
            ';


    } 
	elseif ($tab == "messages")
    {
		$settings = $api->apiSettings();
		
        if(!empty($_GET['deletewhatsapp'])){
            foreach (explode(",",$_GET['deletewhatsapp']) as $n) {
            $sql = "DELETE FROM mod_wasender_messages WHERE id ='$n'";
            full_query($sql);
            }
        }
        if(!empty($_GET['updatestatus'])){
            $whatsappid = (int) $_GET['updatestatus'];
            $status = $api->wacurl('/getStatus/','?id='.$whatsappid);
    		$obj = json_decode($status);
    		$statusInfo= $obj->statusInfo;
    		if(!empty($statusInfo)){
        		$values = array(
                    "status" => $statusInfo
                );
        		update_query("mod_wasender_messages", $values, "uid = '" . $whatsappid."'");
    		}else{
    		    echo $LANG['errorwhatsappsent'];
    		}
        }
        
        if(!empty($_GET['resend'])){
            $gsmnumber = array($_GET['resend']);
            $message = $_GET['text'];
            $userid = $_GET['userid'];
            $invoiceid = $_GET['invoiceid'];
            if($invoiceid){
                $invoice_pdf_file = $api->pdfInvoice($invoiceid);
            }
            $api->setGsmnumber($gsmnumber);
            $api->setMessage($message, $invoice_pdf_file, $invoiceid);
            $api->setUserid($userid);

            $result = $api->send();
        		
            if($result == false){
                $responseToShow =  $LANG['errorwhatsappsent'];
            }else{
                $responseToShow =  $LANG['whatsappsent'];
            }
        }
        
        echo  '
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
        <script>
        $(document).ready(function(){
jQuery("#master").on("click", function(e) {
	if($(this).is(":checked",true))  
	{
		$(".sub_chk").prop("checked", true);  
	}  
	else  
	{  
		$(".sub_chk").prop("checked",false);  
	}  
});

jQuery(".delete_all").on("click", function(e) { 
var allVals = [];  
		$(".sub_chk:checked").each(function() {  
			allVals.push($(this).attr("data-id"));
		});  
		//alert(allVals.length); return false;  
		if(allVals.length <=0)  
		{  
			alert("Please select row.");  
		}  
		else {  
			//$("#loading").show(); 
			WRN_PROFILE_DELETE = "'.$LANG['mus_delete'].'";  
			var check = confirm(WRN_PROFILE_DELETE);  
			if(check == true){  
				//for server side
				/*
				var join_selected_values = allVals.join(","); 
				
				$.ajax({   
				  
					type: "POST",  
					url: "delete.php",  
					cache:false,  
					data: "ids="+join_selected_values,  
					success: function(response)  
					{   
						$("#loading").hide();  
						$("#msgdiv").html(response);
						//referesh table
					}   
				});*/
              //for client side
			  $.each(allVals, function( index, value ) {
				  $("table tr").filter("[data-row-id=" + value + "]").remove();
				  window.location.href = "addonmodules.php?module=wasender&tab=messages&deletewhatsapp="+ allVals;
			  });
				

			}  
		}  
	});

jQuery(".remove-row").on("click", function(e) {
		WRN_PROFILE_DELETE = "'.$LANG['mus_delete'].'";  
			var check = confirm(WRN_PROFILE_DELETE);  
			if(check == true){
				$("table tr").filter("[data-row-id=" + $(this).attr("data-id") + "]").remove();
				 window.location.href = "addonmodules.php?module=wasender&tab=messages&deletewhatsapp="+ $(this).attr("data-id");
			}
	});
});

        </script>
        
        <div class="internalDiv" style="padding:20px !important;">
        <div class="row well">
            '.$LANG['reoport_group'].'<p>
            '.$responseToShow.'
        </div>
        <a type="button" class="btn btn-primary pull-right delete_all">'.$LANG['selecteddelete'].'</a>
        <table id="employee_grid" class="table table-condensed table-hover table-striped bootgrid-table" width="60%" cellspacing="0">
        <thead>
            <tr>
                <th><input type="checkbox" id="master"></th>
                <th>'.$LANG['gsmnumber'].'</th>
				<th>'.$LANG['fullname'].'</th>
                <th width="45%" >'.$LANG['message'].'</th>
                <th><center>'.$LANG['datetime'].'</center></th>
                <th width="15%"><center>'.$LANG['reportstatus'].'</center></th>
                <th><center>'.$LANG['delete'].'</center></th>
            </tr>
        </thead>
        <tbody>
        ';
        // Getting pagination values.

        $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
        $limit = (isset($_GET['limit']) && $_GET['limit']<=50) ? (int)$_GET['limit'] : 10;
        $start  = ($page > 1) ? ($page*$limit) - $limit : 0;
        $order = isset($_GET['order']) ? $_GET['order'] : 'DESC';
        /* Getting messages order by date desc */
       
		
        $sql = "SELECT `m`.*,`user`.`firstname`,`user`.`lastname`
        FROM `mod_wasender_messages` as `m`
        JOIN `tblclients` as `user` ON `m`.`user` = `user`.`id`
        ORDER BY `m`.`datetime` {$order} limit {$start},{$limit}";
        $result = full_query($sql);
        $i = 0;
		
		/*
		$sql = "SELECT `m`.*
        FROM `mod_wasender_messages` as `m` 
        ORDER BY `m`.`datetime` {$order} limit {$start},{$limit}";
        $result = full_query($sql);
        $i = 0;
		*/
		
        //Getting total records

        $total = "SELECT count(id) as toplam FROM `mod_wasender_messages`";
        $sonuc = full_query($total);
        $sonuc = mysql_fetch_array($sonuc);
        $toplam = $sonuc['toplam'];
        //Page calculation

        $sayfa = ceil($toplam/$limit);
        while ($data = mysql_fetch_array($result)) {

            $i++;
		

		

		// Convert time    

        include_once('df.php');
        $date = $data['datetime'];
        $array = explode(' ', $date);
        list($year, $month, $day) = explode('-', $array[0]);
        list($hour, $minute, $second) = explode(':', $array[1]);
        $timestamp = mktime($hour, $minute, $second, $month, $day, $year);
        $jalali_date = jdate("Y/m/d H:i:s", $timestamp);
            
			
			echo  '<tr data-row-id="'.$data['id'].'">
			<td><input type="checkbox" class="sub_chk" data-id="'.$data['id'].'"></td>';
            if ($data['to'] =='group'){
               echo'<td>'.$data['to'].'</a></td>'; 
				
            }else{
                echo'<td><a href="clientssummary.php?userid='.$data['user'].'">'.$data['to'].'</a></td>';
			    echo'<td><a href="clientssummary.php?userid='.$data['user'].'">'.$data['lastname'].' '.$data['firstname'].'</a></td>';
            }

            echo'<td>'.$data['text'].'</td>';
			if ($settings['calender'] == "jalali"){

            echo '<td><center>'.$jalali_date.'</center></td>';
            }else{

                echo '<td><center>'.$data['datetime'].'</center></td>';
            }

            if($data['to'] !='group' && $data['status'] == 'success' || $data['status'] == 'Pending' && $data['to'] !='group'){

                echo'<td><center ><font class="btn btn-warning">'.$LANG['sent'].'</font></center></td>';
            }else if($data['to'] !='group'){

                echo'<td><center>'.$data['status'].'</center></td>';
            }
			//if($data['to'] !='group'){

              //  echo'<td><center><a href="addonmodules.php?module=wasender&tab=messages&resend='.$data['to'].'&text='.$data['text'].'&userid='.$data['user'].'&invoiceid='.$data['attachment'].'" class="btn btn-warning">'.$LANG['resend'].'</a></center></center></td>';
		//	}

            else{

                echo'<td><center><font class="btn btn-primary">'.$api->errors($data['errors']).'</center></td>';
            }

            

            echo'<td><center><a class="remove-row pull-right" targetDiv="" data-id="'.$data['id'].'" href="javascript: void(0)"><i class="glyphicon glyphicon-trash"></i></a></center></td>';
            //echo '<td><center><a href="addonmodules.php?module=wasender&tab=messages&deletewhatsapp='.$data['id'].'" title="'.$LANG['delete'].'"><img src="images/delete.gif" width="16" height="16" border="0" alt="Delete"></a></center></td></tr>';
        }

        /* Getting messages order by date desc */



        echo '
		
		</tr>

        </tbody>

        </table>

        ';
        $list="";
        for($a=1;$a<=$sayfa;$a++)
		
		{

            $selected = ($page==$a) ? 'selected="selected"' : '';
            $list .= "<option value='addonmodules.php?module=wasender&tab=messages&page={$a}&limit={$limit}&order={$order}' {$selected}>{$a}</option>";
        }
        echo $LANG['page'];
		echo "<select  onchange=\"this.options[this.selectedIndex].value && (window.location = this.options[this.selectedIndex].value);\">{$list}</select></div>";
          
    } elseif ($tab == "sendtoclients") {

        $settings = $api->apiSettings();
        if (!empty($_POST['client'])) {
            foreach ($_POST['client'] as $value) {
                // $userinf = explode("_",$_POST['client']);
                $userinf = explode("_", $value);
                $userid = $userinf[0];
                $gsmnumber = $userinf[1];
                $country = $userinf[4];
                $replacefrom = array("{lastname}","{firstname}");
                $replaceto = array($userinf[2], $userinf[3]);
                $message = str_replace($replacefrom, $replaceto, $_POST['message']);
                $api->setCountryCode($api->getCodeBy($country));
                $api->setGsmnumber($gsmnumber);
                $api->setMessage($message);
                $api->setUserid($userid);
                $result = $api->send();
                if ($result == false) {
                    $responseToShow =  $api->getErrors();
                } else {
                    $responseToShow =  $LANG['whatsappsent'];
                }

                if ($_POST["debug"] == "ON") {
                    $debug = 1;
                }
            }
        }

        $userSql = "SELECT `a`.`id`,`a`.`lastname`, `a`.`firstname`, `a`.`country`, `a`.`phonenumber` as `gsmnumber`

        FROM `tblclients` as `a` order by `a`.`lastname`";
        $clients = '';
        $result = mysql_query($userSql);
        while ($data = mysql_fetch_array($result)) {

            $clients .= '<option value="' . $data['id'] . '_' . $data['gsmnumber'] . '_' . $data['lastname'] . '_' . $data['firstname'] . '_' . $data['country'] . '">' . $data['lastname'] . ' ' . $data['firstname'] . ' (#' . $data['id'] . ')</option>';
        }



        echo '

        <script>

        jQuery.fn.filterByText = function(textbox, selectSingleMatch) {

          return this.each(function() {

            var select = this;
            var options = [];
            $(select).find("option").each(function() {

              options.push({value: $(this).val(), text: $(this).text()});
            });
            $(select).data("options", options);
            $(textbox).bind("change keyup", function() {

              var options = $(select).empty().scrollTop(0).data("options");
              var search = $.trim($(this).val());
              var regex = new RegExp(search,"gi");
              $.each(options, function(i) {

                var option = options[i];
                if(option.text.match(regex) !== null) {

                  $(select).append(

                     $("<option>").text(option.text).val(option.value)

                  );
                }

              });
              if (selectSingleMatch === true && 

                  $(select).children().length === 1) {

                $(select).children().get(0).selected = true;
              }

            });
          });
        };
        $(function() {

          $("#clientdrop").filterByText($("#textbox"), true);
        });  

        </script>';




        echo '<form action="" method="post">

        <input type="hidden" name="action" value="save" />

            <div class="internalDiv" >'.$responseToShow.'

                <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3" style="margin:0px;border: 0px;">

                    <tbody>

                        <tr>

                            <td class="fieldlabel" width="30%">'.$LANG['client'].'</td>

                            <td class="fieldarea">

                                <input id="textbox" type="text" placeholder="'.$LANG['typeclient'].'" style="width:498px;padding:5px"><br>

                                <select name="client[]" required class="sel" multiple id="clientdrop" style="padding:5px">

                                    <option value="">'.$LANG['selectclient'].'</option>

                                    '.$clients.'

                                </select>

                            </td>

                        </tr>

                        <tr>

                            <td class="fieldlabel" width="30%">'.$LANG['message'].'</td>

                            <td class="fieldarea">

                               <textarea cols="70" rows="5" required name="message" style="width:498px;padding:5px"></textarea>

                            </td>

                        </tr>

                        <tr>

                            <td class="fieldlabel" width="30%">'.$LANG['parameter'].'</td>

                            <td class="fieldarea">

                            Vezetéknév:{lastname}, Keresztnév:{firstname}

                            </td>

                        </tr>

                    </tbody>

                </table>

           

            </div>

            <div class="btn-container">

                <input type="submit" value="'.$LANG['send'].'" class="btn btn-primary" />

            </div>

        </form>';
    } elseif ($tab == "support") {



        echo '<div class="internalDiv" style="padding:20px !important;">';
        echo $LANG['cmodulesversion'];
        echo $LANG['phonehu'];
        echo $LANG['emailhu'];
        echo $LANG['website'];
        echo $LANG['clientportal'];
        echo $LANG['whatsappportal'];
        echo '</div>';
    }



    $credit =  $api->getBalance();
    if ($credit['balance']) {

        echo '

            <div style="text-align: left;background-color: whiteSmoke;margin: 0px;padding: 5px; border: 1px solid #ddd;">

            <b>' . $LANG['balance'] . ':</b>

            </div>';
    }

    echo $LANG['lisans'];
    echo '</div>';
}
