/*
* Core js fw functions
* Do not edit this file
*/

/**
 * Available Actions List:
 * - AppsPreLoad
 * - AppCreated
 * - ModalLoaded
 * - DatatableDataLoaded
 * - DatatableDataLoadingFailed
 * - SelectFieldValueChanged
 */

/*
 * Call
 */
var mgEventCallback = {
    objectId: null,
    eventType: null,
    callbackFunction :null,
    order: 1000,

    generateEvent: function(id, eventType, callbackFunction, order) {
        if ((id === null || typeof  id === 'string') && typeof eventType === 'string'
            && typeof callbackFunction === 'function') {
            this.objectId = id;
            this.eventType = eventType;
            this.callbackFunction = callbackFunction;
            this.order = (!order || typeof order !== 'number') ? 1000 : order;

            return this;
        } else {
            return null;
        }

    },
    runEventCallback: function(objectId, params) {
        this.callbackFunction(objectId, params);
    }
};

/*
 * Events Handler
 * collects and run all events callbacks in the app
 */
var mgEventHandler = {
    callbacks: {},

    on: function(eventType, id, callbackFunction, order) {
        var tmpCall = mgEventCallback.generateEvent(id, eventType, callbackFunction, order);
        var tempId = Object.keys(this.callbacks).length;
        this.callbacks['call_' + tempId] = Object.assign({}, tmpCall);
    },

    runCallback: function(eventType, id, callbackParams) {
        var callbackList = [];
        for (var key in this.callbacks) {
            if (!this.callbacks.hasOwnProperty(key)) {
                continue;
            }

            var tmpCallback = Object.assign({}, this.callbacks[key]);
            if (tmpCallback.eventType !== eventType || (tmpCallback.objectId !== null && tmpCallback.objectId !== id)){
                continue;
            } else if(tmpCallback.objectId !== null && tmpCallback.objectId === id) {
                callbackList.push(tmpCallback);
            } else {
                callbackList.push(tmpCallback);
            }
        }

        callbackList.sort(function(a, b){return a.order - b.order});
        $(callbackList).each(function(){
            this.runEventCallback(id, callbackParams);
        });
    }
};
