<!DOCTYPE html>
<html lang="en">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{if $kbarticle.title}{$kbarticle.title} - {/if}{$pagetitle} - {$companyname}</title>

    {include file="$template/includes/head.tpl"}

    {$headoutput}

</head>
<body data-phone-cc-input="{$phoneNumberInputStyle}" class="body-wraper {if in_array($templatefile, ['login', 'clientregister', 'password-reset-container', 'logout'])}auth-wrap{/if}">

{$headeroutput}

{if !in_array($templatefile, ['login', 'clientregister', 'password-reset-container', 'logout'])}

<header id="standard" class="white-bg header-main-menu">
    <div class="container">
        <div class="row">
            <section id="main-menu">
                <nav id="nav" class="navbar navbar-default navbar-main" role="navigation">

                    <!-- Brand and toggle get grouped for better mobile display -->
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#primary-nav">
                            <span class="sr-only">{lang key='toggleNav'}</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <!-- 
                        aClass = additional class if you want to pass add here or skip
                        logo = option: priamry or secondary. Primary will be color logo and Secondary will be white version logo
                        -->
                        {include file="$template/includes/logo.tpl" aClass="navbar-brand" logo="primary"}
                    </div>

                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse" id="primary-nav">

                        <ul class="nav navbar-nav navbar-center">

                            {include file="$template/includes/navbar.tpl" navbar=$primaryNavbar}

                        </ul>

                        <ul class="nav navbar-nav navbar-right secondary-nav">
                            <li class="primary-action">
                                <a href="{$WEB_ROOT}/cart.php?a=view"> <i class="fas fa-shopping-basket" data-toggle="tooltip" data-placement="top" title="" data-original-title="{$LANG.viewcart}"></i></a>
                            </li>
                            <!--currency dropdown start-->
                            {if !$loggedin && count($multiCurrency) > 1}
                            <li class="dropdown" id="currency-dropdown">
                                {foreach $multiCurrency as $currency}
                                    {if $currency.id eq $selectedCurrency}
                                    <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                                       <img alt="{$currency.code}"src="{$WEB_ROOT}/{$currency.flag}" class="paises"> 
                                       <span>{$currency.prefix}</span> <b class="caret"></b>
                                   </a>
                                   {/if}
                               {/foreach}
                               <ul class="dropdown-menu">
                                   {foreach $multiCurrency as $currency}
                                      {if $currency.id neq $selectedCurrency}
                                        {if $isQueryExist eq true}
                                          <li><a href="{$urlForCurrentcy}&currency={$currency.id}"><img alt="{$currency.code}"src="{$WEB_ROOT}/{$currency.flag}" class="paises"><span>{$currency.prefix}</span></a></li>
                                        {else}  
                                          <li><a href="{$urlForCurrentcy}?currency={$currency.id}"><img alt="{$currency.code}"src="{$WEB_ROOT}/{$currency.flag}" class="paises"><span>{$currency.prefix}</span></a></li>
                                        {/if}
                                      {/if}
                                  {/foreach}
                              </ul>
                            </li>
                            {/if}
                            <!--currency dropdown end-->
                            {if $loggedin}
                                <li>
                                    <a href="#" data-toggle="popover" id="accountNotifications" data-placement="bottom" class="notification">
                                        <i class="fas fa-bell" data-toggle="tooltip" data-placement="top" data-original-title="{$LANG.notifications}"> </i>
                                        <span class="dot-circle"></span>
                                    </a>
                                    <div id="accountNotificationsContent" class="hidden">
                                        <ul class="client-alerts">
                                            {foreach $clientAlerts as $alert}
                                                <li>
                                                    <a href="{$alert->getLink()}">
                                                        <i class="fas fa-fw fa-{if $alert->getSeverity() == 'danger'}exclamation-circle{elseif $alert->getSeverity() == 'warning'}exclamation-triangle{elseif $alert->getSeverity() == 'info'}info-circle{else}check-circle{/if}"></i>
                                                        <div class="message">{$alert->getMessage()}</div>
                                                    </a>
                                                </li>
                                                {foreachelse}
                                                <li class="none">
                                                    {$LANG.notificationsnone}
                                                </li>
                                            {/foreach}
                                        </ul>
                                    </div>
                                </li>

                                {include file="$template/includes/navbar.tpl" navbar=$secondaryNavbar from="account"}
                            {else}
                                {if $condlinks.allowClientRegistration}
                                    <li class="primary-action">
                                        <a href="{$WEB_ROOT}/register.php" class="sign-up-btn">Sign Up</a>
                                    </li>
                                {/if}
                                <li class="primary-action">
                                    <a href="{$WEB_ROOT}/clientarea.php" class="login-btn">Login</a>
                                </li>
                            {/if}
                        </ul>

                    </div><!-- /.navbar-collapse -->
                </nav>
            </section>
        </div>
    </div>
</header>
{/if}

{if $templatefile == 'homepage'}
    {if !in_array($templatefile, ['login', 'clientregister', 'password-reset-container', 'logout'])}
    <section id="home-banner" class="hero-equal-height">
        <div class="container">
            <div class="row align-center-row d-flex">
                <div class="col-lg-6 col-md-6">
                    <div class="hero-content-wrap text-white">
                        {if $registerdomainenabled || $transferdomainenabled}
                        <h1 class="text-white">{$LANG.homebegin}</h1>
                        <p class="lead">If your WordPress website is your personal business, we
                            want you to succeed. A ton of website hosting options, 99.9% uptime guarantee, free SSL certificate, easy WordPress installs.</p>
                        <form method="post" action="domainchecker.php" id="frmDomainHomepage">
                            <input type="hidden" name="transfer" />
                            <div class="input-group input-group-lg domain-search-field mb-5">
                                <input type="text" class="form-control" name="domain" placeholder="{$LANG.exampledomain}" autocapitalize="none" data-toggle="tooltip" data-placement="left" data-trigger="manual" />
                                <div class="input-group-btn right-icon">
                                    {if $registerdomainenabled}
                                        <button type="submit" class="btn search{$captcha->getButtonClass($captchaForm)}" id="btnDomainSearch">
                                          <i class="fas fa-search"></i> Search
                                        </button>
                                    {/if}
                                    {if $transferdomainenabled}

                                    {/if}
                                </div>
                            </div>
                        </form>
                        {else}
                            <h2>{$LANG.doToday}</h2>
                        {/if}

                        {if count($pricetable) gt 0}

                        <div class="domain-list-wrap mt-4">
                            <ul class="list-inline domain-search-list text-white">
                                {foreach $pricetable as $price}
                                        {if $price.extension == '.com'}
                                        <li class="list-inline-item"><a href="#"><img src="templates/{$template}/img/com-w.png" alt="com" width="70" class="img-fluid"> <span>{$price.prefix}{$price.msetupfee}</span></a></li>
                                        {elseif $price.extension == '.net'}
                                        <li class="list-inline-item"><a href="#"><img src="templates/{$template}/img/net-w.png" alt="net" width="70" class="img-fluid"> <span>{$price.prefix}{$price.msetupfee}</span></a></li>
                                        {elseif $price.extension == '.org'}
                                        <li class="list-inline-item"><a href="#"><img src="templates/{$template}/img/org-w.png" alt="org" width="70" class="img-fluid"> <span>{$price.prefix}{$price.msetupfee}</span></a></li>
                                        {elseif $price.extension == '.store'}
                                        <li class="list-inline-item"><a href="#"><img src="templates/{$template}/img/store-w.png" alt="store" width="70" class="img-fluid"> <span>{$price.prefix}{$price.msetupfee}</span></a></li>
                                        {elseif $price.extension == '.online'}
                                        <li class="list-inline-item"><a href="#"><img src="templates/{$template}/img/online-w.png" alt="online" width="70" class="img-fluid"> <span>{$price.prefix}{$price.msetupfee}</span></a></li>
                                    {/if}
                                {/foreach}
                            </ul>
                        </div>
                        {/if}
                        {include file="$template/includes/captcha.tpl"}
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <img src="templates/{$template}/img/hero-home.svg" alt="wp hosting" class="img-responsive">
                </div>
            </div>
        </div>
    </section>
    {/if}
     <!--promo section start-->
    <section class="promo-section pt-100">
        <div class="container">
            <div class="row">
                {if $registerdomainenabled || $transferdomainenabled}
                    <div class="col-md-6 col-lg-3 mb-4 mb-md-4 mb-lg-0">
                         <a id="btnBuyADomain" href="domainchecker.php">
                            <div class="single-promo-card single-promo-hover text-center">
                                <div class="promo-body">
                                    <div class="promo-icon">
                                        <span class="fal fa-globe-americas color-primary"></span>
                                    </div>
                                    <div class="promo-info">
                                         <h5>{$LANG.buyadomain}</h5>
                                        <p>Whether you are looking for a personal website hosting plan.</p>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                {/if}
                <div class="col-md-6 col-lg-3 mb-4 mb-md-4 mb-lg-0">
                    <a id="btnOrderHosting" href="{$WEB_ROOT}/cart.php">
                        <div class="single-promo-card single-promo-hover text-center">
                            <div class="promo-body">
                                <div class="promo-icon">
                                    <span class="fal fa-server color-primary"></span>
                                </div>
                                <div class="promo-info">
                                     <h5>{$LANG.orderhosting}</h5>
                                     <p>Whether you are looking for a personal website hosting plan</p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-6 col-lg-3 mb-4 mb-md-4 mb-lg-0">
                    <a id="btnMakePayment" href="clientarea.php">
                        <div class="single-promo-card single-promo-hover text-center">
                            <div class="promo-body">
                                <div class="promo-icon">
                                    <span class="fal fa-money-check-alt color-primary"></span>
                                </div>
                                <div class="promo-info">
                                     <h5>{$LANG.makepayment}</h5>
                                    <p>Whether you are looking for a personal website hosting plan</p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-6 col-lg-3 mb-4 mb-md-4 mb-lg-0">
                    <a id="btnGetSupport" href="submitticket.php">
                        <div class="single-promo-card single-promo-hover text-center">
                            <div class="promo-body">
                                <div class="promo-icon">
                                    <span class="fal fa-headset color-primary"></span>
                                </div>
                                <div class="promo-info">
                                    <h5>{$LANG.getsupport}</h5>
                                    <p>Whether you are looking for a personal website hosting plan</p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>
     <!--promo section end-->
    <!--about section start-->
    <section class="about-section ptb-100">
        <div class="container">
            <div class="row align-center-row">
                <div class="col-md-6 col-lg-6">
                    <div class="cta-new-wrap">
                        <h2>99% Cloud Hosing High-speed Cutting-edge Platform</h2>
                        <p>Globally parallel task granular alignments through excellent intellectual capital. Collaboratively orchestrate plug-and-play web services without progressive networks. Interactively formulate frictionless relationships and real-time markets.</p>
                        <p>Authoritatively transform functionalized information without cross-platform convergence. Quickly reconceptualize cross-unit e-markets without superior products. 
                        Appropriately foster timely collaboration and idea-sharing rather than magnetic potentialities.</p>
                        <ul class="list-unstyled tech-feature-list">
                            <li><span class="fa fa-check-circle color-primary"></span><strong>Flexible</strong>, Easy to Use Control Panel</li>
                            <li><span class="fa fa-check-circle color-primary"></span><strong>Unlimited </strong> Number of Website with Bandwidth</li>
                            <li><span class="fa fa-check-circle color-primary"></span><strong>Unlimited </strong> Sub Domains, FTP Accounts</li>
                        </ul>
                        <div class="action-btns">
                            <a href="#download" class="btn outline-btn animated-btn mr-lg-3">Get
                                Started Now</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="cta-new-wrap">
                        <img src="templates/{$template}/img/services.svg" alt="hosting" class="img-responsive"/>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--about section end-->
    
    <!--call to action start-->
    <section class="ptb-60 primary-bg">
        <div class="container">
            <div class="row align-items-center d-flex">
                <div class="col-md-7 col-lg-6">
                    <div class="cta-content-wrap text-white">
                        <h2 class="text-white">Best Cloud Hosting <br> With Trusted Service</h2>
                        <p>Objectively innovate high standards in methodologies vis-a-vis sustainable compellingly maintain multidisciplinary process proactively streamline mission-critical information via quality imperatives utilize cross-unit networks through holistic functionalities quality technology and distributed content. </p>
                    </div>
                    <div class="action-btns mt-4">
                        <a href="#" class="btn outline-white-btn"> Get Start Now </a>
                    </div>
                </div>
                <div class="col-lg-2"></div>
                <div class="col-md-5 col-lg-4">
                    <div class="cta-img-wrap text-center">
                        <img src="templates/{$template}/img/server-room.svg" class="img-responsive" alt="server room">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--call to action end-->
    
    <!--services section start-->
    <section class="our-services ptb-100 gray-light-bg">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="section-heading-center text-center">
                        <h2>We Have a Hosting Solution For You</h2>
                        <p class="lead">Synergistically architect plug-and-play vortals without next-generation
                            manufactured products. Assertively develop synergistic networks.</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 col-lg-6">
                    <div class="single-service rounded border white-bg">
                        <div class="service-header d-flex align-items-center justify-content-between">
                            <h4><span class="h5 text-uppercase">Easy &amp; First</span> <br>Website Building</h4>
                            <span class="fal fa-shield-alt fa-3x color-primary"></span>
                        </div>
                        <p>Globally fashion client-focused synergy for accurate synergy. Quickly network cost effective ideas rather than standardized leadership. Interactively syndicate alternative opportunities via ubiquitous systems. </p>
                        <a href="#" class="btn outline-btn mt-3">Learn More</a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="single-service rounded border white-bg">
                        <div class="service-header d-flex align-items-center justify-content-between">
                            <h4><span class="h5 text-uppercase">Suitable For All Users</span> <br>Managed WordPress</h4>
                            <span class="fab fa-wordpress-simple fa-3x color-primary"></span>
                        </div>
                        <p>Globally fashion client-focused synergy for accurate synergy. Quickly network cost effective ideas rather than standardized leadership. Interactively syndicate alternative opportunities via ubiquitous systems. </p>
                        <a href="#" class="btn outline-btn mt-3">Learn More</a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="single-service rounded border white-bg">
                        <div class="service-header d-flex align-items-center justify-content-between">
                            <h4><span class="h5 text-uppercase">Commitment To</span> <br>Dedicated Support</h4>
                            <span class="fal fa-headset fa-3x color-primary"></span>
                        </div>
                        <p>Globally fashion client-focused synergy for accurate synergy. Quickly network cost effective ideas rather than standardized leadership. Interactively syndicate alternative opportunities via ubiquitous systems. </p>
                        <a href="#" class="btn outline-btn mt-3">Learn More</a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="single-service rounded border white-bg">
                        <div class="service-header d-flex align-items-center justify-content-between">
                            <h4><span class="h5 text-uppercase">Easy &amp; Smooth</span> <br>Website Transfer</h4>
                            <span class="fal fa-dolly-flatbed fa-3x color-primary"></span>
                        </div>
                        <p>Globally fashion client-focused synergy for accurate synergy. Quickly network cost effective ideas rather than standardized leadership. Interactively syndicate alternative opportunities via ubiquitous systems. </p>
                        <a href="#" class="btn outline-btn mt-3">Learn More</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--services section end-->
    
    <!--pricing section start-->
    {if count($myproducts) gt 0 && ($myproducts.0.monthly gt 0 || $myproducts.0.annually gt 0 || $myproducts.0.biennially gt 0 || $myproducts.0.triennially gt 0)}
    <section class="pricing-section ptb-100">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12 col-lg-12">
                    <div class="section-heading-center text-center">
                        <h2>Our Flexible Pricing Plan</h2>
                        <p class="lead">
                            Distinctively recaptiualize principle-centered core competencies through client-centered
                            core competencies. Enthusiastically provide access.
                        </p>
                    </div>
                </div>
            </div>
            <div class="row align-items-center justify-content-between">
                {foreach $myproducts as $productKey => $myproduct}
                    <div class="col-lg-4 col-md-4 col-sm-6">
                        <div class="text-center gray-light-bg single-pricing-pack-2 mt-4 rounded border">
                            <div class="pricing-icon">
                                {if $productKey eq 0}
                                    <img src="{$WEB_ROOT}/templates/{$template}/img/dadicate-web-hosting.svg" width="60" alt="hosing">
                                {elseif $productKey eq 1}
                                    <img src="{$WEB_ROOT}/templates/{$template}/img/vps-hosting.svg" width="60" alt="hosing">
                                {elseif $productKey eq 2}
                                    <img src="{$WEB_ROOT}/templates/{$template}/img/cloud-hosting.svg" width="60" alt="hosing">
                                {/if}
                            </div>
                            <h4 class="package-title">{$myproduct.name}{if $myproduct.is_featured == '1'} <span class="badge color-1 color-1-bg">Popular</span>{/if}</h4>
                            
                            <div class="pricing-price pt-4">
                                <small>Starting at</small>
                                <div class="h2">
                                    {$myproduct.prefix}
                                    {if $myproducts.0.monthly gt 0}
                                        {$myproduct.monthly} <span class="price-cycle h4">/monthly</span>
                                    {elseif $myproducts.0.quarterly gt 0}
                                        {$myproduct.quarterly} <span class="price-cycle h4">/quarterly</span>
                                    {elseif $myproducts.0.semiannually gt 0}
                                        {$myproduct.semiannually} <span class="price-cycle h4">/semiannually</span>
                                    {elseif $myproducts.0.annually gt 0}
                                        {$myproduct.annually} <span class="price-cycle h4">/annually</span>
                                    {elseif $myproducts.0.biennially gt 0}
                                        {$myproduct.biennially} <span class="price-cycle h4">/biennially</span>
                                    {elseif $myproducts.0.triennially gt 0}
                                        {$myproduct.triennially} <span class="price-cycle h4">/triennially</span>
                                    {/if}
                                </div>
                            </div>
                            <a href="cart.php?a=add&pid={$myproduct.relid}" class="btn {if $myproduct.is_featured == '1'}primary-solid-btn{else}outline-btn{/if} mt-20">Get Started Now</a>
                        </div>
                    </div>
                {/foreach}
            </div>
        </div>
    </section>
    {/if}
    <!--pricing section end-->
    
    <!--call to action section start-->
    <section class="ptb-60 primary-bg">
        <div class="container">
            <div class="row align-items-center justify-content-between d-flex">
                <div class="col-md-12 col-lg-6">
                    <div class="cta-content-wrap text-white">
                        <h2 class="text-white">24/7 Expert Hosting Support Our Customers Love</h2>
                        <p>Objectively innovate high compellingly maintain progressively pursue mission-critical information quality imperatives. </p>
                    </div>
                    <div class="support-action d-inline-flex flex-wrap">
                        <a href="mailto:support@yourdomain.com" class="mr-3"><i class="fas fa-comment mr-1 color-accent"></i> <span>support@yourdomain.com</span></a>
                        <a href="tel:+00123456789" class="mb-0"><i class="fas fa-phone-alt mr-1 color-accent"></i> <span>+00123456789</span></a>
                    </div>
                </div>
                <div class="col-lg-2"></div>
                <div class="col-md-6 col-lg-4 hidden-md hidden-sm hidden-xs">
                    <div class="cta-img-wrap text-center">
                        <img src="templates/{$template}/img/call-center-support.svg" width="250" class="img-fluid" alt="server room">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--call to action section end-->
    
    <!--feature section start-->
    <section class="feature-section ptb-100 gray-light-bg">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="section-heading-center text-center">
                        <h2>Hosting Features For Your Big Ideas</h2>
                        <p class="lead">These features come standard in all of our hosting plans. Dynamically extend
                            imperatives through open-source quickly niche markets.</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 col-lg-6">
                    <div class="features-box">
                        <div class="features-box-icon">
                            <span class="fal fa-list-alt icon-md color-primary"></span>
                        </div>
                        <div class="features-box-content">
                            <h5>Custom Control Panel</h5>
                            <p>Our intuitive control panel gives you admin access to all of your DreamHost products.
                                Easily update domain information, add users, adjust email settings gain access.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="features-box">
                        <div class="features-box-icon">
                            <span class="fal fa-thumbs-up icon-md color-primary"></span>
                        </div>
                        <div class="features-box-content">
                            <h5>Real-Life Human Beings</h5>
                            <p>Tech veterans, geeks, and nerds are all standing by to optimize your experience. Whether
                                you get in touch with our support, read our knowledge base, or start a thread.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="features-box">
                        <div class="features-box-icon">
                            <span class="fal fa-check-square icon-md color-primary"></span>
                        </div>
                        <div class="features-box-content">
                            <h5>1-Click Installer</h5>
                            <p>No need to dig into a bunch of documentation. Simply install web apps like WordPress,
                                Joomla! and more. Monotonectally administrate economically sound opportunities.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="features-box">
                        <div class="features-box-icon">
                            <span class="fal fa-history icon-md color-primary"></span>
                        </div>
                        <div class="features-box-content">
                            <h5>100% Uptime Guarantee</h5>
                            <p>With multiple datacenter locations, redundant cooling, emergency generators, and constant
                                monitoring, we are able to offer our 100% Uptime Guarantee.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="features-box">
                        <div class="features-box-icon">
                            <span class="fal fa-folder-open icon-md color-primary"></span>
                        </div>
                        <div class="features-box-content">
                            <h5>Solid State Drives (SSD)</h5>
                            <p>With SSDs, your website, caching, and database queries are faster by our calculations.
                                Quickly orchestrate worldwide niche markets vis-a-vis end-to-end infomediaries. </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="features-box">
                        <div class="features-box-icon">
                            <span class="fal fa-headset icon-md color-primary"></span>
                        </div>
                        <div class="features-box-content">
                            <h5>Award-Winning Support</h5>
                            <p>No question is too simple, or too complex for our team of experts. Synergistically
                                synergize Our in-house support staff and service team are here for you 24/7, 365.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--feature section end-->
    <!--call to action section start-->
    <section class="call-to-action ptb-100 gradient-overlay"
             style="background: url('templates/{$template}/img/hero-bg-4.jpg')no-repeat center center / cover">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="section-heading-center text-center text-white">
                        <h2 class="text-white">30-day Money-back Guarantee</h2>
                        <p class="lead">Globally parallel task granular alignments through excellent intellectual capital. Globally deploy vertical leadership. Authoritatively initiate value-added web services end-to-end solutions. </p>
                        <div class="action-btns">
                            <a href="#" class="btn solid-white-btn animated-btn">Get
                                Started Now</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--call to action section end-->

    <!--faq section start-->
    <section id="faq" class="ptb-100">
        <div class="container">
            <div class="row">
                <div class="col-md-9 col-lg-8">
                    <div class="section-heading mb-5">
                        <h2>Frequently Asked Queries</h2>
                        <p class="lead">Efficiently productivate reliable paradigms before ubiquitous models. Continually utilize
                            frictionless expertise whereas tactical relationships. Still have questions? <a
                                    href="contact.php">Contact us</a></p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div id="accordion" class="accordion faq-wrap">
                        <div class="card mb-3">
                            <a class="card-header " data-toggle="collapse" href="#collapse0" aria-expanded="false">
                                <h6 class="mb-0 d-inline-block">What is Web Hosting?</h6>
                            </a>
                            <div id="collapse0" class="collapse show" data-parent="#accordion" style="">
                                <div class="card-body gray-light-bg">
                                    <p>Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt
                                        sapiente ea proident.
                                        Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                        farm-to-table, raw denim aesthetic
                                        synth nesciunt you probably haven't heard of them accusamus labore sustainable
                                        VHS.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card my-3">
                            <a class="card-header collapsed" data-toggle="collapse" href="#collapse1" aria-expanded="false">
                                <h6 class="mb-0 d-inline-block">What Are the
                                    Different Types of Web Hosting Products DreamHost Offers?</h6>
                            </a>
                            <div id="collapse1" class="collapse " data-parent="#accordion" style="">
                                <div class="card-body gray-light-bg">
                                    <p>Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table,
                                        raw denim aesthetic
                                        synth nesciunt you probably haven't heard of them accusamus labore sustainable
                                        VHS.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card my-3">
                            <a class="card-header collapsed" data-toggle="collapse" href="#collapse2" aria-expanded="false">
                                <h6 class="mb-0 d-inline-block">How Do I Buy a Domain
                                    Name?</h6>
                            </a>
                            <div id="collapse2" class="collapse " data-parent="#accordion" style="">
                                <div class="card-body gray-light-bg">
                                    <p>Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt
                                        sapiente ea proident.
                                        Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                        farm-to-table, raw denim aesthetic
                                        synth nesciunt you probably haven't heard of them accusamus labore sustainable
                                        VHS.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card mt-3">
                            <a class="card-header collapsed" data-toggle="collapse" href="#collapse3" aria-expanded="false">
                                <h6 class="mb-0 d-inline-block">Can You Help Me
                                    Understand More About WordPress?</h6>
                            </a>
                            <div id="collapse3" class="collapse " data-parent="#accordion" style="">
                                <div class="card-body gray-light-bg">
                                    <p>Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt
                                        sapiente ea proident.
                                        Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer
                                        farm-to-table.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--faq section end-->

    <!--testimonial and review section start-->
    <section class="client-review-section ptb-100 gray-light-bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12 col-lg-12">
                    <div class="section-heading-center text-center">
                        <h2>What Our Customers Say About Us?</h2>
                        <p class="lead">Authoritatively reinvent client-centric e-markets via fully tested process improvements. Objectively restore strategic initiatives through fully researched.</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 col-lg-4">
                    <div class="single-testimonial white-bg rounded">
                        <ul class="list-inline ratting-list">
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                        </ul>
                        <div class="ratting-content">
                            <h5>Awesome technical support</h5>
                            <p>Objectively envisioneer magnetic manufactured products and dynamic models. Progressively maximize 2.0 relationships  methodologies.</p>
                        </div>
                        <div class="ratting-author">
                            <h6>Alex Khamer</h6>
                            <small class="text-right">6 days ago</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="single-testimonial white-bg rounded">
                        <ul class="list-inline ratting-list">
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                        </ul>
                        <div class="ratting-content">
                            <h5>Pleasant support experience</h5>
                            <p>Objectively envisioneer magnetic manufactured products and dynamic models.Conveniently re-engineer tactical methodologies via inexpensive.</p>
                        </div>
                        <div class="ratting-author">
                            <h6>Peter Anderson</h6>
                            <small class="text-right">3 days ago</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="single-testimonial white-bg rounded">
                       <ul class="list-inline ratting-list">
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                            <li class="list-inline-item"><span class="fas fa-star"></span></li>
                        </ul>
                        <div class="ratting-content">
                            <h5>Contacted support Midnight</h5>
                            <p>Objectively envisioneer magnetic manufactured products and dynamic models. Globally mesh sustainable scenarios via real-time  deploy stand-alone.</p>
                        </div>
                        <div class="ratting-author">
                            <h6>Jolio Darix</h6>
                            <small class="text-right">8 days ago</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--testimonial and review section end-->
{else}
{include file="$template/includes/kohost-pageheader.tpl"}
{/if}

{include file="$template/includes/validateuser.tpl"}
{include file="$template/includes/verifyemail.tpl"}
<section id="main-body">
    {if !in_array($templatefile, ['login', 'clientregister', 'password-reset-container', 'logout'])}
    <div class="container{if $skipMainBodyContainer}-fluid without-padding{/if}">
        <div class="row">
            {if !$inShoppingCart && ($primarySidebar->hasChildren() || $secondarySidebar->hasChildren())}
                <div class="col-md-3 pull-md-left sidebar">
                    {include file="$template/includes/sidebar.tpl" sidebar=$primarySidebar}
                </div>
            {/if}

            <!-- Container for main page display content -->
            <div class="{if !$inShoppingCart && ($primarySidebar->hasChildren() || $secondarySidebar->hasChildren())}col-md-9 pull-md-right{else}col-xs-12{/if} main-content">
    {/if}